/* SPDX-License-Identifier: GPL-2.0 OR BSD-3-Clause */
/*
 * Copyright (C) 2024-2025 Intel Corporation
 */
#ifndef __iwl_mld_constants_h__
#define __iwl_mld_constants_h__

#define IWL_MLD_MISSED_BEACONS_SINCE_RX_THOLD			4
#define IWL_MLD_MISSED_BEACONS_THRESHOLD			8
#define IWL_MLD_MISSED_BEACONS_THRESHOLD_LONG			19
#define IWL_MLD_BCN_LOSS_EXIT_ESR_THRESH_2_LINKS		5
#define IWL_MLD_BCN_LOSS_EXIT_ESR_THRESH			15
#define IWL_MLD_BCN_LOSS_EXIT_ESR_THRESH_BSS_PARAM_CHANGED	11
#define IWL_MLD_LOW_RSSI_MLO_SCAN_THRESH			-72

#define IWL_MLD_DEFAULT_PS_TX_DATA_TIMEOUT	(100 * USEC_PER_MSEC)
#define IWL_MLD_DEFAULT_PS_RX_DATA_TIMEOUT	(100 * USEC_PER_MSEC)
#define IWL_MLD_WOWLAN_PS_TX_DATA_TIMEOUT	(10 * USEC_PER_MSEC)
#define IWL_MLD_WOWLAN_PS_RX_DATA_TIMEOUT	(10 * USEC_PER_MSEC)
#define IWL_MLD_SHORT_PS_TX_DATA_TIMEOUT	(2 * 1024) /* defined in TU */
#define IWL_MLD_SHORT_PS_RX_DATA_TIMEOUT	(40 * 1024) /* defined in TU */

#define IWL_MLD_UAPSD_RX_DATA_TIMEOUT		(50 * USEC_PER_MSEC)
#define IWL_MLD_UAPSD_TX_DATA_TIMEOUT		(50 * USEC_PER_MSEC)

#define IWL_MLD_PS_SNOOZE_INTERVAL		25
#define IWL_MLD_PS_SNOOZE_INTERVAL		25
#define IWL_MLD_PS_SNOOZE_WINDOW		50

#define IWL_MLD_PS_SNOOZE_HEAVY_TX_THLD_PACKETS	30
#define IWL_MLD_PS_SNOOZE_HEAVY_RX_THLD_PACKETS	20

#define IWL_MLD_PS_HEAVY_TX_THLD_PERCENT	50
#define IWL_MLD_PS_HEAVY_RX_THLD_PERCENT	50
#define IWL_MLD_PS_HEAVY_TX_THLD_PACKETS	20
#define IWL_MLD_PS_HEAVY_RX_THLD_PACKETS	8

#define IWL_MLD_TRIGGER_LINK_SEL_TIME_SEC	30
#define IWL_MLD_SCAN_EXPIRE_TIME_SEC		20

#define IWL_MLD_TPT_COUNT_WINDOW (5 * HZ)

/* OMI reduced BW thresholds (channel load percentage) */
#define IWL_MLD_OMI_ENTER_CHAN_LOAD		10
#define IWL_MLD_OMI_EXIT_CHAN_LOAD_160		20
#define IWL_MLD_OMI_EXIT_CHAN_LOAD_320		30
/* time (in milliseconds) to let AP "settle" the OMI */
#define IWL_MLD_OMI_AP_SETTLE_DELAY		27
/* time (in milliseconds) to not enter OMI reduced BW after leaving */
#define IWL_MLD_OMI_EXIT_PROTECTION		5000

#define IWL_MLD_DIS_RANDOM_FW_ID                false
#define IWL_MLD_D3_DEBUG                        false
#define IWL_MLD_NON_TRANSMITTING_AP	        false
#define IWL_MLD_6GHZ_PASSIVE_SCAN_TIMEOUT       3000 /* in seconds */
#define IWL_MLD_6GHZ_PASSIVE_SCAN_ASSOC_TIMEOUT 60   /* in seconds */
#define IWL_MLD_CONN_LISTEN_INTERVAL		10
#define IWL_MLD_ADAPTIVE_DWELL_NUM_APS_OVERRIDE 0
#define IWL_MLD_AUTO_EML_ENABLE			true

#define IWL_MLD_HIGH_RSSI_THRESH_20MHZ		-67
#define IWL_MLD_LOW_RSSI_THRESH_20MHZ		-72
#define IWL_MLD_HIGH_RSSI_THRESH_40MHZ		-64
#define IWL_MLD_LOW_RSSI_THRESH_40MHZ		-72
#define IWL_MLD_HIGH_RSSI_THRESH_80MHZ		-61
#define IWL_MLD_LOW_RSSI_THRESH_80MHZ		-72
#define IWL_MLD_HIGH_RSSI_THRESH_160MHZ		-58
#define IWL_MLD_LOW_RSSI_THRESH_160MHZ		-72

#define IWL_MLD_ENTER_EMLSR_TPT_THRESH		400
#define IWL_MLD_EXIT_EMLSR_CHAN_LOAD		2 /* in percentage */

#define IWL_MLD_FTM_INITIATOR_ALGO		IWL_TOF_ALGO_TYPE_MAX_LIKE
#define IWL_MLD_FTM_INITIATOR_DYNACK		true
#define IWL_MLD_FTM_LMR_FEEDBACK_TERMINATE	false
#define IWL_MLD_FTM_TEST_INCORRECT_SAC		false
#define IWL_MLD_FTM_R2I_MAX_REP			7
#define IWL_MLD_FTM_I2R_MAX_REP			7
#define IWL_MLD_FTM_R2I_MAX_STS			1
#define IWL_MLD_FTM_I2R_MAX_STS			1
#define IWL_MLD_FTM_R2I_MAX_TOTAL_LTF		3
#define IWL_MLD_FTM_I2R_MAX_TOTAL_LTF		3
#define IWL_MLD_FTM_RESP_NDP_SUPPORT		true
#define IWL_MLD_FTM_RESP_LMR_FEEDBACK_SUPPORT	true
#define IWL_MLD_FTM_NON_TB_MIN_TIME_BETWEEN_MSR	7
#define IWL_MLD_FTM_NON_TB_MAX_TIME_BETWEEN_MSR	1000

#endif /* __iwl_mld_constants_h__ */
