/*
   SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#include "modelsmanager/ollamamodelavailablewidget.h"
#include "ollamamanager.h"
#include "ollamasettings.h"
#include <QApplication>
#include <QCommandLineParser>
#include <QStandardPaths>

int main(int argc, char **argv)
{
    const QApplication app(argc, argv);
    QStandardPaths::setTestModeEnabled(true);
    QCommandLineParser parser;
    parser.addVersionOption();
    parser.addHelpOption();
    parser.process(app);
    OllamaSettings settings;
    auto manager = new OllamaManager(&settings);
    auto w = new OllamaModelAvailableWidget(manager);
    w->setAvailableInfos(manager->availableInfos());
    w->resize(600, 400);
    w->show();
    app.exec();
    delete w;
    return 0;
}
