
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractScrollArea.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAbstractScrollArea>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScrollBar>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionFrame>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractScrollArea

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractScrollArea::staticMetaObject);
}


// void QAbstractScrollArea::addScrollBarWidget(QWidget *widget, QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_addScrollBarWidget_3957 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addScrollBarWidget_3957 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  QFlags<Qt::AlignmentFlag> arg2 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea *)cls)->addScrollBarWidget (arg1, arg2);
}


// QWidget *QAbstractScrollArea::cornerWidget()


static void _init_f_cornerWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_cornerWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QAbstractScrollArea *)cls)->cornerWidget ());
}


// QScrollBar *QAbstractScrollArea::horizontalScrollBar()


static void _init_f_horizontalScrollBar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QScrollBar * > ();
}

static void _call_f_horizontalScrollBar_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QScrollBar * > ((QScrollBar *)((QAbstractScrollArea *)cls)->horizontalScrollBar ());
}


// Qt::ScrollBarPolicy QAbstractScrollArea::horizontalScrollBarPolicy()


static void _init_f_horizontalScrollBarPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ScrollBarPolicy>::target_type > ();
}

static void _call_f_horizontalScrollBarPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::ScrollBarPolicy>::target_type > ((qt_gsi::Converter<Qt::ScrollBarPolicy>::target_type)qt_gsi::CppToQtAdaptor<Qt::ScrollBarPolicy>(((QAbstractScrollArea *)cls)->horizontalScrollBarPolicy ()));
}


// QSize QAbstractScrollArea::maximumViewportSize()


static void _init_f_maximumViewportSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_maximumViewportSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QAbstractScrollArea *)cls)->maximumViewportSize ());
}


// QSize QAbstractScrollArea::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QAbstractScrollArea *)cls)->minimumSizeHint ());
}


// QList<QWidget *> QAbstractScrollArea::scrollBarWidgets(QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_scrollBarWidgets_2750 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alignment");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_0);
  decl->set_return<QList<QWidget *> > ();
}

static void _call_f_scrollBarWidgets_2750 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::AlignmentFlag> arg1 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  ret.write<QList<QWidget *> > ((QList<QWidget *>)((QAbstractScrollArea *)cls)->scrollBarWidgets (arg1));
}


// void QAbstractScrollArea::setCornerWidget(QWidget *widget)


static void _init_f_setCornerWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCornerWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea *)cls)->setCornerWidget (arg1);
}


// void QAbstractScrollArea::setHorizontalScrollBar(QScrollBar *scrollbar)


static void _init_f_setHorizontalScrollBar_1603 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scrollbar");
  decl->add_arg<QScrollBar * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHorizontalScrollBar_1603 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QScrollBar *arg1 = gsi::arg_reader<QScrollBar * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea *)cls)->setHorizontalScrollBar (arg1);
}


// void QAbstractScrollArea::setHorizontalScrollBarPolicy(Qt::ScrollBarPolicy)


static void _init_f_setHorizontalScrollBarPolicy_2273 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::ScrollBarPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHorizontalScrollBarPolicy_2273 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ScrollBarPolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScrollBarPolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea *)cls)->setHorizontalScrollBarPolicy (qt_gsi::QtToCppAdaptor<Qt::ScrollBarPolicy>(arg1).cref());
}


// void QAbstractScrollArea::setSizeAdjustPolicy(QAbstractScrollArea::SizeAdjustPolicy policy)


static void _init_f_setSizeAdjustPolicy_4107 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QAbstractScrollArea::SizeAdjustPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSizeAdjustPolicy_4107 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractScrollArea::SizeAdjustPolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractScrollArea::SizeAdjustPolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea *)cls)->setSizeAdjustPolicy (qt_gsi::QtToCppAdaptor<QAbstractScrollArea::SizeAdjustPolicy>(arg1).cref());
}


// void QAbstractScrollArea::setVerticalScrollBar(QScrollBar *scrollbar)


static void _init_f_setVerticalScrollBar_1603 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scrollbar");
  decl->add_arg<QScrollBar * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVerticalScrollBar_1603 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QScrollBar *arg1 = gsi::arg_reader<QScrollBar * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea *)cls)->setVerticalScrollBar (arg1);
}


// void QAbstractScrollArea::setVerticalScrollBarPolicy(Qt::ScrollBarPolicy)


static void _init_f_setVerticalScrollBarPolicy_2273 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::ScrollBarPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVerticalScrollBarPolicy_2273 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ScrollBarPolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScrollBarPolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea *)cls)->setVerticalScrollBarPolicy (qt_gsi::QtToCppAdaptor<Qt::ScrollBarPolicy>(arg1).cref());
}


// void QAbstractScrollArea::setViewport(QWidget *widget)


static void _init_f_setViewport_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewport_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea *)cls)->setViewport (arg1);
}


// void QAbstractScrollArea::setupViewport(QWidget *viewport)


static void _init_f_setupViewport_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setupViewport_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea *)cls)->setupViewport (arg1);
}


// QAbstractScrollArea::SizeAdjustPolicy QAbstractScrollArea::sizeAdjustPolicy()


static void _init_f_sizeAdjustPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractScrollArea::SizeAdjustPolicy>::target_type > ();
}

static void _call_f_sizeAdjustPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAbstractScrollArea::SizeAdjustPolicy>::target_type > ((qt_gsi::Converter<QAbstractScrollArea::SizeAdjustPolicy>::target_type)qt_gsi::CppToQtAdaptor<QAbstractScrollArea::SizeAdjustPolicy>(((QAbstractScrollArea *)cls)->sizeAdjustPolicy ()));
}


// QSize QAbstractScrollArea::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QAbstractScrollArea *)cls)->sizeHint ());
}


// QScrollBar *QAbstractScrollArea::verticalScrollBar()


static void _init_f_verticalScrollBar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QScrollBar * > ();
}

static void _call_f_verticalScrollBar_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QScrollBar * > ((QScrollBar *)((QAbstractScrollArea *)cls)->verticalScrollBar ());
}


// Qt::ScrollBarPolicy QAbstractScrollArea::verticalScrollBarPolicy()


static void _init_f_verticalScrollBarPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ScrollBarPolicy>::target_type > ();
}

static void _call_f_verticalScrollBarPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::ScrollBarPolicy>::target_type > ((qt_gsi::Converter<Qt::ScrollBarPolicy>::target_type)qt_gsi::CppToQtAdaptor<Qt::ScrollBarPolicy>(((QAbstractScrollArea *)cls)->verticalScrollBarPolicy ()));
}


// QWidget *QAbstractScrollArea::viewport()


static void _init_f_viewport_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_viewport_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QAbstractScrollArea *)cls)->viewport ());
}


// static QString QAbstractScrollArea::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractScrollArea::tr (arg1, arg2, arg3));
}


// static QString QAbstractScrollArea::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractScrollArea::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAbstractScrollArea () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addScrollBarWidget", "@brief Method void QAbstractScrollArea::addScrollBarWidget(QWidget *widget, QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_addScrollBarWidget_3957, &_call_f_addScrollBarWidget_3957);
  methods += new qt_gsi::GenericMethod (":cornerWidget", "@brief Method QWidget *QAbstractScrollArea::cornerWidget()\n", true, &_init_f_cornerWidget_c0, &_call_f_cornerWidget_c0);
  methods += new qt_gsi::GenericMethod (":horizontalScrollBar", "@brief Method QScrollBar *QAbstractScrollArea::horizontalScrollBar()\n", true, &_init_f_horizontalScrollBar_c0, &_call_f_horizontalScrollBar_c0);
  methods += new qt_gsi::GenericMethod (":horizontalScrollBarPolicy", "@brief Method Qt::ScrollBarPolicy QAbstractScrollArea::horizontalScrollBarPolicy()\n", true, &_init_f_horizontalScrollBarPolicy_c0, &_call_f_horizontalScrollBarPolicy_c0);
  methods += new qt_gsi::GenericMethod ("maximumViewportSize", "@brief Method QSize QAbstractScrollArea::maximumViewportSize()\n", true, &_init_f_maximumViewportSize_c0, &_call_f_maximumViewportSize_c0);
  methods += new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QAbstractScrollArea::minimumSizeHint()\nThis is a reimplementation of QWidget::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
  methods += new qt_gsi::GenericMethod ("scrollBarWidgets", "@brief Method QList<QWidget *> QAbstractScrollArea::scrollBarWidgets(QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_scrollBarWidgets_2750, &_call_f_scrollBarWidgets_2750);
  methods += new qt_gsi::GenericMethod ("setCornerWidget|cornerWidget=", "@brief Method void QAbstractScrollArea::setCornerWidget(QWidget *widget)\n", false, &_init_f_setCornerWidget_1315, &_call_f_setCornerWidget_1315);
  methods += new qt_gsi::GenericMethod ("setHorizontalScrollBar|horizontalScrollBar=", "@brief Method void QAbstractScrollArea::setHorizontalScrollBar(QScrollBar *scrollbar)\n", false, &_init_f_setHorizontalScrollBar_1603, &_call_f_setHorizontalScrollBar_1603);
  methods += new qt_gsi::GenericMethod ("setHorizontalScrollBarPolicy|horizontalScrollBarPolicy=", "@brief Method void QAbstractScrollArea::setHorizontalScrollBarPolicy(Qt::ScrollBarPolicy)\n", false, &_init_f_setHorizontalScrollBarPolicy_2273, &_call_f_setHorizontalScrollBarPolicy_2273);
  methods += new qt_gsi::GenericMethod ("setSizeAdjustPolicy|sizeAdjustPolicy=", "@brief Method void QAbstractScrollArea::setSizeAdjustPolicy(QAbstractScrollArea::SizeAdjustPolicy policy)\n", false, &_init_f_setSizeAdjustPolicy_4107, &_call_f_setSizeAdjustPolicy_4107);
  methods += new qt_gsi::GenericMethod ("setVerticalScrollBar|verticalScrollBar=", "@brief Method void QAbstractScrollArea::setVerticalScrollBar(QScrollBar *scrollbar)\n", false, &_init_f_setVerticalScrollBar_1603, &_call_f_setVerticalScrollBar_1603);
  methods += new qt_gsi::GenericMethod ("setVerticalScrollBarPolicy|verticalScrollBarPolicy=", "@brief Method void QAbstractScrollArea::setVerticalScrollBarPolicy(Qt::ScrollBarPolicy)\n", false, &_init_f_setVerticalScrollBarPolicy_2273, &_call_f_setVerticalScrollBarPolicy_2273);
  methods += new qt_gsi::GenericMethod ("setViewport|viewport=", "@brief Method void QAbstractScrollArea::setViewport(QWidget *widget)\n", false, &_init_f_setViewport_1315, &_call_f_setViewport_1315);
  methods += new qt_gsi::GenericMethod ("setupViewport", "@brief Method void QAbstractScrollArea::setupViewport(QWidget *viewport)\n", false, &_init_f_setupViewport_1315, &_call_f_setupViewport_1315);
  methods += new qt_gsi::GenericMethod (":sizeAdjustPolicy", "@brief Method QAbstractScrollArea::SizeAdjustPolicy QAbstractScrollArea::sizeAdjustPolicy()\n", true, &_init_f_sizeAdjustPolicy_c0, &_call_f_sizeAdjustPolicy_c0);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QAbstractScrollArea::sizeHint()\nThis is a reimplementation of QFrame::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod (":verticalScrollBar", "@brief Method QScrollBar *QAbstractScrollArea::verticalScrollBar()\n", true, &_init_f_verticalScrollBar_c0, &_call_f_verticalScrollBar_c0);
  methods += new qt_gsi::GenericMethod (":verticalScrollBarPolicy", "@brief Method Qt::ScrollBarPolicy QAbstractScrollArea::verticalScrollBarPolicy()\n", true, &_init_f_verticalScrollBarPolicy_c0, &_call_f_verticalScrollBarPolicy_c0);
  methods += new qt_gsi::GenericMethod (":viewport", "@brief Method QWidget *QAbstractScrollArea::viewport()\n", true, &_init_f_viewport_c0, &_call_f_viewport_c0);
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QAbstractScrollArea::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAbstractScrollArea::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QAbstractScrollArea::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QAbstractScrollArea::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QAbstractScrollArea::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QAbstractScrollArea::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractScrollArea::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractScrollArea::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QFrame> &qtdecl_QFrame ();

qt_gsi::QtNativeClass<QAbstractScrollArea> decl_QAbstractScrollArea (qtdecl_QFrame (), "QtWidgets", "QAbstractScrollArea_Native",
  methods_QAbstractScrollArea (),
  "@hide\n@alias QAbstractScrollArea");

GSI_QTWIDGETS_PUBLIC gsi::Class<QAbstractScrollArea> &qtdecl_QAbstractScrollArea () { return decl_QAbstractScrollArea; }

}


class QAbstractScrollArea_Adaptor : public QAbstractScrollArea, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractScrollArea_Adaptor();

  //  [adaptor ctor] QAbstractScrollArea::QAbstractScrollArea(QWidget *parent)
  QAbstractScrollArea_Adaptor() : QAbstractScrollArea()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAbstractScrollArea::QAbstractScrollArea(QWidget *parent)
  QAbstractScrollArea_Adaptor(QWidget *parent) : QAbstractScrollArea(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QAbstractScrollArea::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QAbstractScrollArea_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QAbstractScrollArea::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QAbstractScrollArea::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QAbstractScrollArea_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QAbstractScrollArea::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] void QAbstractScrollArea::drawFrame(QPainter *)
  void fp_QAbstractScrollArea_drawFrame_1426 (QPainter *arg1) {
    QAbstractScrollArea::drawFrame(arg1);
  }

  //  [expose] bool QAbstractScrollArea::focusNextChild()
  bool fp_QAbstractScrollArea_focusNextChild_0 () {
    return QAbstractScrollArea::focusNextChild();
  }

  //  [expose] bool QAbstractScrollArea::focusPreviousChild()
  bool fp_QAbstractScrollArea_focusPreviousChild_0 () {
    return QAbstractScrollArea::focusPreviousChild();
  }

  //  [expose] void QAbstractScrollArea::initStyleOption(QStyleOptionFrame *option)
  void fp_QAbstractScrollArea_initStyleOption_c2356 (QStyleOptionFrame *option) const {
    QAbstractScrollArea::initStyleOption(option);
  }

  //  [expose] bool QAbstractScrollArea::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAbstractScrollArea_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAbstractScrollArea::isSignalConnected(signal);
  }

  //  [expose] int QAbstractScrollArea::receivers(const char *signal)
  int fp_QAbstractScrollArea_receivers_c1731 (const char *signal) const {
    return QAbstractScrollArea::receivers(signal);
  }

  //  [expose] QObject *QAbstractScrollArea::sender()
  QObject * fp_QAbstractScrollArea_sender_c0 () const {
    return QAbstractScrollArea::sender();
  }

  //  [expose] int QAbstractScrollArea::senderSignalIndex()
  int fp_QAbstractScrollArea_senderSignalIndex_c0 () const {
    return QAbstractScrollArea::senderSignalIndex();
  }

  //  [expose] void QAbstractScrollArea::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QAbstractScrollArea_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QAbstractScrollArea::setViewportMargins(left, top, right, bottom);
  }

  //  [expose] void QAbstractScrollArea::setViewportMargins(const QMargins &margins)
  void fp_QAbstractScrollArea_setViewportMargins_2115 (const QMargins &margins) {
    QAbstractScrollArea::setViewportMargins(margins);
  }

  //  [expose] void QAbstractScrollArea::updateMicroFocus()
  void fp_QAbstractScrollArea_updateMicroFocus_0 () {
    QAbstractScrollArea::updateMicroFocus();
  }

  //  [expose] QMargins QAbstractScrollArea::viewportMargins()
  QMargins fp_QAbstractScrollArea_viewportMargins_c0 () const {
    return QAbstractScrollArea::viewportMargins();
  }

  //  [emitter impl] void QAbstractScrollArea::customContextMenuRequested(const QPoint &pos)
  void emitter_QAbstractScrollArea_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QAbstractScrollArea::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QAbstractScrollArea::destroyed(QObject *)
  void emitter_QAbstractScrollArea_destroyed_1302(QObject *arg1)
  {
    emit QAbstractScrollArea::destroyed(arg1);
  }

  //  [adaptor impl] bool QAbstractScrollArea::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QAbstractScrollArea::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QAbstractScrollArea_Adaptor, bool>(&QAbstractScrollArea_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QAbstractScrollArea::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QAbstractScrollArea::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QAbstractScrollArea::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QAbstractScrollArea_Adaptor, int, int>(&QAbstractScrollArea_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QAbstractScrollArea::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QAbstractScrollArea::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QAbstractScrollArea::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QAbstractScrollArea_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QAbstractScrollArea_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QAbstractScrollArea::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QAbstractScrollArea::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QAbstractScrollArea::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QAbstractScrollArea_Adaptor, QSize>(&QAbstractScrollArea_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QAbstractScrollArea::minimumSizeHint();
    }
  }

  //  [emitter impl] void QAbstractScrollArea::objectNameChanged(const QString &objectName)
  void emitter_QAbstractScrollArea_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QAbstractScrollArea::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QAbstractScrollArea::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QAbstractScrollArea::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QAbstractScrollArea_Adaptor, QPaintEngine *>(&QAbstractScrollArea_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QAbstractScrollArea::paintEngine();
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QAbstractScrollArea::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QAbstractScrollArea_Adaptor, bool>(&QAbstractScrollArea_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QAbstractScrollArea::setVisible(visible);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::setupViewport(QWidget *viewport)
  void cbs_setupViewport_1315_0(QWidget *viewport)
  {
    QAbstractScrollArea::setupViewport(viewport);
  }

  virtual void setupViewport(QWidget *viewport)
  {
    if (cb_setupViewport_1315_0.can_issue()) {
      cb_setupViewport_1315_0.issue<QAbstractScrollArea_Adaptor, QWidget *>(&QAbstractScrollArea_Adaptor::cbs_setupViewport_1315_0, viewport);
    } else {
      QAbstractScrollArea::setupViewport(viewport);
    }
  }

  //  [adaptor impl] QSize QAbstractScrollArea::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QAbstractScrollArea::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QAbstractScrollArea_Adaptor, QSize>(&QAbstractScrollArea_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QAbstractScrollArea::sizeHint();
    }
  }

  //  [emitter impl] void QAbstractScrollArea::windowIconChanged(const QIcon &icon)
  void emitter_QAbstractScrollArea_windowIconChanged_1787(const QIcon &icon)
  {
    emit QAbstractScrollArea::windowIconChanged(icon);
  }

  //  [emitter impl] void QAbstractScrollArea::windowIconTextChanged(const QString &iconText)
  void emitter_QAbstractScrollArea_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QAbstractScrollArea::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QAbstractScrollArea::windowTitleChanged(const QString &title)
  void emitter_QAbstractScrollArea_windowTitleChanged_2025(const QString &title)
  {
    emit QAbstractScrollArea::windowTitleChanged(title);
  }

  //  [adaptor impl] void QAbstractScrollArea::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QAbstractScrollArea::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QAbstractScrollArea_Adaptor, QActionEvent *>(&QAbstractScrollArea_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QAbstractScrollArea::actionEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QAbstractScrollArea::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QAbstractScrollArea_Adaptor, QEvent *>(&QAbstractScrollArea_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QAbstractScrollArea::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QAbstractScrollArea::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractScrollArea_Adaptor, QChildEvent *>(&QAbstractScrollArea_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QAbstractScrollArea::childEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QAbstractScrollArea::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QAbstractScrollArea_Adaptor, QCloseEvent *>(&QAbstractScrollArea_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QAbstractScrollArea::closeEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QAbstractScrollArea::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QAbstractScrollArea_Adaptor, QContextMenuEvent *>(&QAbstractScrollArea_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QAbstractScrollArea::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QAbstractScrollArea::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractScrollArea_Adaptor, QEvent *>(&QAbstractScrollArea_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QAbstractScrollArea::customEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAbstractScrollArea::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAbstractScrollArea_Adaptor, const QMetaMethod &>(&QAbstractScrollArea_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAbstractScrollArea::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QAbstractScrollArea::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QAbstractScrollArea_Adaptor, QDragEnterEvent *>(&QAbstractScrollArea_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QAbstractScrollArea::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QAbstractScrollArea::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QAbstractScrollArea_Adaptor, QDragLeaveEvent *>(&QAbstractScrollArea_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QAbstractScrollArea::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QAbstractScrollArea::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QAbstractScrollArea_Adaptor, QDragMoveEvent *>(&QAbstractScrollArea_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QAbstractScrollArea::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QAbstractScrollArea::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QAbstractScrollArea_Adaptor, QDropEvent *>(&QAbstractScrollArea_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QAbstractScrollArea::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::enterEvent(QEvent *event)
  void cbs_enterEvent_1217_0(QEvent *event)
  {
    QAbstractScrollArea::enterEvent(event);
  }

  virtual void enterEvent(QEvent *event)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QAbstractScrollArea_Adaptor, QEvent *>(&QAbstractScrollArea_Adaptor::cbs_enterEvent_1217_0, event);
    } else {
      QAbstractScrollArea::enterEvent(event);
    }
  }

  //  [adaptor impl] bool QAbstractScrollArea::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAbstractScrollArea::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractScrollArea_Adaptor, bool, QEvent *>(&QAbstractScrollArea_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAbstractScrollArea::event(arg1);
    }
  }

  //  [adaptor impl] bool QAbstractScrollArea::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAbstractScrollArea::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractScrollArea_Adaptor, bool, QObject *, QEvent *>(&QAbstractScrollArea_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAbstractScrollArea::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QAbstractScrollArea::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QAbstractScrollArea_Adaptor, QFocusEvent *>(&QAbstractScrollArea_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QAbstractScrollArea::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QAbstractScrollArea::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QAbstractScrollArea::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QAbstractScrollArea_Adaptor, bool, bool>(&QAbstractScrollArea_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QAbstractScrollArea::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QAbstractScrollArea::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QAbstractScrollArea_Adaptor, QFocusEvent *>(&QAbstractScrollArea_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QAbstractScrollArea::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QAbstractScrollArea::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QAbstractScrollArea_Adaptor, QHideEvent *>(&QAbstractScrollArea_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QAbstractScrollArea::hideEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QAbstractScrollArea::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QAbstractScrollArea_Adaptor, QPainter *>(&QAbstractScrollArea_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QAbstractScrollArea::initPainter(painter);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QAbstractScrollArea::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QAbstractScrollArea_Adaptor, QInputMethodEvent *>(&QAbstractScrollArea_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QAbstractScrollArea::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QAbstractScrollArea::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QAbstractScrollArea_Adaptor, QKeyEvent *>(&QAbstractScrollArea_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QAbstractScrollArea::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QAbstractScrollArea::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QAbstractScrollArea_Adaptor, QKeyEvent *>(&QAbstractScrollArea_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QAbstractScrollArea::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QAbstractScrollArea::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QAbstractScrollArea_Adaptor, QEvent *>(&QAbstractScrollArea_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QAbstractScrollArea::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QAbstractScrollArea::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QAbstractScrollArea::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QAbstractScrollArea_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QAbstractScrollArea_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QAbstractScrollArea::metric(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QAbstractScrollArea::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QAbstractScrollArea_Adaptor, QMouseEvent *>(&QAbstractScrollArea_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QAbstractScrollArea::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QAbstractScrollArea::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QAbstractScrollArea_Adaptor, QMouseEvent *>(&QAbstractScrollArea_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QAbstractScrollArea::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QAbstractScrollArea::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QAbstractScrollArea_Adaptor, QMouseEvent *>(&QAbstractScrollArea_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QAbstractScrollArea::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QAbstractScrollArea::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QAbstractScrollArea_Adaptor, QMouseEvent *>(&QAbstractScrollArea_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QAbstractScrollArea::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QAbstractScrollArea::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QAbstractScrollArea_Adaptor, QMoveEvent *>(&QAbstractScrollArea_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QAbstractScrollArea::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QAbstractScrollArea::nativeEvent(const QByteArray &eventType, void *message, long int *result)
  bool cbs_nativeEvent_4678_0(const QByteArray &eventType, void *message, long int *result)
  {
    return QAbstractScrollArea::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, long int *result)
  {
    if (cb_nativeEvent_4678_0.can_issue()) {
      return cb_nativeEvent_4678_0.issue<QAbstractScrollArea_Adaptor, bool, const QByteArray &, void *, long int *>(&QAbstractScrollArea_Adaptor::cbs_nativeEvent_4678_0, eventType, message, result);
    } else {
      return QAbstractScrollArea::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QAbstractScrollArea::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QAbstractScrollArea_Adaptor, QPaintEvent *>(&QAbstractScrollArea_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QAbstractScrollArea::paintEvent(arg1);
    }
  }

  //  [adaptor impl] QPaintDevice *QAbstractScrollArea::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QAbstractScrollArea::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QAbstractScrollArea_Adaptor, QPaintDevice *, QPoint *>(&QAbstractScrollArea_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QAbstractScrollArea::redirected(offset);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QAbstractScrollArea::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QAbstractScrollArea_Adaptor, QResizeEvent *>(&QAbstractScrollArea_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QAbstractScrollArea::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QAbstractScrollArea::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QAbstractScrollArea_Adaptor, int, int>(&QAbstractScrollArea_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QAbstractScrollArea::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] QPainter *QAbstractScrollArea::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QAbstractScrollArea::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QAbstractScrollArea_Adaptor, QPainter *>(&QAbstractScrollArea_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QAbstractScrollArea::sharedPainter();
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QAbstractScrollArea::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QAbstractScrollArea_Adaptor, QShowEvent *>(&QAbstractScrollArea_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QAbstractScrollArea::showEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QAbstractScrollArea::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QAbstractScrollArea_Adaptor, QTabletEvent *>(&QAbstractScrollArea_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QAbstractScrollArea::tabletEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QAbstractScrollArea::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractScrollArea_Adaptor, QTimerEvent *>(&QAbstractScrollArea_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QAbstractScrollArea::timerEvent(event);
    }
  }

  //  [adaptor impl] bool QAbstractScrollArea::viewportEvent(QEvent *)
  bool cbs_viewportEvent_1217_0(QEvent *arg1)
  {
    return QAbstractScrollArea::viewportEvent(arg1);
  }

  virtual bool viewportEvent(QEvent *arg1)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QAbstractScrollArea_Adaptor, bool, QEvent *>(&QAbstractScrollArea_Adaptor::cbs_viewportEvent_1217_0, arg1);
    } else {
      return QAbstractScrollArea::viewportEvent(arg1);
    }
  }

  //  [adaptor impl] QSize QAbstractScrollArea::viewportSizeHint()
  QSize cbs_viewportSizeHint_c0_0() const
  {
    return QAbstractScrollArea::viewportSizeHint();
  }

  virtual QSize viewportSizeHint() const
  {
    if (cb_viewportSizeHint_c0_0.can_issue()) {
      return cb_viewportSizeHint_c0_0.issue<QAbstractScrollArea_Adaptor, QSize>(&QAbstractScrollArea_Adaptor::cbs_viewportSizeHint_c0_0);
    } else {
      return QAbstractScrollArea::viewportSizeHint();
    }
  }

  //  [adaptor impl] void QAbstractScrollArea::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QAbstractScrollArea::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QAbstractScrollArea_Adaptor, QWheelEvent *>(&QAbstractScrollArea_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QAbstractScrollArea::wheelEvent(arg1);
    }
  }

  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_setupViewport_1315_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_4678_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_viewportSizeHint_c0_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QAbstractScrollArea_Adaptor::~QAbstractScrollArea_Adaptor() { }

//  Constructor QAbstractScrollArea::QAbstractScrollArea(QWidget *parent) (adaptor class)

static void _init_ctor_QAbstractScrollArea_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QAbstractScrollArea_Adaptor> ();
}

static void _call_ctor_QAbstractScrollArea_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QAbstractScrollArea_Adaptor *> (new QAbstractScrollArea_Adaptor (arg1));
}


// void QAbstractScrollArea::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QAbstractScrollArea::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QAbstractScrollArea::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAbstractScrollArea::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QAbstractScrollArea::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QAbstractScrollArea::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_create_2208 (arg1, arg2, arg3);
}


// emitter void QAbstractScrollArea::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QAbstractScrollArea_Adaptor *)cls)->emitter_QAbstractScrollArea_customContextMenuRequested_1916 (arg1);
}


// void QAbstractScrollArea::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QAbstractScrollArea::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_destroy_1620 (arg1, arg2);
}


// emitter void QAbstractScrollArea::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QAbstractScrollArea_Adaptor *)cls)->emitter_QAbstractScrollArea_destroyed_1302 (arg1);
}


// void QAbstractScrollArea::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QAbstractScrollArea::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QAbstractScrollArea::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QAbstractScrollArea::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// exposed void QAbstractScrollArea::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_drawFrame_1426 (arg1);
}


// void QAbstractScrollArea::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QAbstractScrollArea::enterEvent(QEvent *event)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QAbstractScrollArea::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractScrollArea_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAbstractScrollArea::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractScrollArea_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QAbstractScrollArea::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QAbstractScrollArea::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_focusNextChild_0 ());
}


// bool QAbstractScrollArea::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QAbstractScrollArea_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QAbstractScrollArea::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QAbstractScrollArea::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_focusPreviousChild_0 ());
}


// bool QAbstractScrollArea::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAbstractScrollArea_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QAbstractScrollArea::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QAbstractScrollArea_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QAbstractScrollArea::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QAbstractScrollArea::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// exposed void QAbstractScrollArea::initStyleOption(QStyleOptionFrame *option)

static void _init_fp_initStyleOption_c2356 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionFrame * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_initStyleOption_c2356 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionFrame *arg1 = gsi::arg_reader<QStyleOptionFrame * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_initStyleOption_c2356 (arg1);
}


// void QAbstractScrollArea::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QAbstractScrollArea::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QAbstractScrollArea_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QAbstractScrollArea::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_isSignalConnected_c2394 (arg1));
}


// void QAbstractScrollArea::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QAbstractScrollArea::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QAbstractScrollArea::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QAbstractScrollArea::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QAbstractScrollArea_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QAbstractScrollArea::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QAbstractScrollArea_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QAbstractScrollArea::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QAbstractScrollArea::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QAbstractScrollArea::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QAbstractScrollArea::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QAbstractScrollArea::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QAbstractScrollArea::nativeEvent(const QByteArray &eventType, void *message, long int *result)

static void _init_cbs_nativeEvent_4678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<long int * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_4678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  long int *arg3 = args.read<long int * > (heap);
  ret.write<bool > ((bool)((QAbstractScrollArea_Adaptor *)cls)->cbs_nativeEvent_4678_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_4678_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_nativeEvent_4678_0 = cb;
}


// emitter void QAbstractScrollArea::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QAbstractScrollArea_Adaptor *)cls)->emitter_QAbstractScrollArea_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QAbstractScrollArea::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QAbstractScrollArea_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QAbstractScrollArea::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QAbstractScrollArea::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_receivers_c1731 (arg1));
}


// QPaintDevice *QAbstractScrollArea::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QAbstractScrollArea_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QAbstractScrollArea::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// void QAbstractScrollArea::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}


// exposed QObject *QAbstractScrollArea::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_sender_c0 ());
}


// exposed int QAbstractScrollArea::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_senderSignalIndex_c0 ());
}


// exposed void QAbstractScrollArea::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}


// exposed void QAbstractScrollArea::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = gsi::arg_reader<const QMargins & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_setViewportMargins_2115 (arg1);
}


// void QAbstractScrollArea::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QAbstractScrollArea::setupViewport(QWidget *viewport)

static void _init_cbs_setupViewport_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setupViewport_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_setupViewport_1315_0 (arg1);
}

static void _set_callback_cbs_setupViewport_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_setupViewport_1315_0 = cb;
}


// QPainter *QAbstractScrollArea::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QAbstractScrollArea_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QAbstractScrollArea::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QAbstractScrollArea::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QAbstractScrollArea_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QAbstractScrollArea::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QAbstractScrollArea::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QAbstractScrollArea::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_updateMicroFocus_0 ();
}


// bool QAbstractScrollArea::viewportEvent(QEvent *)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractScrollArea_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}


// exposed QMargins QAbstractScrollArea::viewportMargins()

static void _init_fp_viewportMargins_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMargins > ();
}

static void _call_fp_viewportMargins_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMargins > ((QMargins)((QAbstractScrollArea_Adaptor *)cls)->fp_QAbstractScrollArea_viewportMargins_c0 ());
}


// QSize QAbstractScrollArea::viewportSizeHint()

static void _init_cbs_viewportSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_viewportSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QAbstractScrollArea_Adaptor *)cls)->cbs_viewportSizeHint_c0_0 ());
}

static void _set_callback_cbs_viewportSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_viewportSizeHint_c0_0 = cb;
}


// void QAbstractScrollArea::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractScrollArea_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractScrollArea_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QAbstractScrollArea::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QAbstractScrollArea_Adaptor *)cls)->emitter_QAbstractScrollArea_windowIconChanged_1787 (arg1);
}


// emitter void QAbstractScrollArea::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QAbstractScrollArea_Adaptor *)cls)->emitter_QAbstractScrollArea_windowIconTextChanged_2025 (arg1);
}


// emitter void QAbstractScrollArea::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QAbstractScrollArea_Adaptor *)cls)->emitter_QAbstractScrollArea_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QAbstractScrollArea> &qtdecl_QAbstractScrollArea ();

static gsi::Methods methods_QAbstractScrollArea_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractScrollArea::QAbstractScrollArea(QWidget *parent)\nThis method creates an object of class QAbstractScrollArea.", &_init_ctor_QAbstractScrollArea_Adaptor_1315, &_call_ctor_QAbstractScrollArea_Adaptor_1315);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QAbstractScrollArea::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QAbstractScrollArea::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractScrollArea::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QAbstractScrollArea::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QAbstractScrollArea::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*create|qt_create", "@brief Method void QAbstractScrollArea::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QAbstractScrollArea::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractScrollArea::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*destroy|qt_destroy", "@brief Method void QAbstractScrollArea::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QAbstractScrollArea::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractScrollArea::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QAbstractScrollArea::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QAbstractScrollArea::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QAbstractScrollArea::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*drawFrame", "@brief Method void QAbstractScrollArea::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QAbstractScrollArea::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QAbstractScrollArea::enterEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QAbstractScrollArea::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QAbstractScrollArea::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QAbstractScrollArea::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QAbstractScrollArea::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QAbstractScrollArea::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QAbstractScrollArea::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QAbstractScrollArea::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QAbstractScrollArea::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QAbstractScrollArea::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QAbstractScrollArea::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QAbstractScrollArea::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Method void QAbstractScrollArea::initStyleOption(QStyleOptionFrame *option)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_initStyleOption_c2356, &_call_fp_initStyleOption_c2356);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QAbstractScrollArea::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QAbstractScrollArea::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAbstractScrollArea::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QAbstractScrollArea::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QAbstractScrollArea::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QAbstractScrollArea::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QAbstractScrollArea::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QAbstractScrollArea::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QAbstractScrollArea::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QAbstractScrollArea::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QAbstractScrollArea::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QAbstractScrollArea::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QAbstractScrollArea::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QAbstractScrollArea::nativeEvent(const QByteArray &eventType, void *message, long int *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0, &_set_callback_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QAbstractScrollArea::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QAbstractScrollArea::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QAbstractScrollArea::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAbstractScrollArea::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QAbstractScrollArea::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QAbstractScrollArea::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QAbstractScrollArea::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAbstractScrollArea::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAbstractScrollArea::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QAbstractScrollArea::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QAbstractScrollArea::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QAbstractScrollArea::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setupViewport", "@brief Virtual method void QAbstractScrollArea::setupViewport(QWidget *viewport)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("setupViewport", "@hide", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0, &_set_callback_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QAbstractScrollArea::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QAbstractScrollArea::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QAbstractScrollArea::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QAbstractScrollArea::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractScrollArea::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QAbstractScrollArea::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QAbstractScrollArea::viewportEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportMargins", "@brief Method QMargins QAbstractScrollArea::viewportMargins()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_viewportMargins_c0, &_call_fp_viewportMargins_c0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@brief Virtual method QSize QAbstractScrollArea::viewportSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@hide", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0, &_set_callback_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QAbstractScrollArea::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QAbstractScrollArea::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QAbstractScrollArea::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QAbstractScrollArea::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QAbstractScrollArea_Adaptor> decl_QAbstractScrollArea_Adaptor (qtdecl_QAbstractScrollArea (), "QtWidgets", "QAbstractScrollArea",
  methods_QAbstractScrollArea_Adaptor (),
  "@qt\n@brief Binding of QAbstractScrollArea");

}


//  Implementation of the enum wrapper class for QAbstractScrollArea::SizeAdjustPolicy
namespace qt_gsi
{

static gsi::Enum<QAbstractScrollArea::SizeAdjustPolicy> decl_QAbstractScrollArea_SizeAdjustPolicy_Enum ("QtWidgets", "QAbstractScrollArea_SizeAdjustPolicy",
    gsi::enum_const ("AdjustIgnored", QAbstractScrollArea::AdjustIgnored, "@brief Enum constant QAbstractScrollArea::AdjustIgnored") +
    gsi::enum_const ("AdjustToContentsOnFirstShow", QAbstractScrollArea::AdjustToContentsOnFirstShow, "@brief Enum constant QAbstractScrollArea::AdjustToContentsOnFirstShow") +
    gsi::enum_const ("AdjustToContents", QAbstractScrollArea::AdjustToContents, "@brief Enum constant QAbstractScrollArea::AdjustToContents"),
  "@qt\n@brief This class represents the QAbstractScrollArea::SizeAdjustPolicy enum");

static gsi::QFlagsClass<QAbstractScrollArea::SizeAdjustPolicy > decl_QAbstractScrollArea_SizeAdjustPolicy_Enums ("QtWidgets", "QAbstractScrollArea_QFlags_SizeAdjustPolicy",
  "@qt\n@brief This class represents the QFlags<QAbstractScrollArea::SizeAdjustPolicy> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractScrollArea> inject_QAbstractScrollArea_SizeAdjustPolicy_Enum_in_parent (decl_QAbstractScrollArea_SizeAdjustPolicy_Enum.defs ());
static gsi::ClassExt<QAbstractScrollArea> decl_QAbstractScrollArea_SizeAdjustPolicy_Enum_as_child (decl_QAbstractScrollArea_SizeAdjustPolicy_Enum, "SizeAdjustPolicy");
static gsi::ClassExt<QAbstractScrollArea> decl_QAbstractScrollArea_SizeAdjustPolicy_Enums_as_child (decl_QAbstractScrollArea_SizeAdjustPolicy_Enums, "QFlags_SizeAdjustPolicy");

}

