
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractListModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAbstractListModel>
#include <QChildEvent>
#include <QDataStream>
#include <QEvent>
#include <QMetaMethod>
#include <QMimeData>
#include <QModelIndex>
#include <QObject>
#include <QPersistentModelIndex>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include "gsiDeclQtCoreTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractListModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractListModel::staticMetaObject);
}


// bool QAbstractListModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)


static void _init_f_dropMimeData_7425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_f_dropMimeData_7425 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = gsi::arg_reader<const QMimeData * >() (args, heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::DropAction>::target_type & >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg5 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractListModel *)cls)->dropMimeData (arg1, qt_gsi::QtToCppAdaptor<Qt::DropAction>(arg2).cref(), arg3, arg4, arg5));
}


// QFlags<Qt::ItemFlag> QAbstractListModel::flags(const QModelIndex &index)


static void _init_f_flags_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_f_flags_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QAbstractListModel *)cls)->flags (arg1));
}


// QModelIndex QAbstractListModel::index(int row, int column, const QModelIndex &parent)


static void _init_f_index_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column", true, "0");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_f_index_c3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<QModelIndex > ((QModelIndex)((QAbstractListModel *)cls)->index (arg1, arg2, arg3));
}


// QObject *QAbstractListModel::parent()


static void _init_f_parent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_f_parent_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAbstractListModel *)cls)->parent ());
}


// QModelIndex QAbstractListModel::sibling(int row, int column, const QModelIndex &idx)


static void _init_f_sibling_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_f_sibling_c3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QAbstractListModel *)cls)->sibling (arg1, arg2, arg3));
}


// static QString QAbstractListModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractListModel::tr (arg1, arg2, arg3));
}


// static QString QAbstractListModel::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractListModel::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAbstractListModel () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@brief Method bool QAbstractListModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::dropMimeData", false, &_init_f_dropMimeData_7425, &_call_f_dropMimeData_7425);
  methods += new qt_gsi::GenericMethod ("flags", "@brief Method QFlags<Qt::ItemFlag> QAbstractListModel::flags(const QModelIndex &index)\nThis is a reimplementation of QAbstractItemModel::flags", true, &_init_f_flags_c2395, &_call_f_flags_c2395);
  methods += new qt_gsi::GenericMethod ("index", "@brief Method QModelIndex QAbstractListModel::index(int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::index", true, &_init_f_index_c3713, &_call_f_index_c3713);
  methods += new qt_gsi::GenericMethod (":parent", "@brief Method QObject *QAbstractListModel::parent()\n", true, &_init_f_parent_c0, &_call_f_parent_c0);
  methods += new qt_gsi::GenericMethod ("sibling", "@brief Method QModelIndex QAbstractListModel::sibling(int row, int column, const QModelIndex &idx)\nThis is a reimplementation of QAbstractItemModel::sibling", true, &_init_f_sibling_c3713, &_call_f_sibling_c3713);
  methods += gsi::qt_signal<const QModelIndex &, const QModelIndex &, const QVector<int> & > ("dataChanged(const QModelIndex &, const QModelIndex &, const QVector<int> &)", "dataChanged", gsi::arg("topLeft"), gsi::arg("bottomRight"), gsi::arg("roles"), "@brief Signal declaration for QAbstractListModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAbstractListModel::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int > ("headerDataChanged(Qt::Orientation, int, int)", "headerDataChanged", gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QAbstractListModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutAboutToBeChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutAboutToBeChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QAbstractListModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QAbstractListModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractListModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractListModel::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QAbstractItemModel> &qtdecl_QAbstractItemModel ();

qt_gsi::QtNativeClass<QAbstractListModel> decl_QAbstractListModel (qtdecl_QAbstractItemModel (), "QtCore", "QAbstractListModel_Native",
  methods_QAbstractListModel (),
  "@hide\n@alias QAbstractListModel");

GSI_QTCORE_PUBLIC gsi::Class<QAbstractListModel> &qtdecl_QAbstractListModel () { return decl_QAbstractListModel; }

}


class QAbstractListModel_Adaptor : public QAbstractListModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractListModel_Adaptor();

  //  [adaptor ctor] QAbstractListModel::QAbstractListModel(QObject *parent)
  QAbstractListModel_Adaptor() : QAbstractListModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAbstractListModel::QAbstractListModel(QObject *parent)
  QAbstractListModel_Adaptor(QObject *parent) : QAbstractListModel(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QAbstractListModel::beginInsertColumns(const QModelIndex &parent, int first, int last)
  void fp_QAbstractListModel_beginInsertColumns_3713 (const QModelIndex &parent, int first, int last) {
    QAbstractListModel::beginInsertColumns(parent, first, last);
  }

  //  [expose] void QAbstractListModel::beginInsertRows(const QModelIndex &parent, int first, int last)
  void fp_QAbstractListModel_beginInsertRows_3713 (const QModelIndex &parent, int first, int last) {
    QAbstractListModel::beginInsertRows(parent, first, last);
  }

  //  [expose] bool QAbstractListModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)
  bool fp_QAbstractListModel_beginMoveColumns_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn) {
    return QAbstractListModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn);
  }

  //  [expose] bool QAbstractListModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)
  bool fp_QAbstractListModel_beginMoveRows_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow) {
    return QAbstractListModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow);
  }

  //  [expose] void QAbstractListModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)
  void fp_QAbstractListModel_beginRemoveColumns_3713 (const QModelIndex &parent, int first, int last) {
    QAbstractListModel::beginRemoveColumns(parent, first, last);
  }

  //  [expose] void QAbstractListModel::beginRemoveRows(const QModelIndex &parent, int first, int last)
  void fp_QAbstractListModel_beginRemoveRows_3713 (const QModelIndex &parent, int first, int last) {
    QAbstractListModel::beginRemoveRows(parent, first, last);
  }

  //  [expose] void QAbstractListModel::beginResetModel()
  void fp_QAbstractListModel_beginResetModel_0 () {
    QAbstractListModel::beginResetModel();
  }

  //  [expose] void QAbstractListModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)
  void fp_QAbstractListModel_changePersistentIndex_4682 (const QModelIndex &from, const QModelIndex &to) {
    QAbstractListModel::changePersistentIndex(from, to);
  }

  //  [expose] void QAbstractListModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)
  void fp_QAbstractListModel_changePersistentIndexList_5912 (const QList<QModelIndex> &from, const QList<QModelIndex> &to) {
    QAbstractListModel::changePersistentIndexList(from, to);
  }

  //  [expose] QModelIndex QAbstractListModel::createIndex(int row, int column, void *data)
  QModelIndex fp_QAbstractListModel_createIndex_c2374 (int row, int column, void *data) const {
    return QAbstractListModel::createIndex(row, column, data);
  }

  //  [expose] QModelIndex QAbstractListModel::createIndex(int row, int column, quintptr id)
  QModelIndex fp_QAbstractListModel_createIndex_c2657 (int row, int column, quintptr id) const {
    return QAbstractListModel::createIndex(row, column, id);
  }

  //  [expose] bool QAbstractListModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)
  bool fp_QAbstractListModel_decodeData_5302 (int row, int column, const QModelIndex &parent, QDataStream &stream) {
    return QAbstractListModel::decodeData(row, column, parent, stream);
  }

  //  [expose] void QAbstractListModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)
  void fp_QAbstractListModel_encodeData_c4599 (const QList<QModelIndex> &indexes, QDataStream &stream) const {
    QAbstractListModel::encodeData(indexes, stream);
  }

  //  [expose] void QAbstractListModel::endInsertColumns()
  void fp_QAbstractListModel_endInsertColumns_0 () {
    QAbstractListModel::endInsertColumns();
  }

  //  [expose] void QAbstractListModel::endInsertRows()
  void fp_QAbstractListModel_endInsertRows_0 () {
    QAbstractListModel::endInsertRows();
  }

  //  [expose] void QAbstractListModel::endMoveColumns()
  void fp_QAbstractListModel_endMoveColumns_0 () {
    QAbstractListModel::endMoveColumns();
  }

  //  [expose] void QAbstractListModel::endMoveRows()
  void fp_QAbstractListModel_endMoveRows_0 () {
    QAbstractListModel::endMoveRows();
  }

  //  [expose] void QAbstractListModel::endRemoveColumns()
  void fp_QAbstractListModel_endRemoveColumns_0 () {
    QAbstractListModel::endRemoveColumns();
  }

  //  [expose] void QAbstractListModel::endRemoveRows()
  void fp_QAbstractListModel_endRemoveRows_0 () {
    QAbstractListModel::endRemoveRows();
  }

  //  [expose] void QAbstractListModel::endResetModel()
  void fp_QAbstractListModel_endResetModel_0 () {
    QAbstractListModel::endResetModel();
  }

  //  [expose] bool QAbstractListModel::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAbstractListModel_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAbstractListModel::isSignalConnected(signal);
  }

  //  [expose] QList<QModelIndex> QAbstractListModel::persistentIndexList()
  QList<QModelIndex> fp_QAbstractListModel_persistentIndexList_c0 () const {
    return QAbstractListModel::persistentIndexList();
  }

  //  [expose] int QAbstractListModel::receivers(const char *signal)
  int fp_QAbstractListModel_receivers_c1731 (const char *signal) const {
    return QAbstractListModel::receivers(signal);
  }

  //  [expose] void QAbstractListModel::resetInternalData()
  void fp_QAbstractListModel_resetInternalData_0 () {
    QAbstractListModel::resetInternalData();
  }

  //  [expose] QObject *QAbstractListModel::sender()
  QObject * fp_QAbstractListModel_sender_c0 () const {
    return QAbstractListModel::sender();
  }

  //  [expose] int QAbstractListModel::senderSignalIndex()
  int fp_QAbstractListModel_senderSignalIndex_c0 () const {
    return QAbstractListModel::senderSignalIndex();
  }

  //  [adaptor impl] QModelIndex QAbstractListModel::buddy(const QModelIndex &index)
  QModelIndex cbs_buddy_c2395_0(const QModelIndex &index) const
  {
    return QAbstractListModel::buddy(index);
  }

  virtual QModelIndex buddy(const QModelIndex &index) const
  {
    if (cb_buddy_c2395_0.can_issue()) {
      return cb_buddy_c2395_0.issue<QAbstractListModel_Adaptor, QModelIndex, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_buddy_c2395_0, index);
    } else {
      return QAbstractListModel::buddy(index);
    }
  }

  //  [adaptor impl] bool QAbstractListModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_canDropMimeData_c7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent) const
  {
    return QAbstractListModel::canDropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent) const
  {
    if (cb_canDropMimeData_c7425_0.can_issue()) {
      return cb_canDropMimeData_c7425_0.issue<QAbstractListModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_canDropMimeData_c7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QAbstractListModel::canDropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QAbstractListModel::canFetchMore(const QModelIndex &parent)
  bool cbs_canFetchMore_c2395_0(const QModelIndex &parent) const
  {
    return QAbstractListModel::canFetchMore(parent);
  }

  virtual bool canFetchMore(const QModelIndex &parent) const
  {
    if (cb_canFetchMore_c2395_0.can_issue()) {
      return cb_canFetchMore_c2395_0.issue<QAbstractListModel_Adaptor, bool, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_canFetchMore_c2395_0, parent);
    } else {
      return QAbstractListModel::canFetchMore(parent);
    }
  }

  //  [adaptor impl] QVariant QAbstractListModel::data(const QModelIndex &index, int role)
  QVariant cbs_data_c3054_1(const QModelIndex &index, int role) const
  {
    __SUPPRESS_UNUSED_WARNING (index);
    __SUPPRESS_UNUSED_WARNING (role);
    throw qt_gsi::AbstractMethodCalledException("data");
  }

  virtual QVariant data(const QModelIndex &index, int role) const
  {
    if (cb_data_c3054_1.can_issue()) {
      return cb_data_c3054_1.issue<QAbstractListModel_Adaptor, QVariant, const QModelIndex &, int>(&QAbstractListModel_Adaptor::cbs_data_c3054_1, index, role);
    } else {
      throw qt_gsi::AbstractMethodCalledException("data");
    }
  }

  //  [emitter impl] void QAbstractListModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)
  void emitter_QAbstractListModel_dataChanged_7048(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)
  {
    emit QAbstractListModel::dataChanged(topLeft, bottomRight, roles);
  }

  //  [emitter impl] void QAbstractListModel::destroyed(QObject *)
  void emitter_QAbstractListModel_destroyed_1302(QObject *arg1)
  {
    emit QAbstractListModel::destroyed(arg1);
  }

  //  [adaptor impl] bool QAbstractListModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_dropMimeData_7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent)
  {
    return QAbstractListModel::dropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  {
    if (cb_dropMimeData_7425_0.can_issue()) {
      return cb_dropMimeData_7425_0.issue<QAbstractListModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_dropMimeData_7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QAbstractListModel::dropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QAbstractListModel::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAbstractListModel::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractListModel_Adaptor, bool, QEvent *>(&QAbstractListModel_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAbstractListModel::event(arg1);
    }
  }

  //  [adaptor impl] bool QAbstractListModel::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAbstractListModel::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractListModel_Adaptor, bool, QObject *, QEvent *>(&QAbstractListModel_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAbstractListModel::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QAbstractListModel::fetchMore(const QModelIndex &parent)
  void cbs_fetchMore_2395_0(const QModelIndex &parent)
  {
    QAbstractListModel::fetchMore(parent);
  }

  virtual void fetchMore(const QModelIndex &parent)
  {
    if (cb_fetchMore_2395_0.can_issue()) {
      cb_fetchMore_2395_0.issue<QAbstractListModel_Adaptor, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_fetchMore_2395_0, parent);
    } else {
      QAbstractListModel::fetchMore(parent);
    }
  }

  //  [adaptor impl] QFlags<Qt::ItemFlag> QAbstractListModel::flags(const QModelIndex &index)
  QFlags<Qt::ItemFlag> cbs_flags_c2395_0(const QModelIndex &index) const
  {
    return QAbstractListModel::flags(index);
  }

  virtual QFlags<Qt::ItemFlag> flags(const QModelIndex &index) const
  {
    if (cb_flags_c2395_0.can_issue()) {
      return cb_flags_c2395_0.issue<QAbstractListModel_Adaptor, QFlags<Qt::ItemFlag>, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_flags_c2395_0, index);
    } else {
      return QAbstractListModel::flags(index);
    }
  }

  //  [adaptor impl] QVariant QAbstractListModel::headerData(int section, Qt::Orientation orientation, int role)
  QVariant cbs_headerData_c3231_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, int role) const
  {
    return QAbstractListModel::headerData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), role);
  }

  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const
  {
    if (cb_headerData_c3231_1.can_issue()) {
      return cb_headerData_c3231_1.issue<QAbstractListModel_Adaptor, QVariant, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, int>(&QAbstractListModel_Adaptor::cbs_headerData_c3231_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), role);
    } else {
      return QAbstractListModel::headerData(section, orientation, role);
    }
  }

  //  [emitter impl] void QAbstractListModel::headerDataChanged(Qt::Orientation orientation, int first, int last)
  void emitter_QAbstractListModel_headerDataChanged_3231(Qt::Orientation orientation, int first, int last)
  {
    emit QAbstractListModel::headerDataChanged(orientation, first, last);
  }

  //  [adaptor impl] QModelIndex QAbstractListModel::index(int row, int column, const QModelIndex &parent)
  QModelIndex cbs_index_c3713_2(int row, int column, const QModelIndex &parent) const
  {
    return QAbstractListModel::index(row, column, parent);
  }

  virtual QModelIndex index(int row, int column, const QModelIndex &parent) const
  {
    if (cb_index_c3713_2.can_issue()) {
      return cb_index_c3713_2.issue<QAbstractListModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_index_c3713_2, row, column, parent);
    } else {
      return QAbstractListModel::index(row, column, parent);
    }
  }

  //  [adaptor impl] bool QAbstractListModel::insertColumns(int column, int count, const QModelIndex &parent)
  bool cbs_insertColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QAbstractListModel::insertColumns(column, count, parent);
  }

  virtual bool insertColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_insertColumns_3713_1.can_issue()) {
      return cb_insertColumns_3713_1.issue<QAbstractListModel_Adaptor, bool, int, int, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_insertColumns_3713_1, column, count, parent);
    } else {
      return QAbstractListModel::insertColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QAbstractListModel::insertRows(int row, int count, const QModelIndex &parent)
  bool cbs_insertRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QAbstractListModel::insertRows(row, count, parent);
  }

  virtual bool insertRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_insertRows_3713_1.can_issue()) {
      return cb_insertRows_3713_1.issue<QAbstractListModel_Adaptor, bool, int, int, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_insertRows_3713_1, row, count, parent);
    } else {
      return QAbstractListModel::insertRows(row, count, parent);
    }
  }

  //  [adaptor impl] QMap<int, QVariant> QAbstractListModel::itemData(const QModelIndex &index)
  QMap<int, QVariant> cbs_itemData_c2395_0(const QModelIndex &index) const
  {
    return QAbstractListModel::itemData(index);
  }

  virtual QMap<int, QVariant> itemData(const QModelIndex &index) const
  {
    if (cb_itemData_c2395_0.can_issue()) {
      return cb_itemData_c2395_0.issue<QAbstractListModel_Adaptor, QMap<int, QVariant>, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_itemData_c2395_0, index);
    } else {
      return QAbstractListModel::itemData(index);
    }
  }

  //  [emitter impl] void QAbstractListModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QAbstractListModel_layoutAboutToBeChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QAbstractListModel::layoutAboutToBeChanged(parents, hint);
  }

  //  [emitter impl] void QAbstractListModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QAbstractListModel_layoutChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QAbstractListModel::layoutChanged(parents, hint);
  }

  //  [adaptor impl] QList<QModelIndex> QAbstractListModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)
  QList<QModelIndex> cbs_match_c7932_2(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    return QAbstractListModel::match(start, role, value, hits, flags);
  }

  virtual QList<QModelIndex> match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    if (cb_match_c7932_2.can_issue()) {
      return cb_match_c7932_2.issue<QAbstractListModel_Adaptor, QList<QModelIndex>, const QModelIndex &, int, const QVariant &, int, QFlags<Qt::MatchFlag> >(&QAbstractListModel_Adaptor::cbs_match_c7932_2, start, role, value, hits, flags);
    } else {
      return QAbstractListModel::match(start, role, value, hits, flags);
    }
  }

  //  [adaptor impl] QMimeData *QAbstractListModel::mimeData(const QList<QModelIndex> &indexes)
  QMimeData * cbs_mimeData_c3010_0(const QList<QModelIndex> &indexes) const
  {
    return QAbstractListModel::mimeData(indexes);
  }

  virtual QMimeData * mimeData(const QList<QModelIndex> &indexes) const
  {
    if (cb_mimeData_c3010_0.can_issue()) {
      return cb_mimeData_c3010_0.issue<QAbstractListModel_Adaptor, QMimeData *, const QList<QModelIndex> &>(&QAbstractListModel_Adaptor::cbs_mimeData_c3010_0, indexes);
    } else {
      return QAbstractListModel::mimeData(indexes);
    }
  }

  //  [adaptor impl] QStringList QAbstractListModel::mimeTypes()
  QStringList cbs_mimeTypes_c0_0() const
  {
    return QAbstractListModel::mimeTypes();
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return cb_mimeTypes_c0_0.issue<QAbstractListModel_Adaptor, QStringList>(&QAbstractListModel_Adaptor::cbs_mimeTypes_c0_0);
    } else {
      return QAbstractListModel::mimeTypes();
    }
  }

  //  [adaptor impl] bool QAbstractListModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveColumns_6659_0(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QAbstractListModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
  }

  virtual bool moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveColumns_6659_0.can_issue()) {
      return cb_moveColumns_6659_0.issue<QAbstractListModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QAbstractListModel_Adaptor::cbs_moveColumns_6659_0, sourceParent, sourceColumn, count, destinationParent, destinationChild);
    } else {
      return QAbstractListModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    }
  }

  //  [adaptor impl] bool QAbstractListModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveRows_6659_0(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QAbstractListModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
  }

  virtual bool moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveRows_6659_0.can_issue()) {
      return cb_moveRows_6659_0.issue<QAbstractListModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QAbstractListModel_Adaptor::cbs_moveRows_6659_0, sourceParent, sourceRow, count, destinationParent, destinationChild);
    } else {
      return QAbstractListModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    }
  }

  //  [adaptor impl] bool QAbstractListModel::removeColumns(int column, int count, const QModelIndex &parent)
  bool cbs_removeColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QAbstractListModel::removeColumns(column, count, parent);
  }

  virtual bool removeColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_removeColumns_3713_1.can_issue()) {
      return cb_removeColumns_3713_1.issue<QAbstractListModel_Adaptor, bool, int, int, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_removeColumns_3713_1, column, count, parent);
    } else {
      return QAbstractListModel::removeColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QAbstractListModel::removeRows(int row, int count, const QModelIndex &parent)
  bool cbs_removeRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QAbstractListModel::removeRows(row, count, parent);
  }

  virtual bool removeRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_removeRows_3713_1.can_issue()) {
      return cb_removeRows_3713_1.issue<QAbstractListModel_Adaptor, bool, int, int, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_removeRows_3713_1, row, count, parent);
    } else {
      return QAbstractListModel::removeRows(row, count, parent);
    }
  }

  //  [adaptor impl] void QAbstractListModel::revert()
  void cbs_revert_0_0()
  {
    QAbstractListModel::revert();
  }

  virtual void revert()
  {
    if (cb_revert_0_0.can_issue()) {
      cb_revert_0_0.issue<QAbstractListModel_Adaptor>(&QAbstractListModel_Adaptor::cbs_revert_0_0);
    } else {
      QAbstractListModel::revert();
    }
  }

  //  [adaptor impl] QHash<int, QByteArray> QAbstractListModel::roleNames()
  QHash<int, QByteArray> cbs_roleNames_c0_0() const
  {
    return QAbstractListModel::roleNames();
  }

  virtual QHash<int, QByteArray> roleNames() const
  {
    if (cb_roleNames_c0_0.can_issue()) {
      return cb_roleNames_c0_0.issue<QAbstractListModel_Adaptor, QHash<int, QByteArray> >(&QAbstractListModel_Adaptor::cbs_roleNames_c0_0);
    } else {
      return QAbstractListModel::roleNames();
    }
  }

  //  [adaptor impl] int QAbstractListModel::rowCount(const QModelIndex &parent)
  int cbs_rowCount_c2395_1(const QModelIndex &parent) const
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    throw qt_gsi::AbstractMethodCalledException("rowCount");
  }

  virtual int rowCount(const QModelIndex &parent) const
  {
    if (cb_rowCount_c2395_1.can_issue()) {
      return cb_rowCount_c2395_1.issue<QAbstractListModel_Adaptor, int, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_rowCount_c2395_1, parent);
    } else {
      throw qt_gsi::AbstractMethodCalledException("rowCount");
    }
  }

  //  [adaptor impl] bool QAbstractListModel::setData(const QModelIndex &index, const QVariant &value, int role)
  bool cbs_setData_5065_1(const QModelIndex &index, const QVariant &value, int role)
  {
    return QAbstractListModel::setData(index, value, role);
  }

  virtual bool setData(const QModelIndex &index, const QVariant &value, int role)
  {
    if (cb_setData_5065_1.can_issue()) {
      return cb_setData_5065_1.issue<QAbstractListModel_Adaptor, bool, const QModelIndex &, const QVariant &, int>(&QAbstractListModel_Adaptor::cbs_setData_5065_1, index, value, role);
    } else {
      return QAbstractListModel::setData(index, value, role);
    }
  }

  //  [adaptor impl] bool QAbstractListModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  bool cbs_setHeaderData_5242_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QVariant &value, int role)
  {
    return QAbstractListModel::setHeaderData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), value, role);
  }

  virtual bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  {
    if (cb_setHeaderData_5242_1.can_issue()) {
      return cb_setHeaderData_5242_1.issue<QAbstractListModel_Adaptor, bool, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QVariant &, int>(&QAbstractListModel_Adaptor::cbs_setHeaderData_5242_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), value, role);
    } else {
      return QAbstractListModel::setHeaderData(section, orientation, value, role);
    }
  }

  //  [adaptor impl] bool QAbstractListModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  bool cbs_setItemData_5414_0(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    return QAbstractListModel::setItemData(index, roles);
  }

  virtual bool setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    if (cb_setItemData_5414_0.can_issue()) {
      return cb_setItemData_5414_0.issue<QAbstractListModel_Adaptor, bool, const QModelIndex &, const QMap<int, QVariant> &>(&QAbstractListModel_Adaptor::cbs_setItemData_5414_0, index, roles);
    } else {
      return QAbstractListModel::setItemData(index, roles);
    }
  }

  //  [adaptor impl] QModelIndex QAbstractListModel::sibling(int row, int column, const QModelIndex &idx)
  QModelIndex cbs_sibling_c3713_0(int row, int column, const QModelIndex &idx) const
  {
    return QAbstractListModel::sibling(row, column, idx);
  }

  virtual QModelIndex sibling(int row, int column, const QModelIndex &idx) const
  {
    if (cb_sibling_c3713_0.can_issue()) {
      return cb_sibling_c3713_0.issue<QAbstractListModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_sibling_c3713_0, row, column, idx);
    } else {
      return QAbstractListModel::sibling(row, column, idx);
    }
  }

  //  [adaptor impl] void QAbstractListModel::sort(int column, Qt::SortOrder order)
  void cbs_sort_2340_1(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QAbstractListModel::sort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void sort(int column, Qt::SortOrder order)
  {
    if (cb_sort_2340_1.can_issue()) {
      cb_sort_2340_1.issue<QAbstractListModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QAbstractListModel_Adaptor::cbs_sort_2340_1, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QAbstractListModel::sort(column, order);
    }
  }

  //  [adaptor impl] QSize QAbstractListModel::span(const QModelIndex &index)
  QSize cbs_span_c2395_0(const QModelIndex &index) const
  {
    return QAbstractListModel::span(index);
  }

  virtual QSize span(const QModelIndex &index) const
  {
    if (cb_span_c2395_0.can_issue()) {
      return cb_span_c2395_0.issue<QAbstractListModel_Adaptor, QSize, const QModelIndex &>(&QAbstractListModel_Adaptor::cbs_span_c2395_0, index);
    } else {
      return QAbstractListModel::span(index);
    }
  }

  //  [adaptor impl] bool QAbstractListModel::submit()
  bool cbs_submit_0_0()
  {
    return QAbstractListModel::submit();
  }

  virtual bool submit()
  {
    if (cb_submit_0_0.can_issue()) {
      return cb_submit_0_0.issue<QAbstractListModel_Adaptor, bool>(&QAbstractListModel_Adaptor::cbs_submit_0_0);
    } else {
      return QAbstractListModel::submit();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QAbstractListModel::supportedDragActions()
  QFlags<Qt::DropAction> cbs_supportedDragActions_c0_0() const
  {
    return QAbstractListModel::supportedDragActions();
  }

  virtual QFlags<Qt::DropAction> supportedDragActions() const
  {
    if (cb_supportedDragActions_c0_0.can_issue()) {
      return cb_supportedDragActions_c0_0.issue<QAbstractListModel_Adaptor, QFlags<Qt::DropAction> >(&QAbstractListModel_Adaptor::cbs_supportedDragActions_c0_0);
    } else {
      return QAbstractListModel::supportedDragActions();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QAbstractListModel::supportedDropActions()
  QFlags<Qt::DropAction> cbs_supportedDropActions_c0_0() const
  {
    return QAbstractListModel::supportedDropActions();
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return cb_supportedDropActions_c0_0.issue<QAbstractListModel_Adaptor, QFlags<Qt::DropAction> >(&QAbstractListModel_Adaptor::cbs_supportedDropActions_c0_0);
    } else {
      return QAbstractListModel::supportedDropActions();
    }
  }

  //  [adaptor impl] void QAbstractListModel::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAbstractListModel::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractListModel_Adaptor, QChildEvent *>(&QAbstractListModel_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAbstractListModel::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractListModel::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAbstractListModel::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractListModel_Adaptor, QEvent *>(&QAbstractListModel_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAbstractListModel::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractListModel::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAbstractListModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAbstractListModel_Adaptor, const QMetaMethod &>(&QAbstractListModel_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAbstractListModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractListModel::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAbstractListModel::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractListModel_Adaptor, QTimerEvent *>(&QAbstractListModel_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAbstractListModel::timerEvent(arg1);
    }
  }

  gsi::Callback cb_buddy_c2395_0;
  gsi::Callback cb_canDropMimeData_c7425_0;
  gsi::Callback cb_canFetchMore_c2395_0;
  gsi::Callback cb_data_c3054_1;
  gsi::Callback cb_dropMimeData_7425_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fetchMore_2395_0;
  gsi::Callback cb_flags_c2395_0;
  gsi::Callback cb_headerData_c3231_1;
  gsi::Callback cb_index_c3713_2;
  gsi::Callback cb_insertColumns_3713_1;
  gsi::Callback cb_insertRows_3713_1;
  gsi::Callback cb_itemData_c2395_0;
  gsi::Callback cb_match_c7932_2;
  gsi::Callback cb_mimeData_c3010_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_moveColumns_6659_0;
  gsi::Callback cb_moveRows_6659_0;
  gsi::Callback cb_removeColumns_3713_1;
  gsi::Callback cb_removeRows_3713_1;
  gsi::Callback cb_revert_0_0;
  gsi::Callback cb_roleNames_c0_0;
  gsi::Callback cb_rowCount_c2395_1;
  gsi::Callback cb_setData_5065_1;
  gsi::Callback cb_setHeaderData_5242_1;
  gsi::Callback cb_setItemData_5414_0;
  gsi::Callback cb_sibling_c3713_0;
  gsi::Callback cb_sort_2340_1;
  gsi::Callback cb_span_c2395_0;
  gsi::Callback cb_submit_0_0;
  gsi::Callback cb_supportedDragActions_c0_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAbstractListModel_Adaptor::~QAbstractListModel_Adaptor() { }

//  Constructor QAbstractListModel::QAbstractListModel(QObject *parent) (adaptor class)

static void _init_ctor_QAbstractListModel_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QAbstractListModel_Adaptor> ();
}

static void _call_ctor_QAbstractListModel_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QAbstractListModel_Adaptor *> (new QAbstractListModel_Adaptor (arg1));
}


// exposed void QAbstractListModel::beginInsertColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_beginInsertColumns_3713 (arg1, arg2, arg3);
}


// exposed void QAbstractListModel::beginInsertRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_beginInsertRows_3713 (arg1, arg2, arg3);
}


// exposed bool QAbstractListModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)

static void _init_fp_beginMoveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveColumns_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_beginMoveColumns_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed bool QAbstractListModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)

static void _init_fp_beginMoveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveRows_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_beginMoveRows_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed void QAbstractListModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_beginRemoveColumns_3713 (arg1, arg2, arg3);
}


// exposed void QAbstractListModel::beginRemoveRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_beginRemoveRows_3713 (arg1, arg2, arg3);
}


// exposed void QAbstractListModel::beginResetModel()

static void _init_fp_beginResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_beginResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_beginResetModel_0 ();
}


// QModelIndex QAbstractListModel::buddy(const QModelIndex &index)

static void _init_cbs_buddy_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_buddy_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QAbstractListModel_Adaptor *)cls)->cbs_buddy_c2395_0 (arg1));
}

static void _set_callback_cbs_buddy_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_buddy_c2395_0 = cb;
}


// bool QAbstractListModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_canDropMimeData_c7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_canDropMimeData_c7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_canDropMimeData_c7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_canDropMimeData_c7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_canDropMimeData_c7425_0 = cb;
}


// bool QAbstractListModel::canFetchMore(const QModelIndex &parent)

static void _init_cbs_canFetchMore_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canFetchMore_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_canFetchMore_c2395_0 (arg1));
}

static void _set_callback_cbs_canFetchMore_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_canFetchMore_c2395_0 = cb;
}


// exposed void QAbstractListModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)

static void _init_fp_changePersistentIndex_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndex_4682 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_changePersistentIndex_4682 (arg1, arg2);
}


// exposed void QAbstractListModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)

static void _init_fp_changePersistentIndexList_5912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QList<QModelIndex> & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndexList_5912 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  const QList<QModelIndex> &arg2 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_changePersistentIndexList_5912 (arg1, arg2);
}


// void QAbstractListModel::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// exposed QModelIndex QAbstractListModel::createIndex(int row, int column, void *data)

static void _init_fp_createIndex_c2374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "0");
  decl->add_arg<void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2374 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  void *arg3 = args ? gsi::arg_reader<void * >() (args, heap) : gsi::arg_maker<void * >() (0, heap);
  ret.write<QModelIndex > ((QModelIndex)((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_createIndex_c2374 (arg1, arg2, arg3));
}


// exposed QModelIndex QAbstractListModel::createIndex(int row, int column, quintptr id)

static void _init_fp_createIndex_c2657 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<quintptr > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2657 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  quintptr arg3 = gsi::arg_reader<quintptr >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_createIndex_c2657 (arg1, arg2, arg3));
}


// void QAbstractListModel::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// QVariant QAbstractListModel::data(const QModelIndex &index, int role)

static void _init_cbs_data_c3054_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c3054_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QAbstractListModel_Adaptor *)cls)->cbs_data_c3054_1 (arg1, arg2));
}

static void _set_callback_cbs_data_c3054_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_data_c3054_1 = cb;
}


// emitter void QAbstractListModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)

static void _init_emitter_dataChanged_7048 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("roles", true, "QVector<int>()");
  decl->add_arg<const QVector<int> & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_dataChanged_7048 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QVector<int> &arg3 = args ? gsi::arg_reader<const QVector<int> & >() (args, heap) : gsi::arg_maker<const QVector<int> & >() (QVector<int>(), heap);
  ((QAbstractListModel_Adaptor *)cls)->emitter_QAbstractListModel_dataChanged_7048 (arg1, arg2, arg3);
}


// exposed bool QAbstractListModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)

static void _init_fp_decodeData_5302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("stream");
  decl->add_arg<QDataStream & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_fp_decodeData_5302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  QDataStream &arg4 = gsi::arg_reader<QDataStream & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_decodeData_5302 (arg1, arg2, arg3, arg4));
}


// emitter void QAbstractListModel::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QAbstractListModel_Adaptor *)cls)->emitter_QAbstractListModel_destroyed_1302 (arg1);
}


// void QAbstractListModel::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QAbstractListModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_dropMimeData_7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_dropMimeData_7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_dropMimeData_7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_dropMimeData_7425_0 = cb;
}


// exposed void QAbstractListModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)

static void _init_fp_encodeData_c4599 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QDataStream & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_encodeData_c4599 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  QDataStream &arg2 = gsi::arg_reader<QDataStream & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_encodeData_c4599 (arg1, arg2);
}


// exposed void QAbstractListModel::endInsertColumns()

static void _init_fp_endInsertColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_endInsertColumns_0 ();
}


// exposed void QAbstractListModel::endInsertRows()

static void _init_fp_endInsertRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_endInsertRows_0 ();
}


// exposed void QAbstractListModel::endMoveColumns()

static void _init_fp_endMoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_endMoveColumns_0 ();
}


// exposed void QAbstractListModel::endMoveRows()

static void _init_fp_endMoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_endMoveRows_0 ();
}


// exposed void QAbstractListModel::endRemoveColumns()

static void _init_fp_endRemoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_endRemoveColumns_0 ();
}


// exposed void QAbstractListModel::endRemoveRows()

static void _init_fp_endRemoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_endRemoveRows_0 ();
}


// exposed void QAbstractListModel::endResetModel()

static void _init_fp_endResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_endResetModel_0 ();
}


// bool QAbstractListModel::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAbstractListModel::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QAbstractListModel::fetchMore(const QModelIndex &parent)

static void _init_cbs_fetchMore_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fetchMore_2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->cbs_fetchMore_2395_0 (arg1);
}

static void _set_callback_cbs_fetchMore_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_fetchMore_2395_0 = cb;
}


// QFlags<Qt::ItemFlag> QAbstractListModel::flags(const QModelIndex &index)

static void _init_cbs_flags_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_cbs_flags_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QAbstractListModel_Adaptor *)cls)->cbs_flags_c2395_0 (arg1));
}

static void _set_callback_cbs_flags_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_flags_c2395_0 = cb;
}


// QVariant QAbstractListModel::headerData(int section, Qt::Orientation orientation, int role)

static void _init_cbs_headerData_c3231_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_headerData_c3231_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QAbstractListModel_Adaptor *)cls)->cbs_headerData_c3231_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_headerData_c3231_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_headerData_c3231_1 = cb;
}


// emitter void QAbstractListModel::headerDataChanged(Qt::Orientation orientation, int first, int last)

static void _init_emitter_headerDataChanged_3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_headerDataChanged_3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QAbstractListModel_Adaptor *)cls)->emitter_QAbstractListModel_headerDataChanged_3231 (arg1, arg2, arg3);
}


// QModelIndex QAbstractListModel::index(int row, int column, const QModelIndex &parent)

static void _init_cbs_index_c3713_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_index_c3713_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QAbstractListModel_Adaptor *)cls)->cbs_index_c3713_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_index_c3713_2 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_index_c3713_2 = cb;
}


// bool QAbstractListModel::insertColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_insertColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_insertColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_insertColumns_3713_1 = cb;
}


// bool QAbstractListModel::insertRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_insertRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_insertRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_insertRows_3713_1 = cb;
}


// exposed bool QAbstractListModel::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_isSignalConnected_c2394 (arg1));
}


// QMap<int, QVariant> QAbstractListModel::itemData(const QModelIndex &index)

static void _init_cbs_itemData_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QMap<int, QVariant> > ();
}

static void _call_cbs_itemData_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QMap<int, QVariant> > ((QMap<int, QVariant>)((QAbstractListModel_Adaptor *)cls)->cbs_itemData_c2395_0 (arg1));
}

static void _set_callback_cbs_itemData_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_itemData_c2395_0 = cb;
}


// emitter void QAbstractListModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutAboutToBeChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutAboutToBeChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QAbstractListModel_Adaptor *)cls)->emitter_QAbstractListModel_layoutAboutToBeChanged_7947 (arg1, arg2);
}


// emitter void QAbstractListModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QAbstractListModel_Adaptor *)cls)->emitter_QAbstractListModel_layoutChanged_7947 (arg1, arg2);
}


// QList<QModelIndex> QAbstractListModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)

static void _init_cbs_match_c7932_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<QFlags<Qt::MatchFlag> > (argspec_4);
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_cbs_match_c7932_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  QFlags<Qt::MatchFlag> arg5 = args.read<QFlags<Qt::MatchFlag> > (heap);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QAbstractListModel_Adaptor *)cls)->cbs_match_c7932_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_match_c7932_2 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_match_c7932_2 = cb;
}


// QMimeData *QAbstractListModel::mimeData(const QList<QModelIndex> &indexes)

static void _init_cbs_mimeData_c3010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3010_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = args.read<const QList<QModelIndex> & > (heap);
  ret.write<QMimeData * > ((QMimeData *)((QAbstractListModel_Adaptor *)cls)->cbs_mimeData_c3010_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3010_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_mimeData_c3010_0 = cb;
}


// QStringList QAbstractListModel::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QAbstractListModel_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}


// bool QAbstractListModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveColumns_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceColumn");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveColumns_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_moveColumns_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveColumns_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_moveColumns_6659_0 = cb;
}


// bool QAbstractListModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveRows_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceRow");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveRows_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_moveRows_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveRows_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_moveRows_6659_0 = cb;
}


// exposed QList<QModelIndex> QAbstractListModel::persistentIndexList()

static void _init_fp_persistentIndexList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_fp_persistentIndexList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_persistentIndexList_c0 ());
}


// exposed int QAbstractListModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_receivers_c1731 (arg1));
}


// bool QAbstractListModel::removeColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_removeColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_removeColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_removeColumns_3713_1 = cb;
}


// bool QAbstractListModel::removeRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_removeRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_removeRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_removeRows_3713_1 = cb;
}


// exposed void QAbstractListModel::resetInternalData()

static void _init_fp_resetInternalData_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInternalData_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_resetInternalData_0 ();
}


// void QAbstractListModel::revert()

static void _init_cbs_revert_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_revert_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->cbs_revert_0_0 ();
}

static void _set_callback_cbs_revert_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_revert_0_0 = cb;
}


// QHash<int, QByteArray> QAbstractListModel::roleNames()

static void _init_cbs_roleNames_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHash<int, QByteArray> > ();
}

static void _call_cbs_roleNames_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHash<int, QByteArray> > ((QHash<int, QByteArray>)((QAbstractListModel_Adaptor *)cls)->cbs_roleNames_c0_0 ());
}

static void _set_callback_cbs_roleNames_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_roleNames_c0_0 = cb;
}


// int QAbstractListModel::rowCount(const QModelIndex &parent)

static void _init_cbs_rowCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QAbstractListModel_Adaptor *)cls)->cbs_rowCount_c2395_1 (arg1));
}

static void _set_callback_cbs_rowCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_rowCount_c2395_1 = cb;
}


// exposed QObject *QAbstractListModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_sender_c0 ());
}


// exposed int QAbstractListModel::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractListModel_Adaptor *)cls)->fp_QAbstractListModel_senderSignalIndex_c0 ());
}


// bool QAbstractListModel::setData(const QModelIndex &index, const QVariant &value, int role)

static void _init_cbs_setData_5065_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_setData_5065_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_setData_5065_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_setData_5065_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_setData_5065_1 = cb;
}


// bool QAbstractListModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)

static void _init_cbs_setHeaderData_5242_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_setHeaderData_5242_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_setHeaderData_5242_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_setHeaderData_5242_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_setHeaderData_5242_1 = cb;
}


// bool QAbstractListModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)

static void _init_cbs_setItemData_5414_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roles");
  decl->add_arg<const QMap<int, QVariant> & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_setItemData_5414_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QMap<int, QVariant> &arg2 = args.read<const QMap<int, QVariant> & > (heap);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_setItemData_5414_0 (arg1, arg2));
}

static void _set_callback_cbs_setItemData_5414_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_setItemData_5414_0 = cb;
}


// QModelIndex QAbstractListModel::sibling(int row, int column, const QModelIndex &idx)

static void _init_cbs_sibling_c3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_sibling_c3713_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QAbstractListModel_Adaptor *)cls)->cbs_sibling_c3713_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_sibling_c3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_sibling_c3713_0 = cb;
}


// void QAbstractListModel::sort(int column, Qt::SortOrder order)

static void _init_cbs_sort_2340_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_sort_2340_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->cbs_sort_2340_1 (arg1, arg2);
}

static void _set_callback_cbs_sort_2340_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_sort_2340_1 = cb;
}


// QSize QAbstractListModel::span(const QModelIndex &index)

static void _init_cbs_span_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_span_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QSize > ((QSize)((QAbstractListModel_Adaptor *)cls)->cbs_span_c2395_0 (arg1));
}

static void _set_callback_cbs_span_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_span_c2395_0 = cb;
}


// bool QAbstractListModel::submit()

static void _init_cbs_submit_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_submit_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAbstractListModel_Adaptor *)cls)->cbs_submit_0_0 ());
}

static void _set_callback_cbs_submit_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_submit_0_0 = cb;
}


// QFlags<Qt::DropAction> QAbstractListModel::supportedDragActions()

static void _init_cbs_supportedDragActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDragActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QAbstractListModel_Adaptor *)cls)->cbs_supportedDragActions_c0_0 ());
}

static void _set_callback_cbs_supportedDragActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_supportedDragActions_c0_0 = cb;
}


// QFlags<Qt::DropAction> QAbstractListModel::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QAbstractListModel_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}


// void QAbstractListModel::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractListModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractListModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QAbstractListModel> &qtdecl_QAbstractListModel ();

static gsi::Methods methods_QAbstractListModel_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractListModel::QAbstractListModel(QObject *parent)\nThis method creates an object of class QAbstractListModel.", &_init_ctor_QAbstractListModel_Adaptor_1302, &_call_ctor_QAbstractListModel_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*beginInsertColumns", "@brief Method void QAbstractListModel::beginInsertColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertColumns_3713, &_call_fp_beginInsertColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginInsertRows", "@brief Method void QAbstractListModel::beginInsertRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertRows_3713, &_call_fp_beginInsertRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginMoveColumns", "@brief Method bool QAbstractListModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveColumns_6659, &_call_fp_beginMoveColumns_6659);
  methods += new qt_gsi::GenericMethod ("*beginMoveRows", "@brief Method bool QAbstractListModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveRows_6659, &_call_fp_beginMoveRows_6659);
  methods += new qt_gsi::GenericMethod ("*beginRemoveColumns", "@brief Method void QAbstractListModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveColumns_3713, &_call_fp_beginRemoveColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginRemoveRows", "@brief Method void QAbstractListModel::beginRemoveRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveRows_3713, &_call_fp_beginRemoveRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginResetModel", "@brief Method void QAbstractListModel::beginResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginResetModel_0, &_call_fp_beginResetModel_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@hide", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@brief Virtual method QModelIndex QAbstractListModel::buddy(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0, &_set_callback_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@hide", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@brief Virtual method bool QAbstractListModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0, &_set_callback_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@hide", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@brief Virtual method bool QAbstractListModel::canFetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0, &_set_callback_cbs_canFetchMore_c2395_0);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndex", "@brief Method void QAbstractListModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndex_4682, &_call_fp_changePersistentIndex_4682);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndexList", "@brief Method void QAbstractListModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndexList_5912, &_call_fp_changePersistentIndexList_5912);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractListModel::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QAbstractListModel::createIndex(int row, int column, void *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2374, &_call_fp_createIndex_c2374);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QAbstractListModel::createIndex(int row, int column, quintptr id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2657, &_call_fp_createIndex_c2657);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractListModel::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QAbstractListModel::data(const QModelIndex &index, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1, &_set_callback_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("emit_dataChanged", "@brief Emitter for signal void QAbstractListModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)\nCall this method to emit this signal.", false, &_init_emitter_dataChanged_7048, &_call_emitter_dataChanged_7048);
  methods += new qt_gsi::GenericMethod ("*decodeData", "@brief Method bool QAbstractListModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_decodeData_5302, &_call_fp_decodeData_5302);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QAbstractListModel::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractListModel::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@hide", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@brief Virtual method bool QAbstractListModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0, &_set_callback_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("*encodeData", "@brief Method void QAbstractListModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_encodeData_c4599, &_call_fp_encodeData_c4599);
  methods += new qt_gsi::GenericMethod ("*endInsertColumns", "@brief Method void QAbstractListModel::endInsertColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertColumns_0, &_call_fp_endInsertColumns_0);
  methods += new qt_gsi::GenericMethod ("*endInsertRows", "@brief Method void QAbstractListModel::endInsertRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertRows_0, &_call_fp_endInsertRows_0);
  methods += new qt_gsi::GenericMethod ("*endMoveColumns", "@brief Method void QAbstractListModel::endMoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveColumns_0, &_call_fp_endMoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endMoveRows", "@brief Method void QAbstractListModel::endMoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveRows_0, &_call_fp_endMoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveColumns", "@brief Method void QAbstractListModel::endRemoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveColumns_0, &_call_fp_endRemoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveRows", "@brief Method void QAbstractListModel::endRemoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveRows_0, &_call_fp_endRemoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endResetModel", "@brief Method void QAbstractListModel::endResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endResetModel_0, &_call_fp_endResetModel_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAbstractListModel::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractListModel::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@hide", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@brief Virtual method void QAbstractListModel::fetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0, &_set_callback_cbs_fetchMore_2395_0);
  methods += new qt_gsi::GenericMethod ("flags", "@hide", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("flags", "@brief Virtual method QFlags<Qt::ItemFlag> QAbstractListModel::flags(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0, &_set_callback_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("headerData", "@hide", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Virtual method QVariant QAbstractListModel::headerData(int section, Qt::Orientation orientation, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1, &_set_callback_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("emit_headerDataChanged", "@brief Emitter for signal void QAbstractListModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_headerDataChanged_3231, &_call_emitter_headerDataChanged_3231);
  methods += new qt_gsi::GenericMethod ("index", "@hide", true, &_init_cbs_index_c3713_2, &_call_cbs_index_c3713_2);
  methods += new qt_gsi::GenericMethod ("index", "@brief Virtual method QModelIndex QAbstractListModel::index(int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_index_c3713_2, &_call_cbs_index_c3713_2, &_set_callback_cbs_index_c3713_2);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@hide", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@brief Virtual method bool QAbstractListModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1, &_set_callback_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@hide", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Virtual method bool QAbstractListModel::insertRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1, &_set_callback_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAbstractListModel::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemData", "@hide", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("itemData", "@brief Virtual method QMap<int, QVariant> QAbstractListModel::itemData(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0, &_set_callback_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("emit_layoutAboutToBeChanged", "@brief Emitter for signal void QAbstractListModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutAboutToBeChanged_7947, &_call_emitter_layoutAboutToBeChanged_7947);
  methods += new qt_gsi::GenericMethod ("emit_layoutChanged", "@brief Emitter for signal void QAbstractListModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutChanged_7947, &_call_emitter_layoutChanged_7947);
  methods += new qt_gsi::GenericMethod ("match", "@hide", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("match", "@brief Virtual method QList<QModelIndex> QAbstractListModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2, &_set_callback_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("mimeData", "@hide", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeData", "@brief Virtual method QMimeData *QAbstractListModel::mimeData(const QList<QModelIndex> &indexes)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0, &_set_callback_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@brief Virtual method QStringList QAbstractListModel::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@hide", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@brief Virtual method bool QAbstractListModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0, &_set_callback_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@hide", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@brief Virtual method bool QAbstractListModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0, &_set_callback_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("*persistentIndexList", "@brief Method QList<QModelIndex> QAbstractListModel::persistentIndexList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_persistentIndexList_c0, &_call_fp_persistentIndexList_c0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAbstractListModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@hide", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Virtual method bool QAbstractListModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1, &_set_callback_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@hide", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@brief Virtual method bool QAbstractListModel::removeRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1, &_set_callback_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*resetInternalData", "@brief Method void QAbstractListModel::resetInternalData()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInternalData_0, &_call_fp_resetInternalData_0);
  methods += new qt_gsi::GenericMethod ("revert", "@hide", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("revert", "@brief Virtual method void QAbstractListModel::revert()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0, &_set_callback_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@hide", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@brief Virtual method QHash<int, QByteArray> QAbstractListModel::roleNames()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0, &_set_callback_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QAbstractListModel::rowCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1, &_set_callback_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAbstractListModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAbstractListModel::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Virtual method bool QAbstractListModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1, &_set_callback_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@hide", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@brief Virtual method bool QAbstractListModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1, &_set_callback_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setItemData", "@hide", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("setItemData", "@brief Virtual method bool QAbstractListModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0, &_set_callback_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@hide", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@brief Virtual method QModelIndex QAbstractListModel::sibling(int row, int column, const QModelIndex &idx)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0, &_set_callback_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sort", "@hide", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1);
  methods += new qt_gsi::GenericMethod ("sort", "@brief Virtual method void QAbstractListModel::sort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1, &_set_callback_cbs_sort_2340_1);
  methods += new qt_gsi::GenericMethod ("span", "@hide", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("span", "@brief Virtual method QSize QAbstractListModel::span(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0, &_set_callback_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("submit", "@hide", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("submit", "@brief Virtual method bool QAbstractListModel::submit()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0, &_set_callback_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@hide", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@brief Virtual method QFlags<Qt::DropAction> QAbstractListModel::supportedDragActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0, &_set_callback_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QAbstractListModel::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractListModel::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QAbstractListModel_Adaptor> decl_QAbstractListModel_Adaptor (qtdecl_QAbstractListModel (), "QtCore", "QAbstractListModel",
  methods_QAbstractListModel_Adaptor (),
  "@qt\n@brief Binding of QAbstractListModel");

}

