/* Copyright 2009 Thomas McGuire <mcguire@kde.org>

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU Library General Public License as published
   by the Free Software Foundation; either version 2 of the License or
   ( at your option ) version 3 or, at the discretion of KDE e.V.
   ( which shall act as a proxy as in section 14 of the GPLv3 ), any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef POP3TEST_H
#define POP3TEST_H

#include "fakeserver/fakeserver.h"
#include "pop3settings.h"
#include "maildirsettings.h"

#include <AkonadiCore/Collection>
#include <AkonadiCore/Item>

#include <QObject>
#include <QList>

class Pop3Test : public QObject
{
    Q_OBJECT

    void replymMaildirSettingsInterface(QString arg1);
private Q_SLOTS:
    void initTestCase();
    void cleanupTestCase();
    void testSimpleDownload();
    void testSimpleLeaveOnServer();
    void testBigFetch();
    void testSeenUIDCleanup();
    void testTimeBasedLeaveRule();
    void testCountBasedLeaveRule();
    void testSizeBasedLeaveRule();
    void testMixedLeaveRules();

private:
    void lowerTimeOfSeenMail(const QString &uidOfMail, int secondsToLower);
    void cleanupMaildir(const Akonadi::Item::List &items);
    void checkMailsInMaildir(const QList< QByteArray > &mails);
    Akonadi::Item::List checkMailsOnAkonadiServer(const QList<QByteArray> &mails);
    void syncAndWaitForFinish();
    QString loginSequence() const;
    QString retrieveSequence(const QList< QByteArray > &mails, const QList<int> &exceptions = QList<int>()) const;
    QString deleteSequence(int numToDelete) const;
    QString quitSequence() const;
    QString listSequence(const QList<QByteArray> &mails) const;
    QString uidSequence(const QStringList &uids) const;

    FakeServerThread *mFakeServerThread = nullptr;

    OrgKdeAkonadiPOP3SettingsInterface *mPOP3SettingsInterface = nullptr;
    OrgKdeAkonadiMaildirSettingsInterface *mMaildirSettingsInterface = nullptr;
    Akonadi::Collection mMaildirCollection;
    QString mPop3Identifier;
    QString mMaildirIdentifier;
    QString mMaildirPath;
};

#endif
