/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ast;

import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.pmd.ast.JavaParserVisitor;
import net.sourceforge.pmd.ast.SimpleJavaTypeNode;

public class ASTPrimaryPrefix
extends SimpleJavaTypeNode {
    private boolean usesThisModifier;
    private boolean usesSuperModifier;

    public ASTPrimaryPrefix(int id) {
        super(id);
    }

    public ASTPrimaryPrefix(JavaParser p, int id) {
        super(p, id);
    }

    public void setUsesThisModifier() {
        this.usesThisModifier = true;
    }

    public boolean usesThisModifier() {
        return this.usesThisModifier;
    }

    public void setUsesSuperModifier() {
        this.usesSuperModifier = true;
    }

    public boolean usesSuperModifier() {
        return this.usesSuperModifier;
    }

    public String getLabel() {
        String out = this.getImage();
        if (this.usesSuperModifier) {
            return "super." + out;
        }
        if (this.usesThisModifier) {
            if (this.getImage() == null) {
                return "this";
            }
            return "this." + out;
        }
        return out;
    }

    public void dump(String prefix) {
        String out = this.getImage();
        if (this.usesSuperModifier) {
            out = "super." + out;
        } else if (this.usesThisModifier) {
            out = this.getImage() == null ? "this" : "this." + out;
        }
        if (out == null) {
            System.out.println(this.toString(prefix));
        } else {
            System.out.println(this.toString(prefix) + ":" + out);
        }
        this.dumpChildren(prefix);
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}

