/*
 * Decompiled with CFR 0.152.
 */
package jalview.commands;

import jalview.commands.EditCommand;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.util.ShiftList;
import java.util.Vector;

public class TrimRegionCommand
extends EditCommand {
    public static String TRIM_LEFT = "TrimLeft";
    public static String TRIM_RIGHT = "TrimRight";
    public ColumnSelection colSel = null;
    int[] start;
    ShiftList shiftList;
    SequenceGroup selectionGroup;
    Vector deletedHiddenColumns;
    int columnsDeleted;

    public TrimRegionCommand(String description, String command, SequenceI[] seqs, int column, AlignmentI al, ColumnSelection colSel, SequenceGroup selectedRegion) {
        this.description = description;
        this.selectionGroup = selectedRegion;
        this.colSel = colSel;
        if (command.equalsIgnoreCase(TRIM_LEFT)) {
            if (column == 0) {
                return;
            }
            this.columnsDeleted = column;
            this.edits = new EditCommand.Edit[]{(EditCommand)this.new EditCommand.Edit(2, seqs, 0, column, al)};
        } else if (command.equalsIgnoreCase(TRIM_RIGHT)) {
            int width = al.getWidth() - column - 1;
            if (width < 2) {
                return;
            }
            this.columnsDeleted = width - 1;
            this.edits = new EditCommand.Edit[]{(EditCommand)this.new EditCommand.Edit(2, seqs, column + 1, width, al)};
        }
        int isize = this.edits[0].seqs.length;
        this.start = new int[isize];
        for (int i = 0; i < isize; ++i) {
            this.start[i] = this.edits[0].seqs[i].getStart();
        }
        this.performEdit(0, null);
    }

    void cut(EditCommand.Edit command) {
        int jSize = command.seqs.length;
        for (int j = 0; j < jSize; ++j) {
            int column;
            if (command.position == 0) {
                column = command.seqs[j].findPosition(command.number);
                command.seqs[j].setStart(column);
                continue;
            }
            column = command.seqs[j].findPosition(command.position) - 1;
            command.seqs[j].setEnd(column);
        }
        super.cut(command, null);
        if (command.position == 0) {
            this.deletedHiddenColumns = this.colSel.compensateForEdit(0, command.number);
            if (this.selectionGroup != null) {
                this.selectionGroup.adjustForRemoveLeft(command.number);
            }
        } else {
            this.deletedHiddenColumns = this.colSel.compensateForEdit(command.position, command.number);
            if (this.selectionGroup != null) {
                this.selectionGroup.adjustForRemoveRight(command.position);
            }
        }
    }

    void paste(EditCommand.Edit command) {
        super.paste(command, null);
        int jSize = command.seqs.length;
        for (int j = 0; j < jSize; ++j) {
            if (command.position == 0) {
                command.seqs[j].setStart(this.start[j]);
                continue;
            }
            int column = command.seqs[j].findPosition(command.number + command.position) - 1;
            command.seqs[j].setEnd(column);
        }
        if (command.position == 0) {
            this.colSel.compensateForEdit(0, -command.number);
            if (this.selectionGroup != null) {
                this.selectionGroup.adjustForRemoveLeft(-command.number);
            }
        }
        if (this.deletedHiddenColumns != null) {
            for (int i = 0; i < this.deletedHiddenColumns.size(); ++i) {
                int[] region = (int[])this.deletedHiddenColumns.elementAt(i);
                this.colSel.hideColumns(region[0], region[1]);
            }
        }
    }

    public int getSize() {
        return this.columnsDeleted;
    }
}

