# 
# Copyright (c) 2001 Butch Landingin 
# All rights reserved. Written by Butch Landingin <butchland@yahoo.com> 
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions 
# are met: 
#
# 1. Redistributions of source code must retain the above copyright 
#    notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright 
#    notice, this list of conditions and the following disclaimer in the 
#    documentation and/or other materials provided with the distribution. 
#
# 3. The name of the author may not be used to endorse or promote products 
#    derived from this software without specific prior written permission 
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, 
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
#   
#  In accordance with the license provided for by the software upon 
#  which some of the source code has been derived or used, the following acknowledgement 
#  is hereby provided : 
# 
#      "This product includes software developed by the Zope Corporation 
#      for use in the Z Object Publishing Environment 
#      (http://www.zope.org/)." 
#  
# 
from OFS import Folder, PropertyManager, SimpleItem, FindSupport
from AccessControl import ClassSecurityInfo, getSecurityManager, Role
from Globals import InitializeClass, DTMLFile
from Acquisition import Implicit
from Globals import Persistent
from Globals import MessageDialog
from AccessControl.Role import RoleManager
from OFS.SimpleItem import Item
from OFS.FindSupport import FindSupport
from OFS.PropertyManager import PropertyManager
from Persistence import PersistentMapping

# Constructor form and method
# ---------------------------

addFolderForm=DTMLFile('dtml/folderAdd', globals())

# copied from Folder
def manage_addFolder(self, id, title='',
                     createPublic=0,
                     createUserF=0,
                     REQUEST=None):
    """Add a new Lockable Folder object with id *id*.

    If the 'createPublic' and 'createUserF' parameters are set to any true
    value, an 'index_html' and a 'UserFolder' objects are created respectively
    in the new folder.
    """
    ob=LockableFolder()
    ob.id=str(id)
    ob.title=title
    self._setObject(id, ob)
    ob=self._getOb(id)

    checkPermission=getSecurityManager().checkPermission    

    if createUserF:
        if not checkPermission('Add User Folders', ob):
            raise 'Unauthorized', (
                  'You are not authorized to add User Folders.'
                  )
        ob.manage_addUserFolder()

    if createPublic:
        if not checkPermission('Add Documents, Images, and Files', ob):
            raise 'Unauthorized', (
                  'You are not authorized to add DTML Documents.'
                  )
        ob.manage_addDTMLDocument(id='index_html', title='')

    if REQUEST is not None:
        return self.manage_main(self, REQUEST, update_menu=1)

# Product class
# -------------

class LockableFolder(Folder.Folder):
    """
    Lockable Folder

    """
    meta_type='LockableFolder'
    manage_main=DTMLFile('dtml/main', globals())
    manage_options=(
        (
        {'label':'Contents', 'action':'manage_main',
         'help':('LockableFolder','LockableFolder_Contents.stx')},
        {'label':'View', 'action':'index_html',
         'help':('LockableFolder','LockableFolder_View.stx')},
        )+
        PropertyManager.manage_options+
        RoleManager.manage_options+
        Item.manage_options+
        FindSupport.manage_options
        )
    security=ClassSecurityInfo()

    def __init__(self):
        self._access = PersistentMapping()

    def _setOb(self, id, object):
        Folder.Folder._setOb(self, id, object)
        self._access[id] = 0
        
    def _delOb(self, id):
        Folder.Folder._delOb(self, id)
        del self._access[id]
        
    def _lockAccess(self, id):
        self._access[id] = 1
    def _unlockAccess(self, id):
        self._access[id] = 0
    def _isLocked(self, id):
        return self._access.get(id,None)
        
    security.declareProtected('View management screens', 'isLocked')    
    def isLocked(self, id):
        ''' returns true if the object with the associated id is locked'''
        return self._isLocked(id)
    
    security.declareProtected('Lock and unlock objects', 'manage_lockObjects')    
    def manage_lockObjects(self, ids=[], REQUEST=None):
        """Lock a subordinate object
        
        The objects specified in 'ids' get locked.
        """
        if type(ids) is type(''): ids=[ids]
        if not ids:
            return MessageDialog(title='No items specified',
                   message='No items were specified!',
                   action ='./manage_main',)
        while ids:
            id=ids[-1]
            v=self._getOb(id, self)
            if v is self:
                raise 'BadRequest', '%s does not exist' % ids[-1]
            self._lockAccess(id)
            del ids[-1]
        if REQUEST is not None:
                return self.manage_main(self, REQUEST, update_menu=1)

    security.declareProtected('Lock and unlock objects', 'manage_unlockObjects')    
    def manage_unlockObjects(self, ids=[], REQUEST=None):
        """Lock a subordinate object
        
        The objects specified in 'ids' get unlocked if they are locked.
        """
        if type(ids) is type(''): ids=[ids]
        if not ids:
            return MessageDialog(title='No items specified',
                   message='No items were specified!',
                   action ='./manage_main',)
        while ids:
            id=ids[-1]
            v=self._getOb(id, self)
            if v is self:
                raise 'BadRequest', '%s does not exist' % ids[-1]
            self._unlockAccess(id)
            del ids[-1]
        if REQUEST is not None:
                return self.manage_main(self, REQUEST, update_menu=1)

    def __bobo_traverse__(self, REQUEST, name=None):
        #
        # modified from Application.__bobo_traverse__
        #
        attr = None
        namefnd = 0
        try:
            attr = getattr(self, name)
            namefnd = 1
        except AttributeError: pass

        if not namefnd:
            try:
                attr = self[name]
                namefnd = 1
            except KeyError: pass
            
        if namefnd:
            # if only calls to manage_* can be distinguished
            # from normal 'user' calls, then subobjects should
            # be accessible under the management screens even
            # when locked.
            # if someone can fix this, then this product would
            # really rock!
            # but since it doesn't, then it locks up the subobject
            # even from the management views and requires you to
            # unlock the subobjects to edit them. :^(
            #
            if not self._isLocked(name):
                return attr
        
        method=REQUEST.get('REQUEST_METHOD', 'GET')
        if not method in ('GET', 'POST'):
            return NullResource(self, name, REQUEST).__of__(self)

        # Waaa. unrestrictedTraverse calls us with a fake REQUEST.
        # There is proabably a better fix for this.
        try: REQUEST.RESPONSE.notFoundError("%s\n%s" % (name, method))
        except AttributeError:
            raise KeyError, name

    
# Initialize product class
# ------------------------

InitializeClass(LockableFolder)
