/*
 * unlink.c
 *
 * Copyright (C) 1993 Alain Knaff
 */
#define _LARGEFILE64_SOURCE
#define _GNU_SOURCE

#include "sysincludes.h"

int unlink(__const char *file_name)
{
  int st;
  struct STAT32 buf;
  char newname[MAXPATHLEN + MAXEXTLEN + 1];


  st = zlib_real_unlink(file_name);

  if ( st >= 0 || errno != ENOENT )
    return st;

  zlib_initialise();
  if ( zlib_mode & CM_DISAB )
    return st;
  if ( (zlib_getfiletype(file_name,-1) & PM_READ_MASK) == PM_LEAVE_COMPR)
    return st;
  
  if ( zlib_mode & CM_VERBOSE )
    fprintf(stderr,"Unlinking %s\n",file_name);
  
  strncpy(newname,file_name,1024);
  strcat(newname,zlib_ext);

  st=0;
  if ( zlib_mode & CM_UNLINK)
    st= zlib_real_unlink(newname);
  else
    st = ___zlibc_lstat(newname, &buf);
  if ( st < 0 ){
    errno = ENOENT;
    return st;
  }

  /* the file exists with z extension, ignore error */
  return 0;
}
