/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import Glacier2.CannotCreateSessionException;
import Glacier2.RouterPrxHelper;
import Glacier2.SessionNotExistException;
import Glacier2.SessionPrx;
import Ice.Communicator;
import Ice.Identity;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.ObjectNotExistException;
import Ice.Properties;
import Ice.RouterPrx;
import Ice.StringSeqHolder;
import Ice.Util;
import IceGrid.AccessDeniedException;
import IceGrid.AdapterDynamicInfo;
import IceGrid.AdapterInfo;
import IceGrid.AdminPrx;
import IceGrid.AdminSessionPrx;
import IceGrid.AdminSessionPrxHelper;
import IceGrid.ApplicationDescriptor;
import IceGrid.ApplicationNotExistException;
import IceGrid.ApplicationUpdateDescriptor;
import IceGrid.DeploymentException;
import IceGrid.DistributionDescriptor;
import IceGrid.FileParserPrx;
import IceGrid.FileParserPrxHelper;
import IceGrid.NodeDynamicInfo;
import IceGrid.ObjectInfo;
import IceGrid.ParseException;
import IceGrid.PermissionDeniedException;
import IceGrid.RegistryPrx;
import IceGrid.RegistryPrxHelper;
import IceGrid.ServerDynamicInfo;
import IceGridGUI.Application.Root;
import IceGridGUI.ApplicationActions;
import IceGridGUI.ApplicationPane;
import IceGridGUI.BareBonesBrowserLaunch;
import IceGridGUI.LiveActions;
import IceGridGUI.LiveDeployment.TreeNode;
import IceGridGUI.LiveDeploymentPane;
import IceGridGUI.MainPane;
import IceGridGUI.SessionKeeper;
import IceGridGUI.StatusBar;
import IceGridGUI.Tab;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class Coordinator {
    private final InitializationData _initData;
    private Communicator _communicator;
    private Preferences _prefs;
    private StatusBarI _statusBar = new StatusBarI();
    private IceGridGUI.LiveDeployment.Root _liveDeploymentRoot;
    private LiveDeploymentPane _liveDeploymentPane;
    private Map _liveApplications = new HashMap();
    private MainPane _mainPane;
    private int _latestSerial = -1;
    private int _writeSerial = -1;
    private Runnable _onExclusiveWrite;
    private int _writeAccessCount = 0;
    private boolean _substitute = false;
    private JFrame _mainFrame;
    private SessionKeeper _sessionKeeper;
    private Object _clipboard;
    private Action _newApplication;
    private Action _newApplicationWithDefaultTemplates;
    private Action _login;
    private Action _logout;
    private Action _acquireExclusiveWriteAccess;
    private Action _releaseExclusiveWriteAccess;
    private Action _openApplicationFromFile;
    private Action _openApplicationFromRegistry;
    private Action _closeApplication;
    private Action _save;
    private Action _saveToRegistry;
    private Action _saveToFile;
    private Action _discardUpdates;
    private Action _exit;
    private Action _back;
    private Action _forward;
    private Action _helpContents;
    private Action _about;
    private Action _patchApplication;
    private LiveActions _liveActionsForMenu = new LiveActions();
    private LiveActions _liveActionsForPopup = new LiveActions();
    private ApplicationActions _appActionsForMenu = new ApplicationActions(false);
    private ApplicationActions _appActionsForPopup = new ApplicationActions(true);
    private JToggleButton _showVarsTool;
    private JToggleButton _substituteTool;
    private JCheckBoxMenuItem _substituteMenuItem;
    private JCheckBoxMenuItem _showVarsMenuItem;
    private JMenu _newMenu;
    private JMenu _newServerMenu;
    private JMenu _newServiceMenu;
    private JMenu _newTemplateMenu;
    private JMenu _appMenu;
    private JMenu _nodeMenu;
    private JMenu _registryMenu;
    private JMenu _serverMenu;
    private final Thread _shutdownHook;
    private JFileChooser _fileChooser;
    private Process _icegridadminProcess;
    private String _fileParser;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Communicator getCommunicator() {
        if (this._communicator == null) {
            try {
                this._communicator = Util.initialize(this._initData);
            }
            catch (LocalException e) {
                JOptionPane.showMessageDialog(null, e.toString(), "Communicator initialization failed", 0);
            }
        }
        return this._communicator;
    }

    public Properties getProperties() {
        return this._initData.properties;
    }

    public Tab getCurrentTab() {
        return (Tab)((Object)this._mainPane.getSelectedComponent());
    }

    public Action getBackAction() {
        return this._back;
    }

    public Action getForwardAction() {
        return this._forward;
    }

    public Action getCloseApplicationAction() {
        return this._closeApplication;
    }

    public Action getSaveAction() {
        return this._save;
    }

    public Action getSaveToRegistryAction() {
        return this._saveToRegistry;
    }

    public Action getSaveToFileAction() {
        return this._saveToFile;
    }

    public Action getDiscardUpdatesAction() {
        return this._discardUpdates;
    }

    public ApplicationPane openLiveApplication(String applicationName) {
        ApplicationPane app = (ApplicationPane)this._liveApplications.get(applicationName);
        if (app == null) {
            ApplicationDescriptor desc = this._liveDeploymentRoot.getApplicationDescriptor(applicationName);
            if (desc == null) {
                JOptionPane.showMessageDialog(this._mainFrame, "The application '" + applicationName + "' was not found in the registry.", "No such application", 0);
            }
            desc = Root.copyDescriptor(desc);
            app = new ApplicationPane(new Root(this, desc, true, null));
            this._mainPane.addApplication(app);
            this._liveApplications.put(applicationName, app);
        }
        this._mainPane.setSelectedComponent(app);
        return app;
    }

    public void removeLiveApplication(String name) {
        this._liveApplications.remove(name);
    }

    public void addLiveApplication(Root root) {
        ApplicationPane app = this._mainPane.findApplication(root);
        if (!$assertionsDisabled && app == null) {
            throw new AssertionError();
        }
        this._liveApplications.put(app.getRoot().getId(), app);
    }

    public ApplicationPane getLiveApplication(String name) {
        return (ApplicationPane)this._liveApplications.get(name);
    }

    void registryInit(String instanceName, int serial, List applications, AdapterInfo[] adapters, ObjectInfo[] objects) {
        if (!$assertionsDisabled && this._latestSerial != -1) {
            throw new AssertionError();
        }
        this._latestSerial = serial;
        this._liveDeploymentRoot.init(instanceName, applications, adapters, objects);
    }

    void applicationAdded(int serial, ApplicationDescriptor desc) {
        this._liveDeploymentRoot.applicationAdded(desc);
        this._statusBar.setText("Last update: new application '" + desc.name + "'");
        this.updateSerial(serial);
    }

    void applicationRemoved(int serial, String name) {
        this._liveDeploymentRoot.applicationRemoved(name);
        this._statusBar.setText("Last update: application '" + name + "' was removed");
        ApplicationPane app = (ApplicationPane)this._liveApplications.get(name);
        if (app != null) {
            if (app.getRoot().kill()) {
                this._mainPane.remove(app);
            }
            this._liveApplications.remove(name);
        }
        this.updateSerial(serial);
    }

    void applicationUpdated(int serial, ApplicationUpdateDescriptor desc) {
        this._liveDeploymentRoot.applicationUpdated(desc);
        this._liveDeploymentPane.refresh();
        this._statusBar.setText("Last update: application  '" + desc.name + "' was updated");
        ApplicationPane app = (ApplicationPane)this._liveApplications.get(desc.name);
        if (app != null && app.getRoot().update(desc)) {
            app.refresh();
        }
        this.updateSerial(serial);
    }

    void adapterAdded(int serial, AdapterInfo info) {
        this._liveDeploymentRoot.adapterAdded(info);
        this._liveDeploymentPane.refresh();
        this.updateSerial(serial);
    }

    void adapterUpdated(int serial, AdapterInfo info) {
        this._liveDeploymentRoot.adapterUpdated(info);
        this._liveDeploymentPane.refresh();
        this.updateSerial(serial);
    }

    void adapterRemoved(int serial, String id) {
        this._liveDeploymentRoot.adapterRemoved(id);
        this._liveDeploymentPane.refresh();
        this.updateSerial(serial);
    }

    void objectAdded(int serial, ObjectInfo info) {
        this._liveDeploymentRoot.objectAdded(info);
        this._liveDeploymentPane.refresh();
        this.updateSerial(serial);
    }

    void objectUpdated(int serial, ObjectInfo info) {
        this._liveDeploymentRoot.objectUpdated(info);
        this._liveDeploymentPane.refresh();
        this.updateSerial(serial);
    }

    void objectRemoved(int serial, Identity id) {
        this._liveDeploymentRoot.objectRemoved(id);
        this._liveDeploymentPane.refresh();
        this.updateSerial(serial);
    }

    public void accessDenied(AccessDeniedException e) {
        JOptionPane.showMessageDialog(this._mainFrame, "Another session (username = " + e.lockUserId + ") has exclusive write access to the registry", "Access Denied", 0);
    }

    public void pasteApplication() {
        Object descriptor = this.getClipboard();
        ApplicationDescriptor desc = Root.copyDescriptor((ApplicationDescriptor)descriptor);
        Root root = new Root(this, desc);
        ApplicationPane app = new ApplicationPane(root);
        this._mainPane.addApplication(app);
        this._mainPane.setSelectedComponent(app);
        root.setSelectedNode(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeApplicationFromRegistry(String name) {
        block11: {
            this._mainFrame.setCursor(Cursor.getPredefinedCursor(3));
            boolean acquired = false;
            try {
                try {
                    this.acquireExclusiveWriteAccess(null);
                    acquired = true;
                    this._sessionKeeper.getAdmin().removeApplication(name);
                }
                catch (AccessDeniedException e) {
                    this.accessDenied(e);
                    Object var5_4 = null;
                    if (acquired) {
                        this.releaseExclusiveWriteAccess();
                    }
                    this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                catch (ApplicationNotExistException e) {
                    Object var5_5 = null;
                    if (acquired) {
                        this.releaseExclusiveWriteAccess();
                    }
                    this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                catch (LocalException e) {
                    JOptionPane.showMessageDialog(this._mainFrame, "Could not remove application '" + name + "' from IceGrid registry:\n" + e.toString(), "Trouble with IceGrid registry", 0);
                    Object var5_6 = null;
                    if (acquired) {
                        this.releaseExclusiveWriteAccess();
                    }
                    this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                Object var5_3 = null;
                if (!acquired) break block11;
                this.releaseExclusiveWriteAccess();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (acquired) {
                    this.releaseExclusiveWriteAccess();
                }
                this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                throw throwable;
            }
        }
        this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireExclusiveWriteAccess(Runnable runnable) throws AccessDeniedException {
        if (this._writeSerial == -1) {
            this._mainFrame.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this._writeSerial = this._sessionKeeper.getSession().startUpdate();
            }
            finally {
                this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (!$assertionsDisabled && this._onExclusiveWrite != null) {
            throw new AssertionError();
        }
        ++this._writeAccessCount;
        if (runnable != null) {
            if (this._writeSerial <= this._latestSerial) {
                runnable.run();
            } else {
                this._onExclusiveWrite = runnable;
                this._mainFrame.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }

    public void releaseExclusiveWriteAccess() {
        if (--this._writeAccessCount == 0) {
            try {
                this._writeSerial = -1;
                this._sessionKeeper.getSession().finishUpdate();
            }
            catch (AccessDeniedException e) {
                this.accessDenied(e);
            }
            catch (ObjectNotExistException e) {
            }
            catch (LocalException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "Could not release exclusive write access on the IceGrid registry:\n" + e.toString(), "Trouble with IceGrid registry", 0);
            }
        }
    }

    private void updateSerial(int serial) {
        if (!$assertionsDisabled && serial != this._latestSerial + 1) {
            throw new AssertionError();
        }
        this._latestSerial = serial;
        if (this._writeAccessCount > 0 && this._writeSerial <= this._latestSerial && this._onExclusiveWrite != null) {
            Runnable runnable = this._onExclusiveWrite;
            this._onExclusiveWrite = null;
            runnable.run();
            this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void nodeUp(NodeDynamicInfo updatedInfo) {
        this._liveDeploymentRoot.nodeUp(updatedInfo);
        this._liveDeploymentPane.refresh();
    }

    void nodeDown(String node) {
        this._liveDeploymentRoot.nodeDown(node);
        this._liveDeploymentPane.refresh();
    }

    void updateServer(String node, ServerDynamicInfo updatedInfo) {
        this._liveDeploymentRoot.updateServer(node, updatedInfo);
        this._liveDeploymentPane.refresh();
    }

    void updateAdapter(String node, AdapterDynamicInfo updatedInfo) {
        this._liveDeploymentRoot.updateAdapter(node, updatedInfo);
        this._liveDeploymentPane.refresh();
    }

    void sessionLost() {
        this._latestSerial = -1;
        this._writeSerial = -1;
        this._writeAccessCount = 0;
        this._onExclusiveWrite = null;
        this._liveDeploymentRoot.clear();
        Iterator p = this._liveApplications.values().iterator();
        while (p.hasNext()) {
            ApplicationPane app = (ApplicationPane)p.next();
            if (!app.getRoot().kill()) continue;
            this._mainPane.remove(app);
        }
        this._liveApplications.clear();
        this._logout.setEnabled(false);
        this._openApplicationFromRegistry.setEnabled(false);
        this._patchApplication.setEnabled(false);
        this._appMenu.setEnabled(false);
        this._newApplicationWithDefaultTemplates.setEnabled(false);
        this._acquireExclusiveWriteAccess.setEnabled(false);
        this._releaseExclusiveWriteAccess.setEnabled(false);
        this._saveToRegistry.setEnabled(false);
    }

    AdminSessionPrx login(SessionKeeper.LoginInfo info, Component parent) {
        this._liveDeploymentRoot.clear();
        AdminSessionPrx session = null;
        this.destroyCommunicator();
        InitializationData initData = this._initData;
        if (info.routed && info.routerSSLEnabled || !info.routed && info.registrySSLEnabled) {
            initData = (InitializationData)initData.clone();
            initData.properties = initData.properties._clone();
            initData.properties.setProperty("Ice.Plugin.IceSSL", "IceSSL.PluginFactory");
            initData.properties.setProperty("IceSSL.Keystore", info.keystore);
            initData.properties.setProperty("IceSSL.Password", new String(info.keyPassword));
            initData.properties.setProperty("IceSSL.KeystorePassword", new String(info.keystorePassword));
            initData.properties.setProperty("IceSSL.Alias", info.alias);
            initData.properties.setProperty("IceSSL.Truststore", info.truststore);
            initData.properties.setProperty("IceSSL.TruststorePassword", new String(info.truststorePassword));
        }
        try {
            this._communicator = Util.initialize(initData);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(parent, e.toString(), "Communicator initialization failed", 0);
            return null;
        }
        if (info.routed) {
            Identity id = new Identity();
            id.category = info.routerInstanceName;
            id.name = "router";
            String str = "\"" + this._communicator.identityToString(id) + "\"";
            if (!info.routerEndpoints.equals("")) {
                str = str + ":" + info.routerEndpoints;
            }
            try {
                SessionPrx s;
                Glacier2.RouterPrx router = RouterPrxHelper.uncheckedCast(this._communicator.stringToProxy(str));
                this._communicator.setDefaultRouter(router);
                if (info.routerUseSSL) {
                    s = (router = RouterPrxHelper.uncheckedCast(router.ice_secure(true))).createSessionFromSecureConnection();
                    if (s == null) {
                        JOptionPane.showMessageDialog(parent, "createSessionFromSecureConnection returned a null session: \nverify that Glacier2.SSLSessionManager is set to <IceGridInstanceName>/AdminSSLSessionManager in your Glacier2 router configuration", "Login failed", 0);
                        return null;
                    }
                } else {
                    s = router.createSession(info.routerUsername, new String(info.routerPassword));
                    if (s == null) {
                        JOptionPane.showMessageDialog(parent, "createSession returned a null session: \nverify that Glacier2.SessionManager is set to <IceGridInstanceName>/AdminSessionManager in your Glacier2 router configuration", "Login failed", 0);
                        return null;
                    }
                }
                session = AdminSessionPrxHelper.uncheckedCast(s);
            }
            catch (Glacier2.PermissionDeniedException e) {
                if (e.reason.length() == 0) {
                    e.reason = info.routerUseSSL ? "Invalid credentials" : "Invalid username/password";
                }
                JOptionPane.showMessageDialog(parent, "Permission denied: " + e.reason, "Login failed", 0);
                return null;
            }
            catch (CannotCreateSessionException e) {
                JOptionPane.showMessageDialog(parent, "Could not create session: " + e.reason, "Login failed", 0);
                return null;
            }
            catch (LocalException e) {
                JOptionPane.showMessageDialog(parent, "Could not create session: " + e.toString(), "Login failed", 0);
                return null;
            }
        }
        Identity locatorId = new Identity();
        locatorId.category = info.registryInstanceName;
        locatorId.name = "Locator";
        String str = "\"" + this._communicator.identityToString(locatorId) + "\"";
        if (!info.registryEndpoints.equals("")) {
            str = str + ":" + info.registryEndpoints;
        }
        try {
            LocatorPrx defaultLocator = LocatorPrxHelper.checkedCast(this._communicator.stringToProxy(str));
            this._communicator.setDefaultLocator(defaultLocator);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(parent, "Could not contact '" + str + "': " + e.toString(), "Login failed", 0);
            return null;
        }
        Identity registryId = new Identity();
        registryId.category = info.registryInstanceName;
        registryId.name = "Registry";
        RegistryPrx registry = RegistryPrxHelper.uncheckedCast(this._communicator.stringToProxy("\"" + this._communicator.identityToString(registryId) + "\""));
        try {
            if (info.registryUseSSL) {
                registry = RegistryPrxHelper.uncheckedCast(registry.ice_secure(true));
                session = AdminSessionPrxHelper.uncheckedCast(registry.createAdminSessionFromSecureConnection());
            } else {
                session = AdminSessionPrxHelper.uncheckedCast(registry.createAdminSession(info.registryUsername, new String(info.registryPassword)));
            }
        }
        catch (PermissionDeniedException e) {
            JOptionPane.showMessageDialog(parent, "Permission denied: " + e.reason, "Login failed", 0);
            return null;
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(parent, "Could not create session: " + e.toString(), "Login failed", 0);
            return null;
        }
        this._logout.setEnabled(true);
        this._openApplicationFromRegistry.setEnabled(true);
        this._patchApplication.setEnabled(true);
        this._appMenu.setEnabled(true);
        this._newApplicationWithDefaultTemplates.setEnabled(true);
        this._acquireExclusiveWriteAccess.setEnabled(true);
        this._mainPane.setSelectedComponent(this._liveDeploymentPane);
        return session;
    }

    void destroySession(AdminSessionPrx session) {
        RouterPrx router = this._communicator.getDefaultRouter();
        try {
            if (router == null) {
                session.destroy();
            } else {
                Glacier2.RouterPrx gr = RouterPrxHelper.uncheckedCast(router);
                gr.destroySession();
            }
        }
        catch (SessionNotExistException e) {
        }
        catch (LocalException localException) {
            // empty catch block
        }
    }

    void showVars() {
        this.substitute(false);
    }

    void substituteVars() {
        this.substitute(true);
    }

    private void substitute(boolean newValue) {
        if (this._substitute != newValue) {
            this._substitute = newValue;
            if (this._substitute) {
                this._substituteMenuItem.setSelected(true);
                this._substituteTool.setSelected(true);
            } else {
                this._showVarsMenuItem.setSelected(true);
                this._showVarsTool.setSelected(true);
            }
            this.getCurrentTab().refresh();
        }
    }

    public boolean substitute() {
        return this._substitute;
    }

    public AdminPrx getAdmin() {
        return this._sessionKeeper.getAdmin();
    }

    public StatusBar getStatusBar() {
        return this._statusBar;
    }

    public JFrame getMainFrame() {
        return this._mainFrame;
    }

    public MainPane getMainPane() {
        return this._mainPane;
    }

    public ApplicationDescriptor parseFile(File file) {
        if (this._icegridadminProcess == null) {
            try {
                this._icegridadminProcess = Runtime.getRuntime().exec("icegridadmin --server");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "Failed to start icegridadmin subprocess: " + e.toString(), "IO Exception", 0);
                return null;
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this._icegridadminProcess.getInputStream(), "US-ASCII"));
                String str = reader.readLine();
                reader.close();
                if (str == null || str.length() == 0) {
                    JOptionPane.showMessageDialog(this._mainFrame, "The icegridadmin subprocess failed", "Subprocess failure", 0);
                    this.destroyIceGridAdmin();
                    return null;
                }
                this._fileParser = str;
            }
            catch (UnsupportedEncodingException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "IO Exception: " + e.toString(), "IO Exception", 0);
                this.destroyIceGridAdmin();
                return null;
            }
        }
        try {
            FileParserPrx fileParser = FileParserPrxHelper.checkedCast(this.getCommunicator().stringToProxy(this._fileParser).ice_router(null));
            return fileParser.parse(file.getAbsolutePath(), this._sessionKeeper.getRoutedAdmin());
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "Failed to parse file '" + file.getAbsolutePath() + "':\n" + e.toString(), "Parse error", 0);
            return null;
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "Operation on FileParser failed:\n" + e.toString(), "Communication error", 0);
            this.destroyIceGridAdmin();
            return null;
        }
    }

    private void destroyIceGridAdmin() {
        if (this._icegridadminProcess != null) {
            try {
                this._icegridadminProcess.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._icegridadminProcess = null;
            this._fileParser = null;
        }
    }

    public File saveToFile(boolean ask, Root root, File file) {
        if (ask || file == null) {
            int result;
            if (file != null) {
                this._fileChooser.setSelectedFile(file);
            }
            file = (result = this._fileChooser.showSaveDialog(this._mainFrame)) == 0 ? this._fileChooser.getSelectedFile() : null;
        }
        if (file != null) {
            try {
                XMLWriter writer = new XMLWriter(file);
                root.write(writer);
                writer.close();
                this._statusBar.setText("Saved application '" + root.getId() + "' to " + file.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "Cannot use the selected file for writing.", "File Not Found", 0);
                return null;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "IO Exception: " + e.toString(), "IO Exception", 0);
                return null;
            }
        }
        return file;
    }

    private static Properties createProperties(StringSeqHolder args) {
        Properties properties = Util.createProperties();
        properties.setProperty("Ice.Override.ConnectTimeout", "5000");
        properties.setProperty("Ice.ThreadPerConnection", "1");
        properties.setProperty("Ice.ACM.Client", "0");
        properties.setProperty("Ice.MonitorConnections", "5");
        properties.setProperty("Ice.RetryIntervals", "-1");
        return Util.createProperties(args, properties);
    }

    Coordinator(JFrame mainFrame, StringSeqHolder args, Preferences prefs) {
        this._mainFrame = mainFrame;
        this._prefs = prefs;
        this._initData = new InitializationData();
        this._initData.properties = Coordinator.createProperties(args);
        if (args.value.length > 0) {
            System.err.println("WARNING: extra command-line arguments");
            for (int i = 0; i < args.value.length; ++i) {
                System.err.println(args.value[i]);
            }
        }
        this._liveDeploymentRoot = new IceGridGUI.LiveDeployment.Root(this);
        this._sessionKeeper = new SessionKeeper(this);
        this._shutdownHook = new Thread("Shutdown hook"){

            public void run() {
                Coordinator.this.destroyIceGridAdmin();
                Coordinator.this.destroyCommunicator();
            }
        };
        Runtime.getRuntime().addShutdownHook(this._shutdownHook);
        this._fileChooser = new JFileChooser();
        this._fileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".xml");
            }

            public String getDescription() {
                return ".xml files";
            }
        });
        int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._newApplication = new AbstractAction("Application"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.newApplication();
            }
        };
        this._newApplicationWithDefaultTemplates = new AbstractAction("Application with default templates from registry"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.newApplicationWithDefaultTemplates();
            }
        };
        this._newApplicationWithDefaultTemplates.setEnabled(false);
        this._login = new AbstractAction("Login..."){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this._sessionKeeper.relog(true);
            }
        };
        this._login.putValue("ShortDescription", "Log into an IceGrid registry");
        this._logout = new AbstractAction("Logout"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this._sessionKeeper.logout(true);
            }
        };
        this._logout.putValue("ShortDescription", "Logout");
        this._logout.setEnabled(false);
        this._acquireExclusiveWriteAccess = new AbstractAction("Acquire exclusive write access"){

            public void actionPerformed(ActionEvent e) {
                try {
                    Coordinator.this.acquireExclusiveWriteAccess(null);
                    Coordinator.this._releaseExclusiveWriteAccess.setEnabled(true);
                    Coordinator.this._acquireExclusiveWriteAccess.setEnabled(false);
                }
                catch (AccessDeniedException ade) {
                    Coordinator.this.accessDenied(ade);
                }
            }
        };
        this._acquireExclusiveWriteAccess.putValue("ShortDescription", "Acquire exclusive write access on the registry");
        this._acquireExclusiveWriteAccess.setEnabled(false);
        this._releaseExclusiveWriteAccess = new AbstractAction("Release exclusive write access"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.releaseExclusiveWriteAccess();
                Coordinator.this._acquireExclusiveWriteAccess.setEnabled(true);
                Coordinator.this._releaseExclusiveWriteAccess.setEnabled(false);
            }
        };
        this._releaseExclusiveWriteAccess.putValue("ShortDescription", "Release exclusive write access on the registry");
        this._releaseExclusiveWriteAccess.setEnabled(false);
        this._openApplicationFromFile = new AbstractAction("Application from file"){

            public void actionPerformed(ActionEvent e) {
                File file;
                ApplicationDescriptor desc;
                int result = Coordinator.this._fileChooser.showOpenDialog(Coordinator.this._mainFrame);
                if (result == 0 && (desc = Coordinator.this.parseFile(file = Coordinator.this._fileChooser.getSelectedFile())) != null) {
                    Root root = new Root(Coordinator.this, desc, false, file);
                    ApplicationPane app = new ApplicationPane(root);
                    Coordinator.this._mainPane.addApplication(app);
                    Coordinator.this._mainPane.setSelectedComponent(app);
                    root.setSelectedNode(root);
                }
            }
        };
        this._openApplicationFromFile.putValue("ShortDescription", "Open application from file");
        this._openApplicationFromFile.setEnabled(true);
        this._openApplicationFromRegistry = new AbstractAction("Application from registry"){

            public void actionPerformed(ActionEvent e) {
                Object[] applicationNames = Coordinator.this._liveDeploymentRoot.getApplicationNames();
                if (applicationNames.length == 0) {
                    JOptionPane.showMessageDialog(Coordinator.this._mainFrame, "The registry does not contain any application", "Empty registry", 1);
                } else {
                    Root root;
                    String appName = (String)JOptionPane.showInputDialog(Coordinator.this._mainFrame, "Which Application do you want to open?", "Open Application from registry", 3, null, applicationNames, applicationNames[0]);
                    if (appName != null && (root = Coordinator.this.openLiveApplication(appName).getRoot()).getSelectedNode() == null) {
                        root.setSelectedNode(root);
                    }
                }
            }
        };
        this._openApplicationFromRegistry.putValue("ShortDescription", "Open application from registry");
        this._openApplicationFromRegistry.setEnabled(false);
        this._closeApplication = new AbstractAction("Close application"){

            public void actionPerformed(ActionEvent e) {
                Tab tab = Coordinator.this.getCurrentTab();
                if (tab.close()) {
                    String id = ((ApplicationPane)tab).getRoot().getId();
                    Coordinator.this._liveApplications.remove(id);
                }
            }
        };
        this._closeApplication.putValue("ShortDescription", "Close application");
        this._closeApplication.setEnabled(false);
        this._save = new AbstractAction("Save"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().save();
            }
        };
        this._save.setEnabled(false);
        this._save.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, MENU_MASK));
        this._save.putValue("ShortDescription", "Save");
        this._saveToRegistry = new AbstractAction("Save to registry"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().saveToRegistry();
            }
        };
        this._saveToRegistry.setEnabled(false);
        this._saveToRegistry.putValue("ShortDescription", "Save to registry");
        this._saveToFile = new AbstractAction("Save to file"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().saveToFile();
            }
        };
        this._saveToFile.setEnabled(false);
        this._saveToFile.putValue("ShortDescription", "Save to file");
        this._discardUpdates = new AbstractAction("Discard updates..."){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().discardUpdates();
            }
        };
        this._discardUpdates.setEnabled(false);
        this._discardUpdates.putValue("ShortDescription", "Discard updates");
        this._exit = new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.exit(0);
            }
        };
        this._exit.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt F4"));
        this._back = new AbstractAction("Go back to the previous node"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().back();
            }
        };
        this._back.setEnabled(false);
        this._back.putValue("ShortDescription", "Go back to the previous node");
        this._forward = new AbstractAction("Go to the next node"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().forward();
            }
        };
        this._forward.setEnabled(false);
        this._forward.putValue("ShortDescription", "Go to the next node");
        this._helpContents = new AbstractAction("Contents"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.helpContents();
            }
        };
        this._about = new AbstractAction("About"){

            public void actionPerformed(ActionEvent e) {
                Coordinator.this.about();
            }
        };
        this._patchApplication = new AbstractAction("Patch distribution"){

            public void actionPerformed(ActionEvent e) {
                Object[] applicationNames = Coordinator.this._liveDeploymentRoot.getPatchableApplicationNames();
                if (applicationNames.length == 0) {
                    JOptionPane.showMessageDialog(Coordinator.this._mainFrame, "No application in this IceGrid registry can be patched", "No application", 1);
                } else {
                    String appName = (String)JOptionPane.showInputDialog(Coordinator.this._mainFrame, "Which Application do you want to patch?", "Patch application", 3, null, applicationNames, applicationNames[0]);
                    if (appName != null) {
                        Coordinator.this._liveDeploymentRoot.patch(appName);
                    }
                }
            }
        };
        this._patchApplication.setEnabled(false);
        this._showVarsMenuItem = new JCheckBoxMenuItem(this._appActionsForMenu.get(16));
        this._showVarsTool = new JToggleButton(this._appActionsForMenu.get(16));
        this._showVarsTool.setIcon(Utils.getIcon("/icons/24x24/show_vars.png"));
        this._showVarsTool.setText("");
        this._substituteMenuItem = new JCheckBoxMenuItem(this._appActionsForMenu.get(17));
        this._substituteTool = new JToggleButton(this._appActionsForMenu.get(17));
        this._substituteTool.setIcon(Utils.getIcon("/icons/24x24/substitute.png"));
        this._substituteTool.setText("");
        ButtonGroup group = new ButtonGroup();
        group.add(this._showVarsMenuItem);
        group.add(this._substituteMenuItem);
        group = new ButtonGroup();
        group.add(this._showVarsTool);
        group.add(this._substituteTool);
        this._showVarsMenuItem.setSelected(true);
        this._showVarsTool.setSelected(true);
        this._mainFrame.setJMenuBar(new MenuBar());
        this._mainFrame.getContentPane().add((Component)new ToolBar(), "First");
        this._mainFrame.getContentPane().add((Component)this._statusBar, "Last");
        this._liveDeploymentPane = new LiveDeploymentPane(this._liveDeploymentRoot);
        this._mainPane = new MainPane(this);
        this._mainFrame.getContentPane().add((Component)this._mainPane, "Center");
    }

    JComponent getLiveDeploymentPane() {
        return this._liveDeploymentPane;
    }

    public IceGridGUI.LiveDeployment.Root getLiveDeploymentRoot() {
        return this._liveDeploymentRoot;
    }

    private void newApplication() {
        ApplicationDescriptor desc = new ApplicationDescriptor("NewApplication", new TreeMap(), new LinkedList(), new HashMap(), new HashMap(), new HashMap(), new DistributionDescriptor("", new LinkedList()), "", new HashMap());
        Root root = new Root(this, desc);
        ApplicationPane app = new ApplicationPane(root);
        this._mainPane.addApplication(app);
        this._mainPane.setSelectedComponent(app);
        root.setSelectedNode(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newApplicationWithDefaultTemplates() {
        this._mainFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ApplicationDescriptor descriptor = this.getAdmin().getDefaultApplicationDescriptor();
            descriptor.name = "NewApplication";
            Root root = new Root(this, descriptor);
            ApplicationPane app = new ApplicationPane(root);
            this._mainPane.addApplication(app);
            this._mainPane.setSelectedComponent(app);
            root.setSelectedNode(root);
        }
        catch (DeploymentException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "The default application descriptor from the IceGrid registry is invalid:\n" + e.reason, "Deployment Exception", 0);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "Could not retrieve the default application descriptor from the IceGrid registry: \n" + e.toString(), "Trouble with IceGrid registry", 0);
        }
        finally {
            this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void helpContents() {
        BareBonesBrowserLaunch.openURL("http://www.zeroc.com/help/IceGridAdmin/");
    }

    private void about() {
        String text = "IceGrid Admin version 3.1.1\nCopyright \u00a9 2005-2006 ZeroC, Inc. All rights reserved.\n";
        JOptionPane.showMessageDialog(this._mainFrame, text, "About - IceGrid Admin", 1);
    }

    public void setClipboard(Object copy) {
        this._clipboard = copy;
    }

    public Object getClipboard() {
        return this._clipboard;
    }

    void showMainFrame() {
        if (!this.loadWindowPrefs()) {
            this._mainFrame.setLocation(100, 100);
            this._mainFrame.pack();
        }
        this._mainFrame.setVisible(true);
    }

    void exit(int status) {
        this.storeWindowPrefs();
        this.destroyIceGridAdmin();
        this.destroyCommunicator();
        Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
        this._mainFrame.dispose();
        Runtime.getRuntime().exit(status);
    }

    private void destroyCommunicator() {
        if (this._communicator != null) {
            try {
                this._communicator.destroy();
            }
            catch (LocalException e) {
                System.err.println("_communicator.destroy() raised " + e.toString());
                e.printStackTrace();
            }
            this._communicator = null;
        }
    }

    private boolean loadWindowPrefs() {
        try {
            if (!this._prefs.nodeExists("Window")) {
                return false;
            }
        }
        catch (BackingStoreException e) {
            return false;
        }
        Preferences windowPrefs = this._prefs.node("Window");
        int x = windowPrefs.getInt("x", 0);
        int y = windowPrefs.getInt("y", 0);
        int width = windowPrefs.getInt("width", 0);
        int height = windowPrefs.getInt("height", 0);
        this._mainFrame.setBounds(new Rectangle(x, y, width, height));
        if (windowPrefs.getBoolean("maximized", false)) {
            this._mainFrame.setExtendedState(6);
        }
        return true;
    }

    private void storeWindowPrefs() {
        Preferences windowPrefs = this._prefs.node("Window");
        Rectangle rect = this._mainFrame.getBounds();
        windowPrefs.putInt("x", rect.x);
        windowPrefs.putInt("y", rect.y);
        windowPrefs.putInt("width", rect.width);
        windowPrefs.putInt("height", rect.height);
        windowPrefs.putBoolean("maximized", this._mainFrame.getExtendedState() == 6);
    }

    public AdminSessionPrx getSession() {
        return this._sessionKeeper.getSession();
    }

    Preferences getPrefs() {
        return this._prefs;
    }

    public LiveActions getLiveActionsForPopup() {
        return this._liveActionsForPopup;
    }

    public LiveActions getLiveActionsForMenu() {
        return this._liveActionsForMenu;
    }

    public ApplicationActions getActionsForMenu() {
        return this._appActionsForMenu;
    }

    public ApplicationActions getActionsForPopup() {
        return this._appActionsForPopup;
    }

    public void showActions(TreeNode node) {
        boolean[] availableActions = this._liveActionsForMenu.setTarget(node);
        this._appActionsForMenu.setTarget(null);
        this._newServerMenu.setEnabled(false);
        this._newServiceMenu.setEnabled(false);
        this._newTemplateMenu.setEnabled(false);
        this._appMenu.setEnabled(true);
        this._nodeMenu.setEnabled(availableActions[4]);
        this._registryMenu.setEnabled(availableActions[6]);
        this._serverMenu.setEnabled(availableActions[0] || availableActions[1] || availableActions[2] || availableActions[3] || availableActions[5]);
    }

    public void showActions(IceGridGUI.Application.TreeNode node) {
        boolean[] availableActions = this._appActionsForMenu.setTarget(node);
        this._liveActionsForMenu.setTarget(null);
        this._newServerMenu.setEnabled(availableActions[5] || availableActions[6] || availableActions[7]);
        this._newServiceMenu.setEnabled(availableActions[8] || availableActions[9]);
        this._newTemplateMenu.setEnabled(availableActions[10] || availableActions[11] || availableActions[12]);
        this._appMenu.setEnabled(false);
        this._nodeMenu.setEnabled(false);
        this._registryMenu.setEnabled(false);
        this._serverMenu.setEnabled(false);
    }

    static {
        $assertionsDisabled = !Coordinator.class.desiredAssertionStatus();
    }

    private class ToolBar
    extends JToolBar {
        private ToolBar() {
            this.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            this.setFloatable(false);
            this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            JButton button = new JButton(Coordinator.this._login);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/login.png"));
            this.add(button);
            button = new JButton(Coordinator.this._logout);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/logout.png"));
            this.add(button);
            this.addSeparator();
            button = new JButton(Coordinator.this._back);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/back.png"));
            this.add(button);
            button = new JButton(Coordinator.this._forward);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/forward.png"));
            this.add(button);
            this.addSeparator();
            button = new JButton(Coordinator.this._openApplicationFromRegistry);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/open_from_registry.png"));
            this.add(button);
            button = new JButton(Coordinator.this._openApplicationFromFile);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/open_from_file.png"));
            this.add(button);
            this.addSeparator();
            button = new JButton(Coordinator.this._save);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/save.png"));
            this.add(button);
            button = new JButton(Coordinator.this._saveToRegistry);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/save_to_registry.png"));
            this.add(button);
            button = new JButton(Coordinator.this._saveToFile);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/save_to_file.png"));
            this.add(button);
            button = new JButton(Coordinator.this._discardUpdates);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/discard.png"));
            this.add(button);
            this.addSeparator();
            button = new JButton(Coordinator.this._appActionsForMenu.get(13));
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/copy.png"));
            this.add(button);
            button = new JButton(Coordinator.this._appActionsForMenu.get(14));
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/paste.png"));
            this.add(button);
            button = new JButton(Coordinator.this._appActionsForMenu.get(15));
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/delete.png"));
            this.add(button);
            this.addSeparator();
            this.add(Coordinator.this._showVarsTool);
            this.add(Coordinator.this._substituteTool);
        }
    }

    private class MenuBar
    extends JMenuBar {
        private MenuBar() {
            this.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            JMenu fileMenu = new JMenu("File");
            fileMenu.setMnemonic(70);
            this.add(fileMenu);
            Coordinator.this._newMenu = new JMenu("New");
            fileMenu.add(Coordinator.this._newMenu);
            Coordinator.this._newMenu.add(Coordinator.this._newApplication);
            Coordinator.this._newMenu.add(Coordinator.this._newApplicationWithDefaultTemplates);
            Coordinator.this._newMenu.addSeparator();
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(0));
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(1));
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(2));
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(3));
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(4));
            JMenu openMenu = new JMenu("Open");
            openMenu.add(Coordinator.this._openApplicationFromFile);
            openMenu.add(Coordinator.this._openApplicationFromRegistry);
            Coordinator.this._newServerMenu = new JMenu("Server");
            Coordinator.this._newServerMenu.setEnabled(false);
            Coordinator.this._newMenu.add(Coordinator.this._newServerMenu);
            Coordinator.this._newServerMenu.add(Coordinator.this._appActionsForMenu.get(5));
            Coordinator.this._newServerMenu.add(Coordinator.this._appActionsForMenu.get(6));
            Coordinator.this._newServerMenu.add(Coordinator.this._appActionsForMenu.get(7));
            Coordinator.this._newServiceMenu = new JMenu("Service");
            Coordinator.this._newServiceMenu.setEnabled(false);
            Coordinator.this._newMenu.add(Coordinator.this._newServiceMenu);
            Coordinator.this._newServiceMenu.add(Coordinator.this._appActionsForMenu.get(8));
            Coordinator.this._newServiceMenu.add(Coordinator.this._appActionsForMenu.get(9));
            Coordinator.this._newTemplateMenu = new JMenu("Template");
            Coordinator.this._newTemplateMenu.setEnabled(false);
            Coordinator.this._newMenu.add(Coordinator.this._newTemplateMenu);
            Coordinator.this._newTemplateMenu.add(Coordinator.this._appActionsForMenu.get(10));
            Coordinator.this._newTemplateMenu.add(Coordinator.this._appActionsForMenu.get(11));
            Coordinator.this._newTemplateMenu.add(Coordinator.this._appActionsForMenu.get(12));
            fileMenu.addSeparator();
            fileMenu.add(Coordinator.this._login);
            fileMenu.add(Coordinator.this._logout);
            fileMenu.addSeparator();
            fileMenu.add(Coordinator.this._acquireExclusiveWriteAccess);
            fileMenu.add(Coordinator.this._releaseExclusiveWriteAccess);
            fileMenu.addSeparator();
            fileMenu.add(openMenu);
            fileMenu.add(Coordinator.this._closeApplication);
            fileMenu.add(Coordinator.this._save);
            fileMenu.add(Coordinator.this._saveToFile);
            fileMenu.add(Coordinator.this._saveToRegistry);
            fileMenu.addSeparator();
            fileMenu.add(Coordinator.this._discardUpdates);
            fileMenu.addSeparator();
            fileMenu.add(Coordinator.this._exit);
            JMenu editMenu = new JMenu("Edit");
            editMenu.setMnemonic(69);
            this.add(editMenu);
            editMenu.add(Coordinator.this._appActionsForMenu.get(13));
            editMenu.add(Coordinator.this._appActionsForMenu.get(14));
            editMenu.addSeparator();
            editMenu.add(Coordinator.this._appActionsForMenu.get(15));
            editMenu.addSeparator();
            editMenu.add(Coordinator.this._appActionsForMenu.get(18));
            editMenu.add(Coordinator.this._appActionsForMenu.get(19));
            JMenu viewMenu = new JMenu("View");
            viewMenu.setMnemonic(86);
            this.add(viewMenu);
            viewMenu.add(Coordinator.this._showVarsMenuItem);
            viewMenu.add(Coordinator.this._substituteMenuItem);
            viewMenu.addSeparator();
            viewMenu.add(Coordinator.this._back);
            viewMenu.add(Coordinator.this._forward);
            JMenu toolsMenu = new JMenu("Tools");
            toolsMenu.setMnemonic(84);
            this.add(toolsMenu);
            Coordinator.this._appMenu = new JMenu("Application");
            Coordinator.this._appMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._appMenu);
            Coordinator.this._appMenu.add(Coordinator.this._patchApplication);
            Coordinator.this._appMenu.setEnabled(false);
            Coordinator.this._nodeMenu = new JMenu("Node");
            Coordinator.this._nodeMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._nodeMenu);
            Coordinator.this._nodeMenu.add(Coordinator.this._liveActionsForMenu.get(4));
            Coordinator.this._registryMenu = new JMenu("Registry");
            Coordinator.this._registryMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._registryMenu);
            Coordinator.this._registryMenu.add(Coordinator.this._liveActionsForMenu.get(6));
            Coordinator.this._serverMenu = new JMenu("Server");
            Coordinator.this._serverMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._serverMenu);
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(0));
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(1));
            Coordinator.this._serverMenu.addSeparator();
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(2));
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(3));
            Coordinator.this._serverMenu.addSeparator();
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(5));
            JMenu helpMenu = new JMenu("Help");
            helpMenu.setMnemonic(72);
            this.add(helpMenu);
            helpMenu.add(Coordinator.this._helpContents);
            helpMenu.addSeparator();
            helpMenu.add(Coordinator.this._about);
        }
    }

    private class StatusBarI
    extends JPanel
    implements StatusBar {
        JLabel _connectedLabel;
        JLabel _text;

        StatusBarI() {
            super(new BorderLayout());
            this.setBorder(new EmptyBorder(0, 13, 10, 13));
            this._text = new JLabel();
            this._text.setHorizontalAlignment(2);
            this.add((Component)this._text, "Before");
            this._connectedLabel = new JLabel("Working Offline");
            this._connectedLabel.setHorizontalAlignment(4);
            this.add((Component)this._connectedLabel, "After");
        }

        public void setText(String text) {
            this._text.setText(text);
        }

        public void setConnected(boolean connected) {
            if (connected) {
                this._connectedLabel.setText("Working Online");
            } else {
                this._connectedLabel.setText("Working Offline");
            }
        }
    }
}

