#!/usr/bin/env python
# **********************************************************************
#
# Copyright (c) 2003-2006 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************

import os, sys
import getopt

for toplevel in [".", "..", "../..", "../../..", "../../../.."]:
    toplevel = os.path.normpath(toplevel)
    if os.path.exists(os.path.join(toplevel, "config", "TestUtil.py")):
        break
else:
    raise "can't find toplevel directory!"

def runTests(args, tests, num = 0):

    #
    # Run each of the tests.
    #
    for i in tests:

	i = os.path.normpath(i)
	dir = os.path.join(toplevel, "test", i)

	print
	if(num > 0):
	    print "[" + str(num) + "]",
	print "*** running tests in " + dir,
	print

	status = os.system(os.path.join(dir, "run.py " + args))

	if status:
	    if(num > 0):
		print "[" + str(num) + "]",
	    print "test in " + dir + " failed with exit status", status,
	    sys.exit(status)

#
# List of all basic tests.
#
tests = [ \
    "IceUtil/inputUtil", \
    "Ice/operations", \
    "Ice/exceptions", \
    "Ice/inheritance", \
    "Ice/facets", \
    "Ice/hold", \
    "Ice/objects", \
    "Ice/binding", \
    "Ice/faultTolerance", \
    "Ice/location", \
    "Ice/adapterDeactivation", \
    "Ice/slicing/exceptions", \
    "Ice/slicing/objects", \
    "Ice/checksum", \
    "Ice/stream", \
    "Ice/retry", \
    "Ice/timeout", \
    "Glacier2/router", \
    "Glacier2/attack", \
    "IceGrid/simple", \
    ]
if os.path.exists(os.path.join(toplevel, "bin", "icesslcs.dll")):
    tests.append("IceSSL/configuration")

def usage():
    print "usage: " + sys.argv[0] + " -m|--mono -l -r <regex> -R <regex> --debug --protocol protocol --compress --host host --threadPerConnection"
    sys.exit(2)

try:
    opts, args = getopt.getopt(sys.argv[1:], "lmr:R:", \
    	["mono", "debug", "protocol=", "compress", "host=", "threadPerConnection"])
except getopt.GetoptError:
    usage()

if(args):
    usage()

loop = 0
args = ""
for o, a in opts:
    if o == "-l":
        loop = 1
    if o == "-r" or o == '-R':
	import re
	regexp = re.compile(a)
	if o == '-r':
	    def rematch(x): return regexp.search(x)
	else:
	    def rematch(x): return not regexp.search(x)
	tests = filter(rematch, tests)
    if o in ( "--protocol", "--host" ):
	args += " " + o + " " + a
    if o in ( "--debug", "-m", "--mono", "--compress", "--threadPerConnection" ):
	args += " " + o
    
if loop:
    num = 1
    while 1:
	runTests(args, tests, num)
	num += 1
else:
    runTests(args, tests)
