/* $Id: tide_db_header.h,v 1.3 2002/10/01 18:37:27 flaterco Exp $ */

/*****************************************************************************\

                            DISTRIBUTION STATEMENT

    This source file is unclassified, distribution unlimited, public
    domain.  It is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

\*****************************************************************************/




/***************************************************************************\

    Module Name:        TIDE DB option header file

    Programmer(s):      Jan C. Depner

    Date Written:       July 2002

    Purpose:            This header file defines all of the format options
                        that are stored in the TIDE DB file header.  To add a 
                        new option you simply add it to the header_data 
                        structure, then put a definition in the keys structure.
                        The keys structure contains a keyphrase such as 
                        "[DATE]", a format like "%s", a datatype (see the 
                        union in the TIDE_HEADER_DATA structure, a pointer to 
                        the location at which to store the value(s), a count 
                        if it is a repeating field (array), and a version
                        dependency flag (major.minor * 10).



*****************************************************************************

    This header file uses the NAVO standard data types.  You must set one of
    the following options on the compile command line:

    NVDOS, NVHPUX, NVIRIX, NVCLIX, NVLinux, NVSUNOS, NVWINNT, or NVWIN3X

\***************************************************************************/


#ifndef __TIDE_HEADER__
#define __TIDE_HEADER__

#include "tcd.h"


typedef struct
{
    NV_CHAR                    *keyphrase;
    NV_CHAR                    *format;
    NV_CHAR                    *datatype;
    union
    {
        NV_U_CHAR              *uc;
        NV_U_BYTE              *ub;
        NV_CHAR                *c;
        NV_CHAR                **sa;
        NV_BOOL                *b;
        NV_INT16               *i16;
        NV_INT32               *i32;
        NV_INT64               *i64;
        NV_U_INT16             *ui16;
        NV_U_INT32             *ui32;
        NV_U_INT64             *ui64;
        NV_FLOAT32             *f32;
        NV_FLOAT64             *f64;
        NV_C_HSV               *hsv;
        NV_C_RGB               *rgb;
        NV_F64_POS             *f64p;
        NV_F64_POSDEP          *f64pd;
        NV_F64_XYMBR           *mbr;
	NV_I32_COORD2          *i32c2;
	NV_I32_COORD3          *i32c3;
	NV_F64_COORD2          *f64c2;
	NV_F64_COORD3          *f64c3;
    } address;
    NV_INT32                   *count;
    NV_INT16                   version_dependency;       /*  Version * 10  */
} KEY;


typedef struct
{
    DB_HEADER_PUBLIC  pub;
    NV_CHAR           **constituent;
    NV_FLOAT64        *speed;
    NV_FLOAT32        **equilibrium;
    NV_FLOAT32        **node_factor;
    NV_CHAR           **level_unit;
    NV_CHAR           **dir_unit;
    NV_CHAR           **restriction;
    NV_CHAR           **pedigree;
    NV_CHAR           **tzfile;
    NV_CHAR           **country;
    NV_CHAR           **datum;
    NV_INT32          header_size;
    NV_INT32          speed_bits;
    NV_INT32          speed_scale;
    NV_INT32          speed_offset;
    NV_INT32          equilibrium_bits;
    NV_INT32          equilibrium_scale;
    NV_INT32          equilibrium_offset;
    NV_INT32          node_bits;
    NV_INT32          node_scale;
    NV_INT32          node_offset;
    NV_INT32          amplitude_bits;
    NV_INT32          amplitude_scale;
    NV_INT32          epoch_bits;
    NV_INT32          epoch_scale;
    NV_INT32          constituent_bits;
    NV_INT32          record_type_bits;
    NV_INT32          latitude_scale;
    NV_INT32          latitude_bits;
    NV_INT32          longitude_scale;
    NV_INT32          longitude_bits;
    NV_INT32          record_size_bits;
    NV_INT32          station_bits;
    NV_INT32          level_unit_bits;
    NV_INT32          dir_unit_bits;
    NV_INT32          restriction_bits;
    NV_INT32          max_restriction_types;
    NV_INT32          pedigree_bits;
    NV_INT32          max_pedigree_types;
    NV_INT32          tzfile_bits;
    NV_INT32          max_tzfiles;
    NV_INT32          country_bits;
    NV_INT32          max_countries;
    NV_INT32          datum_bits;
    NV_INT32          max_datum_types;
    NV_INT32          datum_offset_bits;
    NV_INT32          datum_offset_scale;
    NV_INT32          date_bits;
    NV_INT32          months_on_station_bits;
    NV_INT32          confidence_value_bits;
    NV_INT32          time_bits;
    NV_INT32          level_add_bits;
    NV_INT32          level_add_scale;
    NV_INT32          level_multiply_bits;
    NV_INT32          level_multiply_scale;
    NV_INT32          direction_bits;
    NV_INT32          constituent_size;
    NV_INT32          level_unit_size;
    NV_INT32          dir_unit_size;
    NV_INT32          restriction_size;
    NV_INT32          pedigree_size;
    NV_INT32          tzfile_size;
    NV_INT32          country_size;
    NV_INT32          datum_size;
    NV_INT32          end_of_file;
} TIDE_HEADER_DATA;


static TIDE_HEADER_DATA        hd;

static KEY                     keys[] = 
{
    {
        "[VERSION]",
        "%s",
        "string",
        {(void *) hd.pub.version},
        NULL,
        0
    },


    {
        "[LAST MODIFIED]",
        "%s",
        "string",
        {(void *) hd.pub.last_modified},
        NULL,
        0
    },


    {
        "[NUMBER OF RECORDS]",
        "%d",
        "i32",
        {(void *) &hd.pub.number_of_records},
        NULL,
        0
    },


    {
        "[START YEAR]",
        "%d",
        "i32",
        {(void *) &hd.pub.start_year},
        NULL,
        0
    },


    {
        "[NUMBER OF YEARS]",
        "%d",
        "i32",
        {(void *) &hd.pub.number_of_years},
        NULL,
        0
    },

    {
        "[CONSTITUENTS]",
        "%d",
        "i32",
        {(void *) &hd.pub.constituents},
        NULL,
        0
    },

    {
        "[LEVEL UNIT TYPES]",
        "%d",
        "i32",
        {(void *) &hd.pub.level_unit_types},
        NULL,
        0
    },

    {
        "[DIRECTION UNIT TYPES]",
        "%d",
        "i32",
        {(void *) &hd.pub.dir_unit_types},
        NULL,
        0
    },

    {
        "[RESTRICTION TYPES]",
        "%d",
        "i32",
        {(void *) &hd.pub.restriction_types},
        NULL,
        0
    },

    {
        "[PEDIGREE TYPES]",
        "%d",
        "i32",
        {(void *) &hd.pub.pedigree_types},
        NULL,
        0
    },

    {
        "[TZFILES]",
        "%d",
        "i32",
        {(void *) &hd.pub.tzfiles},
        NULL,
        0
    },

    {
        "[COUNTRIES]",
        "%d",
        "i32",
        {(void *) &hd.pub.countries},
        NULL,
        0
    },

    {
        "[DATUM TYPES]",
        "%d",
        "i32",
        {(void *) &hd.pub.datum_types},
        NULL,
        0
    },

    {
        "[HEADER SIZE]",
        "%d",
        "i32",
        {(void *) &hd.header_size},
        NULL,
        0
    },


    {
        "[SPEED BITS]",
        "%d",
        "i32",
        {(void *) &hd.speed_bits},
        NULL,
        0
    },


    {
        "[SPEED SCALE]",
        "%d",
        "i32",
        {(void *) &hd.speed_scale},
        NULL,
        0
    },


    {
        "[SPEED OFFSET]",
        "%d",
        "i32",
        {(void *) &hd.speed_offset},
        NULL,
        0
    },


    {
        "[EQUILIBRIUM BITS]",
        "%d",
        "i32",
        {(void *) &hd.equilibrium_bits},
        NULL,
        0
    },


    {
        "[EQUILIBRIUM SCALE]",
        "%d",
        "i32",
        {(void *) &hd.equilibrium_scale},
        NULL,
        0
    },


    {
        "[EQUILIBRIUM OFFSET]",
        "%d",
        "i32",
        {(void *) &hd.equilibrium_offset},
        NULL,
        0
    },


    {
        "[NODE BITS]",
        "%d",
        "i32",
        {(void *) &hd.node_bits},
        NULL,
        0
    },


    {
        "[NODE SCALE]",
        "%d",
        "i32",
        {(void *) &hd.node_scale},
        NULL,
        0
    },


    {
        "[NODE OFFSET]",
        "%d",
        "i32",
        {(void *) &hd.node_offset},
        NULL,
        0
    },


    {
        "[AMPLITUDE BITS]",
        "%d",
        "i32",
        {(void *) &hd.amplitude_bits},
        NULL,
        0
    },


    {
        "[AMPLITUDE SCALE]",
        "%d",
        "i32",
        {(void *) &hd.amplitude_scale},
        NULL,
        0
    },


    {
        "[EPOCH BITS]",
        "%d",
        "i32",
        {(void *) &hd.epoch_bits},
        NULL,
        0
    },


    {
        "[EPOCH SCALE]",
        "%d",
        "i32",
        {(void *) &hd.epoch_scale},
        NULL,
        0
    },


    {
        "[CONSTITUENT BITS]",
        "%d",
        "i32",
        {(void *) &hd.constituent_bits},
        NULL,
        0
    },


    {
        "[LEVEL UNIT BITS]",
        "%d",
        "i32",
        {(void *) &hd.level_unit_bits},
        NULL,
        0
    },


    {
        "[DIRECTION UNIT BITS]",
        "%d",
        "i32",
        {(void *) &hd.dir_unit_bits},
        NULL,
        0
    },


    {
        "[RESTRICTION BITS]",
        "%d",
        "i32",
        {(void *) &hd.restriction_bits},
        NULL,
        0
    },


    {
        "[PEDIGREE BITS]",
        "%d",
        "i32",
        {(void *) &hd.pedigree_bits},
        NULL,
        0
    },


    {
        "[TZFILE BITS]",
        "%d",
        "i32",
        {(void *) &hd.tzfile_bits},
        NULL,
        0
    },


    {
        "[COUNTRY BITS]",
        "%d",
        "i32",
        {(void *) &hd.country_bits},
        NULL,
        0
    },


    {
        "[DATUM BITS]",
        "%d",
        "i32",
        {(void *) &hd.datum_bits},
        NULL,
        0
    },


    {
        "[RECORD TYPE BITS]",
        "%d",
        "i32",
        {(void *) &hd.record_type_bits},
        NULL,
        0
    },


    {
        "[LATITUDE SCALE]",
        "%d",
        "i32",
        {(void *) &hd.latitude_scale},
        NULL,
        0
    },


    {
        "[LATITUDE BITS]",
        "%d",
        "i32",
        {(void *) &hd.latitude_bits},
        NULL,
        0
    },


    {
        "[LONGITUDE SCALE]",
        "%d",
        "i32",
        {(void *) &hd.longitude_scale},
        NULL,
        0
    },


    {
        "[LONGITUDE BITS]",
        "%d",
        "i32",
        {(void *) &hd.longitude_bits},
        NULL,
        0
    },


    {
        "[RECORD SIZE BITS]",
        "%d",
        "i32",
        {(void *) &hd.record_size_bits},
        NULL,
        0
    },


    {
        "[STATION BITS]",
        "%d",
        "i32",
        {(void *) &hd.station_bits},
        NULL,
        0
    },


    {
        "[DATUM OFFSET BITS]",
        "%d",
        "i32",
        {(void *) &hd.datum_offset_bits},
        NULL,
        0
    },


    {
        "[DATUM OFFSET SCALE]",
        "%d",
        "i32",
        {(void *) &hd.datum_offset_scale},
        NULL,
        0
    },


    {
        "[DATE BITS]",
        "%d",
        "i32",
        {(void *) &hd.date_bits},
        NULL,
        0
    },


    {
        "[MONTHS ON STATION BITS]",
        "%d",
        "i32",
        {(void *) &hd.months_on_station_bits},
        NULL,
        0
    },


    {
        "[CONFIDENCE VALUE BITS]",
        "%d",
        "i32",
        {(void *) &hd.confidence_value_bits},
        NULL,
        0
    },


    {
        "[TIME BITS]",
        "%d",
        "i32",
        {(void *) &hd.time_bits},
        NULL,
        0
    },


    {
        "[LEVEL ADD BITS]",
        "%d",
        "i32",
        {(void *) &hd.level_add_bits},
        NULL,
        0
    },


    {
        "[LEVEL ADD SCALE]",
        "%d",
        "i32",
        {(void *) &hd.level_add_scale},
        NULL,
        0
    },


    {
        "[LEVEL MULTIPLY BITS]",
        "%d",
        "i32",
        {(void *) &hd.level_multiply_bits},
        NULL,
        0
    },


    {
        "[LEVEL MULTIPLY SCALE]",
        "%d",
        "i32",
        {(void *) &hd.level_multiply_scale},
        NULL,
        0
    },


    {
        "[DIRECTION BITS]",
        "%d",
        "i32",
        {(void *) &hd.direction_bits},
        NULL,
        0
    },


    {
        "[CONSTITUENT SIZE]",
        "%d",
        "i32",
        {(void *) &hd.constituent_size},
        NULL,
        0
    },


    {
        "[LEVEL UNIT SIZE]",
        "%d",
        "i32",
        {(void *) &hd.level_unit_size},
        NULL,
        0
    },


    {
        "[DIRECTION UNIT SIZE]",
        "%d",
        "i32",
        {(void *) &hd.dir_unit_size},
        NULL,
        0
    },


    {
        "[RESTRICTION SIZE]",
        "%d",
        "i32",
        {(void *) &hd.restriction_size},
        NULL,
        0
    },


    {
        "[PEDIGREE SIZE]",
        "%d",
        "i32",
        {(void *) &hd.pedigree_size},
        NULL,
        0
    },


    {
        "[TZFILE SIZE]",
        "%d",
        "i32",
        {(void *) &hd.tzfile_size},
        NULL,
        0
    },


    {
        "[COUNTRY SIZE]",
        "%d",
        "i32",
        {(void *) &hd.country_size},
        NULL,
        0
    },


    {
        "[DATUM SIZE]",
        "%d",
        "i32",
        {(void *) &hd.datum_size},
        NULL,
        0
    },


    {
        "[END OF FILE]",
        "%d",
        "i32",
        {(void *) &hd.end_of_file},
        NULL,
        0
    }
};
#endif
