// $Id: Constituent.hh,v 1.2 2002/10/04 13:44:00 flaterco Exp $
// Constituent:  definition of a constituent (name, speed, equilibrium args,
// node factors).  This is an abstract class implemented by BaseConstituent
// and TabulatedConstituent.  (BaseConstituent is only present in the
// congen package.)

/*
    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class Constituent {
protected:
  Speed myspeed;
  Dstr myname;
  Dstr &padname ();
public:
  virtual ~Constituent();
  Dstr &name();
  void name (Dstr &in_name);
  Speed speed ();
  virtual Angle arg (Year in_year) = 0;   // Equilibrium arguments
  virtual double nod (Year in_year) = 0;  // Node factors

  virtual Year firstvalidyear() = 0;
  virtual Year lastvalidyear() = 0;

  // Lots and lots of pretty printing.  The Dstr & versions use static
  // buffers.
  Dstr &putspeed ();
  Dstr &putargs ();
  Dstr &putnods ();
  void putspeed (FILE *fp);
  void putargs (FILE *fp);
  void putnods (FILE *fp);
};
