/*  HarmonicsFile  Operations for reading harmonics files.
    Last modified 1998-04-10

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class TideContext;
class StationReference;
class ConstituentSet;
class Settings;

// If the specified file does not exist, the results will be as if
// it existed with zero length: getNextStationRef will return NULL.

class HarmonicsFile {
public:
  HarmonicsFile (Dstr &filename, Settings *in_settings);
  ~HarmonicsFile();
  StationRef *getNextStationRef();  // Allocates a new StationRef, returns
                                    // NULL if end of file.
  StationRef *getStationRef(const Dstr &name);  // Fast load
  Station *getStation (StationRef &in_ref,
                       TideContext *in_context);
protected:
  Settings *settings;
  Dstr *myfilename;
  FILE *fp;
  struct xmltag *myxmlparsetree;
  unsigned mynumconst;
  void getline(Dstr &inbuf);  // Skips comments and blanks, return null on EOF.
  void getline_f(Dstr &inbuf);  // Barf on EOF.
  Coordinates mycoords;
  unsigned lat_age, lng_age;
  long thislinestartpos;
  void skip_constituents();
  int got_past_constituents;
  ConstituentSet *get_constituents();

  SimpleOffsets *getSimpleOffsets (struct xmltag *t);   // new
  HairyOffsets *getHairyOffsets (struct xmltag *t);     // new
  CombinedOffset getCombinedOffset (struct xmltag *t);  // no pointer
};
