/*  Calendar  Manage construction, organization, and printing of calendars.
    Last modified 1998-06-02

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class Calendar {
public:
  Calendar (Station *station, Timestamp start_tm, Timestamp end_tm);
  ~Calendar ();

  void print (Dstr &text_out, int html_form);

  struct blurb {
    Timestamp t_out;
    Dstr etype_desc;
    int no_pv;
    PredictionValue pv_out;
    struct blurb *next;
  };

  struct day {
    Timestamp start;
    struct blurb *blurbs;
    struct day *next;
  };

protected:

  Dstr timezone, weekbuf[7];
  Settings *settings;
  Timestamp start_day_start, end_day_start;

  // A hash table is used to get around the ubiquitous problem of
  // subordinate stations returning tide events out of order.

  Calendar::day *hash[calhashsize];
  void add_blurb (struct blurb *b);
  void add_blurb (struct blurb *b, struct day *destination);
  Calendar::day *lookup_day (Timestamp start); // Ret. NULL if needs add
  Calendar::day *add_day (Timestamp start);

  void add_month_banner (Dstr &text_out, Timestamp t, int html_form);
  void flush_weekbuf (Dstr &text_out, int html_form, int endmonth = 0);
};
