/* by A Mennucci, Aug 2000
 *

 this code is the interface between the GTK+ toolkit and libmorph

 it is an intermediate step in between, 
 the mesh code and the complexity of the whole GUI

 it should be part of libmorph, but  then libmorph would need 
 to be linked against GTK+, and this is unwanted


*/


#include <stdio.h>
#include <stdlib.h>

//#include "xmorphspline.h"
#include "../libmorph/spl-array.h"
//#include "RgbaImage.h"
//#include "image_cb.h"
//#include "image_diw.h"
#include "../libmorph/mesh.h"
//#include "mjg_dialog.h"
#include "../libmorph/relax.h"

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#ifdef HAVE_X
#include <gdk/gdkx.h>
#endif
#include <gdk/gdkrgb.h>

#include "gtk/gtk.h"


#include "main.h"
#include "callbacks.h"
#include "mesh-gtk.h"
#include "gtk-extra.h"
#include "interface.h"

/*********************************************************************
 these callbacks are used when editing a mesh

 if they return TRUE, something was done to point *mi *mj
 (and often the mesh is smootheed)
********************************************************************/

int last_mi, last_mj, last_label, last_action;
GdkEventButton  last_event;
MeshT *last_mesh=NULL;

/*changes to point to point to upper left corner point, not nearest */
void
point_to_upper_left(MeshT *mesh,
		    int *mi, int *mj, /* the mesh point affected */
		    GdkEventButton  *event)
{
  if ( meshGetx(mesh, *mi,*mj) > event->x &&
       *mi>0 //
       //meshMaxx(mesh) < *mi 
       )
    { *mi -= 1;}

  if ( meshGety(mesh, *mi,*mj) > event->y &&
       *mj > 0 //
	       //meshMaxy(mesh) < *mj 
       )
    {*mj -= 1; }
}




void
on_unselect_point1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  last_action=1;
  if (settings_get_value("mesh auto sync")) {
    int lp=MAX_WINS+1;
    for(; lp>=0; lp--) 
      if( sp->im_widget[lp] != NULL) {
	meshSetLabel(&sp->im_mesh[lp], last_mi, last_mj, 0);
	gtk_widget_draw (sp->im_widget[lp] , NULL);
  }} else
    meshSetLabel(last_mesh, last_mi, last_mj, 0);
}


void
on_select_point_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  last_action=2;
  if (settings_get_value("mesh auto sync")) {
    int lp=MAX_WINS+1;
      for(; lp>=0; lp--) 
	if( sp->im_widget[lp] != NULL) {
	  meshSetLabel(&sp->im_mesh[lp], last_mi, last_mj, -1);
	  gtk_widget_draw (sp->im_widget[lp] , NULL);
  }}  else
    meshSetLabel(last_mesh, last_mi, last_mj, -1);
}


void
on_add_horizontal_line_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  point_to_upper_left(last_mesh,&last_mi,&last_mj,&last_event);  
  last_action=3;
  if (settings_get_value("mesh auto sync")) {
    int lp=MAX_WINS+1;
      for(; lp>=0; lp--) 
	if( sp->im_widget[lp] != NULL)  {
	    meshLineAdd(&sp->im_mesh[lp], last_mj, 0.5, 2);
	    gtk_widget_draw (sp->im_widget[lp] , NULL);
	}
  } else
  meshLineAdd(last_mesh, last_mj, 0.5, 2);

  sp->meshes_x= MAX(sp->meshes_x, last_mesh->nx);
  sp->meshes_y= MAX(sp->meshes_y, last_mesh->ny);
}


void
on_add_vertical_line_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  point_to_upper_left(last_mesh,&last_mi,&last_mj,&last_event);  
  last_action=4;
  if (settings_get_value("mesh auto sync"))    {
      int lp=MAX_WINS+1;
      for(; lp>=0; lp--) 
	if( sp->im_widget[lp] != NULL)  {
	    meshLineAdd(&sp->im_mesh[lp], last_mi, 0.5, 1);
	    gtk_widget_draw (sp->im_widget[lp] , NULL);
	}  
  }  else
    meshLineAdd(last_mesh, last_mi, 0.5, 1);
  sp->meshes_x= MAX(sp->meshes_x, last_mesh->nx);
  sp->meshes_y= MAX(sp->meshes_y, last_mesh->ny);
}


void
on_del_horizontal_line_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  //point_to_upper_left(last_mesh,&last_mi,&last_mj,&last_event);  
  last_action=5;
  if (settings_get_value("mesh auto sync")) {
    int lp=MAX_WINS+1;
    for(; lp>=0; lp--) 
	if( sp->im_widget[lp] != NULL)  {
	    meshLineDelete(&sp->im_mesh[lp], last_mj,  2);
	    gtk_widget_draw (sp->im_widget[lp] , NULL);
	}
  } else
  meshLineDelete(last_mesh, last_mj,  2);
}


void
on_del_vertical_line_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  //point_to_upper_left(last_mesh,&last_mi,&last_mj,&last_event);  
  last_action=6;
  if (settings_get_value("mesh auto sync"))    {
      int lp=MAX_WINS+1;
      for(; lp>=0; lp--) 
	if( sp->im_widget[lp] != NULL)  {
	    meshLineDelete(&sp->im_mesh[lp], last_mi,  1);
	    gtk_widget_draw (sp->im_widget[lp] , NULL);
	}  
  }  else
    meshLineDelete(last_mesh, last_mi,  1);
   
}





gboolean
gdk_mesh_button_press_event  (GtkWidget       *widget,
			      GdkEventButton  *event,
			      gpointer         user_data,
			      MeshT *mesh,
			      int *mi, int *mj, /* the mesh point affected */
			      int *action 
			      /* what was done 0==point moved
				 1.. = see menu of 3rd mouse button
			      */
			      )
{
  //int mi; int mj;  
  int dx; int dy;
  int x; int y;
  long d;


  d=meshPointNearest(mesh , 
			  event->x, event->y, //int px, int py, 
			  mi, mj, 
			  &dx, &dy);
	
  last_mi=*mi; last_mj=*mj;
  last_label=meshGetLabel(mesh, *mi, *mj);
  last_event=*event;
  last_mesh=mesh;

  if(event->button == 1) 
    {
      
      x=event->x; y= event->y;
      x=CLAMP(x,0,meshMaxx(mesh));
      y=CLAMP(y,0,meshMaxy(mesh));

      meshSet(mesh, *mi, *mj, x,y);
      /* if the user simply clicks, we will unselect the point*/
      //FIXME should use MP_SIZE	
      /* if (d < 10 ) { */
      /* 	if(last_label) */
      /* 	  meshSetLabel(mesh, *mi, *mj, 0); */
      /* 	else */
      /* 	  meshSetLabel(mesh, *mi, *mj, -1); */
      /*       } */
      if(last_label==0)
	on_select_point_activate(NULL,NULL);

      *action=0;
      //not here: smooth_mesh(mesh,  settings_get_value("mesh cant overlap"));
      //FIXME 90 is a wild guess
      gtk_widget_update_rect (widget, x, y,90); 
      
      return TRUE;
    }
  else
  if(event->button == 2 ) 
    {
            
     /*  if (event->state & GDK_SHIFT_MASK) */
/* 	{	   */
/* 	  on_add_horizontal_line_activate (NULL,NULL); */
/* 	} */
/*       else if (event->state & GDK_CONTROL_MASK) */
/* 	{ */
/* 	  on_add_vertical_line_activate (NULL,NULL); */
/* 	} */
/*       else g_warning("use shift to add hor lines, ctrl for vertical"); */
/*       *action=last_action; */
      return TRUE;

    }
  else
    if(event->button==3)
      {
	static GtkWidget* m=NULL;
	if(m==NULL)
	    m=create_menuEditMesh();
	    
	gtk_menu_popup (GTK_MENU(m),//GtkMenu *menu,
			NULL,//GtkWidget *parent_menu_shell,
			NULL,//GtkWidget *parent_menu_item,
			NULL,//GtkMenuPositionFunc func,
			    NULL,//gpointer data,
			3,//guint button,
			0);//guint32 activate_time);
	return TRUE;
      }
    else
    {
      *action=-1;
      return FALSE;
    }
}



gboolean
gdk_mesh_motion_notify_event   (GtkWidget       *widget,
				GdkEventMotion  *event,
				gpointer         user_data,
				MeshT *mesh,
				int *mi, int *mj /* the mesh point affected */ 
				)
{
  int x, y;
  GdkModifierType state;
  if (event->is_hint)
    gdk_window_get_pointer (event->window, &x, &y, &state);
  else
    {
      x = event->x;
      y = event->y;
      state = event->state;
    }
  x=CLAMP(x,0,meshMaxx(mesh));
  y=CLAMP(y,0,meshMaxy(mesh));

  if (state & GDK_BUTTON1_MASK)
    {  
      //int mi; int mj;       
#ifndef LOSE_POINTS_WHILE_MOVING
      if(last_mi == -1 )
	{ int dx; int dy;	
	  g_warning("lost point while editing the mesh: WHY?!?");
	  /* I have to track a strange bug : sometimes I lose the point
	   it is as if this signal is executed BEFORE the button press!*/
	  meshPointNearest(mesh , 
			   x, y, //int px, int py, 
			   mi, mj, 
			   &dx, &dy);
	  last_mi=*mi; last_mj=*mj;
	  last_mi=*mi; last_mj=*mj;
	  last_label=meshGetLabel(mesh, *mi, *mj);
	  last_mesh=mesh;
	}
      else
	{      *mi=last_mi; *mj=last_mj; }
#else
      int dx; int dy;
#endif

      meshSet(mesh, *mi, *mj, x, y);
           
      smooth_mesh(mesh,  settings_get_value("mesh cant overlap"));
      
      //FIXME the rectangle size is a wild guess
      gtk_widget_update_rect (widget, x, y, 100);
      return TRUE;           
    } 
  else
    return FALSE;
}




gboolean
gdk_mesh_button_release_event    (GtkWidget       *widget,
				  GdkEventButton  *event,
				  gpointer         user_data,
				  MeshT *mesh,
				  int *mi, int *mj
				  /* the mesh point affected */ 
				  )
{
  
  if(event->button<3)
    smooth_mesh(mesh,  settings_get_value("mesh cant overlap"));

  if(event->button==1) { /* I have to track a strange bug : lets be nasty */
    last_mi=-1;
  }

  gtk_widget_draw (widget , NULL);
  return TRUE;
}




/************************************************************
 * the code following is based on:
 *
 * diw_map.c: Digital Image Warping X graphical user interface
//
// Written and Copyright (C) 1994-1999 by Michael J. Gourlay
//
// PROVIDED AS IS.  NO WARRANTEES, EXPRESS OR IMPLIED.
//
*/







/* Meshpoint picking and drawing parameters */

/* MP_PICK_DIST: farthest you may be from a Mesh point to pick it 
   currently ignored
*/
//#define MP_PICK_DIST 15

#define MP_SIZE 16

#define MP_ARC  (360*64)



#define MY_CALLOC(A,B) (g_malloc0((A)*sizeof(B)))
#define FREE(A) (g_free(A))





/* --------------------------------------------------------------- */

/* NAME
//   gdk_draw_mesh: Draw mesh lines and points for one mesh
//
//
//
//
// DESCRIPTION
//   Draw mesh lines and points.
//   Also draw the selected meshpoint.
//
//  if subimage !=NULL, rescale the mesh to stay in the subimage
//
// SEE ALSO
//   DrawMeshes
*/

typedef struct _GdkArc GdkArc;
struct _GdkArc {
  gint          filled;
  gint          x;
  gint          y;
  gint          width;
  gint          height;
  gint          angle1;
  gint          angle2;
} ;

//widget->style->black_gc

gboolean
gdk_draw_mesh(GdkDrawable  *drawable,
	      GdkGC        *lines_gc, //lines GC
	      GdkGC        *points_gc, //points GC
	      MeshT *mesh,
	      GdkRectangle *subimage,
	      int height, //viewport height
	      int width //viewport width
	      )
{

  

  //extern GC mpl_gc;  /* mesh line graphics context */
  //extern GC mp_gc;   /* mesh point graphics context */
  //extern GdkGC *mps_gc;  /* (selected) mesh point graphics context */

  //Display *display = XtDisplay(widget);
  //Window   window  = XtWindow(widget);


  GdkPoint *xpoints;
  

  //XPoint  *xpoints;
  //XArc    *xarcs;

  int xi, yi;
  const double *xsP = mesh->x;
  const double *ysP = mesh->y;
  //const double *xdP = dmP->mesh_dst.x;
  //const double *ydP = dmP->mesh_dst.y;
  //const double  mpt = dmP->mesh_t;
  double *x_tmp; //= mesh->x;
  double *y_tmp; //= mesh->y;
  double *xrow;
  double *yrow;


  // this is not defined currently in gdk, so we define it above
  GdkArc     xarc;

  /* intelligent point size */
  int point_size= MIN (width / mesh-> nx, height / mesh->ny)/3;

  point_size= CLAMP(point_size, 2,MP_SIZE);

  xarc.width = point_size;
  xarc.height = point_size ;   
  xarc.angle1=0;
  xarc.angle2=MP_ARC;  
 
  if(!(x_tmp=MY_CALLOC(MAX(mesh->nx,mesh->ny)+1, double))) {
    return(FALSE);
  }
  
  if(!(y_tmp=MY_CALLOC(MAX(mesh->nx,mesh->ny)+1, double))) {
    return(FALSE);
  }

  if(!(xrow=MY_CALLOC(MAX(width/4,height/4)+1, double)))
  {
    return(FALSE);
  }

  if(!(yrow=MY_CALLOC(MAX(width/4,height/4)+1, double)))
  {
    return(FALSE);
  }

  if(!(xpoints=MY_CALLOC(MAX(width/4,height/4)+1, GdkPoint)))
  {
    return(FALSE);
  }

  //if(!(xarcs = MY_CALLOC(mesh->ny, GdkArc))) {
  //  return(FALSE);
  //}

  /* Draw meshpoints and vertical meshlines */
  for(xi=0; xi < mesh->nx; xi++) {
    /* Draw vertical mesh lines */
      {
      /* Create 1D array of mesh points knots */
	if(subimage)
	  for(yi=0; yi<mesh->ny; yi++) {
	    x_tmp[yi] = 
	      xsP[yi*mesh->nx + xi] * subimage->width /width + subimage->x;
	    y_tmp[yi] =  
	      ysP[yi*mesh->nx + xi]* subimage->height /height+ subimage->y;
	  }
	else
	  for(yi=0; yi<mesh->ny; yi++) {
	    x_tmp[yi] =      xsP[yi*mesh->nx + xi];
	    y_tmp[yi] =      ysP[yi*mesh->nx + xi];
      }
#ifdef USE_SPLINES
      /* Create abcissas of interpolant to make a smoothly drawn mesh line */
      for(yi=0; yi<(height/4); yi++)
        yrow[yi] = yi*4;

      /* Make sure last abcissa is set */
      yrow[yi-1] = height-1;

      /* Create the interpolated line segments */
      hermite3_array(y_tmp, x_tmp, mesh->ny, yrow, xrow, height/4);

      /* Create an array of XPoints to draw smoothly interpolated mesh line */
      for(yi=0; yi<(height/4); yi++) {
        xpoints[yi].x = (int) xrow[yi];
        xpoints[yi].y = (int) yrow[yi];
      }
      /* Draw the smoothly interpolated mesh line */
      gdk_draw_lines(drawable,lines_gc , xpoints,height/4);
#else USE_SPLINES
      for(yi=0; yi< mesh->ny; yi++) {
        xpoints[yi].x = (int) x_tmp[yi];
        xpoints[yi].y = (int) y_tmp[yi];
      }
      /* Draw the mesh lines */
      gdk_draw_lines(drawable,lines_gc , xpoints, mesh->ny);
#endif
    }

    /* Draw mesh points */
      {
	for(yi=0; yi<mesh->ny; yi++) {
	  xarc.x =  x_tmp[yi]   ;
	  xarc.y =  y_tmp[yi]  ;	
	    
	  if ( meshGetLabel(mesh,xi,yi))
	    gdk_draw_arc  (drawable, points_gc,
			   TRUE,
			   xarc.          x - point_size/2,
			   xarc.          y - point_size/2,
			   xarc.          width,
			   xarc.          height,
			   xarc.          angle1,
			   xarc.          angle2 );
#ifdef DRAW_UNSELECTED_POINTS
	  else
	    gdk_draw_arc  (drawable, lines_gc,
			   TRUE,
			   xarc.          x - point_size/2,
			   xarc.          y - point_size/2,
			   xarc.          width/2,
			   xarc.          height/2,
			   xarc.          angle1,
			   xarc.          angle2 );	
#endif
	}
    }
  }

  /* Draw horizontal meshlines */
  {
    for(yi=0; yi<mesh->ny; yi++) {
      if(subimage)
	for(xi=0; xi<mesh->nx; xi++) {
	  x_tmp[xi] =
	    xsP[yi*mesh->nx + xi]* subimage->width /width + subimage->x;  
	  y_tmp[xi] = 
	    ysP[yi*mesh->nx + xi]* subimage->height /height+ subimage->y;
	}
      else
	for(xi=0; xi<mesh->nx; xi++) {
	  x_tmp[xi] =   xsP[yi*mesh->nx + xi];
	  y_tmp[xi] =   ysP[yi*mesh->nx + xi];
	}

#ifdef USE_SPLINES 
      for(xi=0; xi<(width/4); xi++)
	xrow[xi] = xi*4;
      xrow[xi-1] = width-1;
      
      hermite3_array(x_tmp, y_tmp, mesh->nx, xrow, yrow, width/4);

      for(xi=0; xi<(width/4); xi++) {
        xpoints[xi].x = (int) xrow[xi];
        xpoints[xi].y = (int) yrow[xi];
      }
      gdk_draw_lines (drawable, lines_gc,
		      xpoints, width/4); 
#else
      for(xi=0; xi<mesh->nx; xi++) {
        xpoints[xi].x = (int) x_tmp[xi];
        xpoints[xi].y = (int) y_tmp[xi];
      }
      gdk_draw_lines (drawable, lines_gc,
		      xpoints, mesh->nx);      
#endif
    }
  }

/*     for(yi=0; yi<mesh->ny; yi++) { */
/*       for(xi=0; xi<mesh->nx; xi++) { */
/*       }} */

  //FREE(x_tmp);
  //FREE(y_tmp);
  g_free(xrow);
  g_free(yrow);
  g_free(xpoints);

  return(TRUE);
}


