#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>


/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif


#include "gtktopdata.h"
#include "gtksettings.h"

static void call_callback(GtkMenuItem     *menuitem)
{
  void (*callback)(GtkWidget* thismenuitem, gpointer userdata);
  gpointer   *settings =
    gtk_widget_get_data_top(GTK_WIDGET(menuitem),"settings");
  gpointer   *userdata =
    gtk_widget_get_data_top(GTK_WIDGET(menuitem),"userdata");
  g_assert(settings);
  callback =gtk_widget_get_data_top(GTK_WIDGET(menuitem),"callback");
  g_assert(callback==settings[0]);
  g_assert(userdata==settings[1]);
  if(callback)
    (*callback)(menuitem, settings[1]);
}

static
void
on_setting_activate    (GtkMenuItem     *menuitem,
			gpointer         thisitemsetting)
{  

  //#ifdef VERBOSE     
  g_message(" activate '%s' from %d to %d\n",
	    *(char **)thisitemsetting,
	    GPOINTER_TO_INT( *((gpointer *)thisitemsetting+1) ),
	    GTK_CHECK_MENU_ITEM(menuitem)->active);
  //#endif

  *((gpointer *)thisitemsetting+1 )=
    GINT_TO_POINTER(GTK_CHECK_MENU_ITEM(menuitem)->active);
  /* now we dont deal with accels */
  g_assert(  *((gpointer *)thisitemsetting+2)==NULL );
  call_callback(menuitem);
}

/* actually this is never called ... */
static
void
on_setting_toggle    (GtkMenuItem     *menuitem,
			gpointer         thisitemsetting)
{ 
  g_message(" toggle '%s' from %d to %d\n",
	    *(char **)thisitemsetting,
	    GPOINTER_TO_INT(*((gpointer *)
			      thisitemsetting+1 )),
	    GTK_CHECK_MENU_ITEM(menuitem)->active);
	 
  *( ((gpointer *)thisitemsetting) +1)=
    GINT_TO_POINTER(GTK_CHECK_MENU_ITEM(menuitem)->active);

  call_callback(menuitem);
}




//static inline
int
gtk_settings_get_value(char *name,gpointer thesettings[])
{
  int lp=GTKSETTINGS_TEMPLATE_HEADERSIZE;
  while( thesettings[lp]) { 
    if(strcmp(name,thesettings[lp])==0)
      return GPOINTER_TO_INT(thesettings[lp+1]);
    lp+=GTKSETTINGS_BLOCKS_SIZE;
  }
  g_warning("gtk_settings_get_value: setting '%s' not found", name);

  return 0;
}

//static inline
int
gtk_settings_set_value(char *name,gpointer thesettings[], int value)
{
  int lp=GTKSETTINGS_TEMPLATE_HEADERSIZE;
  while( thesettings[lp]) { 
    if(strcmp(name,thesettings[lp])==0)
      {
	GtkWidget  *item = thesettings[lp+4];
	thesettings[lp+1] = GINT_TO_POINTER(value);
	if(!GTK_WIDGET_REALIZED(item))
	  g_warning(" item %s is not realized, while initializing to %d\n",
		     (char *)(thesettings[lp]),value);
	//else
	// gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item) ,
	//			 (value)?TRUE:FALSE);


	return 0;
      }
    lp+=GTKSETTINGS_BLOCKS_SIZE;
  }
  g_warning("gtk_settings_set_value: setting '%s' not found", name);

  return !0;
}




int
gtk_settings_template_size(/* template for the settings */
		   gpointer template[])
{
  /*find size */
  int lp=0;
  while(template[lp]) { 
    lp+=GTKSETTINGS_BLOCKS_SIZE;
  }  
  /* includes the final NULL */
  return lp+1;
}

gpointer
gtk_settings_alloc(/* template for the settings */
		   gpointer template[])
{
  int lp, size;
  /*find size */
  lp=gtk_settings_template_size(template); 
  /* includes   the header*/
  size=lp+GTKSETTINGS_TEMPLATE_HEADERSIZE;
  return g_malloc(size * sizeof(gpointer));
}

GtkWidget*
gtk_settings_create(gpointer template[],
		    gpointer *thesettings,
		    void (*callback)(),
		    gpointer userdata)
{
  GtkWidget *menuSettings;
  GtkAccelGroup *menuSettings_accels;
  GtkWidget *item;
  GtkTooltips *tooltips;
  int lp, size;

  g_assert(thesettings);

  /*find size */
  size= gtk_settings_template_size(template); 

  /* copy template */
  memcpy(thesettings+GTKSETTINGS_TEMPLATE_HEADERSIZE,template,
	 size*sizeof(gpointer) );
  /*translate*/
  lp=0;
  while(template[lp]) { 
    /* menu item */
    thesettings[lp+GTKSETTINGS_TEMPLATE_HEADERSIZE]= _(template[lp]);
    /* tooltip */
    thesettings[lp+3+GTKSETTINGS_TEMPLATE_HEADERSIZE]= _(template[lp+3]);
    lp+=GTKSETTINGS_BLOCKS_SIZE;
  } 

  menuSettings = gtk_menu_new ();

  {
    //void (*callback)(GtkWidget* thismenu, gpointer userdata);
    //callback = thesettings[0];
    //g_assert(callback == callbac);
    thesettings[0]=callback;
    thesettings[1]=userdata;
    gtk_widget_set_data_top(menuSettings,"callback", callback);
    gtk_widget_set_data_top(menuSettings,"userdata", userdata);
    gtk_widget_set_data_top(menuSettings,"settings", thesettings);
  }

  tooltips = gtk_tooltips_new ();

  gtk_widget_set_name (menuSettings, "menuSettings");
  gtk_object_set_data (GTK_OBJECT (menuSettings),"menuSettings", menuSettings);
  menuSettings_accels = gtk_menu_ensure_uline_accel_group 
    (GTK_MENU (menuSettings));
  
  lp=GTKSETTINGS_TEMPLATE_HEADERSIZE;
  while(thesettings[lp]) {
    thesettings[lp+4]= item =
      gtk_check_menu_item_new_with_label (thesettings[lp]);
    
    gtk_widget_set_name (item,thesettings[lp]);
    gtk_widget_ref (item );
    //gtk_object_set_data_full (GTK_OBJECT (menuSettings),
    //			      "warped image in other win1" , 
    //			      item,
    //			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (menuSettings), item);
    gtk_tooltips_set_tip (tooltips, item, thesettings[lp+3], NULL);
    if(thesettings[lp+1])
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item), TRUE);
    
    gtk_signal_connect (GTK_OBJECT (item), "activate",
    			GTK_SIGNAL_FUNC (on_setting_activate ),
    			thesettings+lp);
    gtk_signal_connect (GTK_OBJECT (item), "toggle",
    			GTK_SIGNAL_FUNC (on_setting_toggle ),
    			thesettings+lp);

    gtk_object_set_data (GTK_OBJECT (menuSettings), "tooltips", tooltips);
    
    lp+=GTKSETTINGS_BLOCKS_SIZE;
  }
  
  return menuSettings;
}
