
/***********************
 *
this file may be engineered to become a piece of a new library called
called gtk-extra

but I am too lazy to
 *
 ****************/

#include "gtk/gtk.h"

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#include "gtk_subimagesel.h"
#include "callbacks.h"
#include "support.h"
#include "utils.h"
#include "main.h"

/* updates a rectangle of the window on the screen  */

void gtk_subimasel_reset(gtk_subimage_sel_t * sis)
{
    
  sis->eyes[0][0]=0.4;
  sis->eyes[0][1]=0.5;
  sis->eyes[1][0]=0.6;
  sis->eyes[1][1]=0.5;
  sis->eyes[2][0]=0.5;
  sis->eyes[2][1]=0.75;

}

void
update_eyes( gtk_subimage_sel_t * sis, int x,int y)
{
  double w=sp->resulting_width, h=sp->resulting_height;
  if(y<h*7/10) {
    if(x<w/2) {
      sis->eyes[0][0]=(double)x/w;
      sis->eyes[0][1]=(double)y/h;
    } else { 
      sis->eyes[1][0]=(double)x/w;
      sis->eyes[1][1]=(double)y/h;
    }}
  else {
    sis->eyes[2][0]=(double)x/w;
    sis->eyes[2][1]=(double)y/h;
  }
}

gboolean
gdk_subimagesel_button_press_event (GtkWidget       *widget,
				 GdkEventButton  *event,
				 gpointer         user_data)
{
  gtk_subimage_sel_t * sis=
    (gtk_widget_get_data_top(widget,"gtk_subimagesel")); 
  g_assert(sis);
  if(event->button == 1) {
    update_eyes(sis,event->x,event->y);
    gtk_widget_draw(widget,NULL);
    return TRUE;
  } else 
    return FALSE;
}

gboolean
gdk_subimagesel_motion_notify_event (GtkWidget       *widget,
				     GdkEventMotion  *event,
				     gpointer         user_data)
{
  gtk_subimage_sel_t * sis=
    (gtk_widget_get_data_top(widget,"gtk_subimagesel")); 
  int x,y;
  GdkModifierType state;
 
  g_assert(sis);

  if (event->is_hint)
    gdk_window_get_pointer (event->window, &x, &y, &state);
  else
    {
      x = event->x;
      y = event->y;
      state = event->state;
    }

  if(state & GDK_BUTTON1_MASK) {
    update_eyes(sis,x,y);
    gtk_widget_draw(widget,NULL);
    return TRUE;
  } else 
    return FALSE;
}


void
on_eyessubimage_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 
  gtk_subimage_sel_t *sis= &(sp->subimasel[i]);

  show_warning( (_("sorry this functions is as yet unimplemented")));
  return;

  g_assert(i>0);
 if( sp->im_editshow[i]!=EDITSHOW_EYES)
   {show_warning("\
first you have to put the white points on the eyes and mouth"); 
      set_editshow(i, EDITSHOW_EYES);
      return ;
    }

 {
   double sw= sis->eyes[1][0] -sis->eyes[0][0],
     //sm=(sis->eyes[1][0] +sis->eyes[0][0])/2,
     dw= sis->eyes[1][0] -sis->eyes[0][0]
     //dm=( sis->eyes[1][0] +sis->eyes[0][0])/2
     ;
     
     sis->subimage.width = sp->resulting_width *sw /dw;
     sis->subimage.height = sp->resulting_height *sw /dw;

     //sp-> im_width[i]/2 / dm
 }
 gtk_widget_draw(lookup_widget(GTK_WIDGET(button),"handleboxsubimage"),NULL);
}


gboolean
gdk_subimagesel_draw(GdkDrawable  *drawable,
		     gtk_subimage_sel_t * sis,
		     GdkGC *mpl_gc)
{
  int l,x,y, MP_SIZE=10,MP_ARC=360 * 64; 
  
  for(l=0;l<3;l++) {
    x=sis->eyes[l][0]*sp->resulting_height;
    y=sis->eyes[l][1]*sp->resulting_width;
    gdk_draw_arc  (drawable, mpl_gc,
		   TRUE,
		   x - MP_SIZE/2,  y - MP_SIZE/2, MP_SIZE,MP_SIZE,0,MP_ARC);
  }
  return TRUE;
}





/********************************************************************
 *
 * input image window, subimage handlebox
 *
 ******************************************************************
**/

void
on_subimage_apply_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum"));
  if ( sp-> im_filename[i] == NULL
       || strlen( sp-> im_filename[i]) == 0) {

    show_warning( _("\
you must load an image before you may choose a subimage") );    
  } else {
    drawingarea_configure  ( i);
  }
}




void
on_handleboxsubimage_show              (GtkWidget       *widget,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 

  g_assert(i > 0);
  //FIXME this doesnt work so we use a different window in glade
  if ( i == MAX_WINS+1)
    gtk_widget_hide(widget);
}



void
on_spinbuttonx_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{

  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(editable),
					     "imagenum")); 
  g_assert(i>0);
  sp->subimasel[i].subimage.x=
    gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON(editable))
    -sp->subimasel[i].subimage.width/2;

#ifndef DONT_CLAMP_SUBIMAGE
  sp->subimasel[i].subimage.x = CLAMP( sp->subimasel[i].subimage.x,
			     0, sp-> im_width[i] -sp->subimasel[i].subimage.width );
#endif
}


void
on_spinbuttony_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
   int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(editable),
					     "imagenum")); 
  g_assert(i>0);
  sp->subimasel[i].subimage.y=
    gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON(editable))
    -  sp->subimasel[i].subimage.height/2; 
#ifndef DONT_CLAMP_SUBIMAGE
  sp->subimasel[i].subimage.y = CLAMP( sp->subimasel[i].subimage.y,
			     0, sp-> im_height[i] -sp->subimasel[i].subimage.height );
#endif
}


void
on_spinbuttonw_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(editable),
					     "imagenum")); 
  g_assert(i>0);
  sp->subimasel[i].subimage.width=
    gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON(editable));
#ifndef DONT_CLAMP_SUBIMAGE
  sp->subimasel[i].subimage.width = CLAMP( sp->subimasel[i].subimage.width,
				 8, sp-> im_width[i] -sp->subimasel[i].subimage.x );
#endif
}


void
on_spinbuttonh_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
    int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(editable),
					     "imagenum")); 
    g_assert(i>0);
  sp->subimasel[i].subimage.height=
    gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON(editable));
#ifndef DONT_CLAMP_SUBIMAGE
  sp->subimasel[i].subimage.height = CLAMP( sp->subimasel[i].subimage.height,
				  8, sp-> im_height[i] -sp->subimasel[i].subimage.y );
#endif
}




void
on_spinbuttonx_draw                    (GtkWidget       *widget,
                                        GdkRectangle    *area,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,
					     "imagenum")); 
  g_assert(i>0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(widget),
			     sp->subimasel[i].subimage.x+sp->subimasel[i].subimage.width/2);
}


void
on_spinbuttony_draw                    (GtkWidget       *widget,
                                        GdkRectangle    *area,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,
					     "imagenum")); 
  g_assert(i>0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(widget),
			     sp->subimasel[i].subimage.y+sp->subimasel[i].subimage.height/2);
}


void
on_spinbuttonw_draw                    (GtkWidget       *widget,
                                        GdkRectangle    *area,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,
					     "imagenum")); 
  g_assert(i>0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(widget),
			     sp->subimasel[i].subimage.width);
}


void
on_spinbuttonh_draw                    (GtkWidget       *widget,
                                        GdkRectangle    *area,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,
					     "imagenum")); 
  g_assert(i>0);  
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(widget),
			     sp->subimasel[i].subimage.height);
  //gtk_spin_button_set_adjustment  (GtkSpinButton *spin_button,
  //                                           GtkAdjustment *adjustment);
}

