/* icon-button.c generated by valac, the Vala compiler
 * generated from icon-button.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define XNP_TYPE_ICON_BUTTON (xnp_icon_button_get_type ())
#define XNP_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_ICON_BUTTON, XnpIconButton))
#define XNP_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_ICON_BUTTON, XnpIconButtonClass))
#define XNP_IS_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_ICON_BUTTON))
#define XNP_IS_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_ICON_BUTTON))
#define XNP_ICON_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_ICON_BUTTON, XnpIconButtonClass))

typedef struct _XnpIconButton XnpIconButton;
typedef struct _XnpIconButtonClass XnpIconButtonClass;
typedef struct _XnpIconButtonPrivate XnpIconButtonPrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define XNP_TYPE_TITLE_BAR_BUTTON_TYPE (xnp_title_bar_button_type_get_type ())

#define XNP_TYPE_TITLE_BAR_BUTTON (xnp_title_bar_button_get_type ())
#define XNP_TITLE_BAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButton))
#define XNP_TITLE_BAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButtonClass))
#define XNP_IS_TITLE_BAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_TITLE_BAR_BUTTON))
#define XNP_IS_TITLE_BAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_TITLE_BAR_BUTTON))
#define XNP_TITLE_BAR_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButtonClass))

typedef struct _XnpTitleBarButton XnpTitleBarButton;
typedef struct _XnpTitleBarButtonClass XnpTitleBarButtonClass;
typedef struct _XnpTitleBarButtonPrivate XnpTitleBarButtonPrivate;

struct _XnpIconButton {
	GtkEventBox parent_instance;
	XnpIconButtonPrivate * priv;
	gboolean active;
};

struct _XnpIconButtonClass {
	GtkEventBoxClass parent_class;
	void (*draw_icon) (XnpIconButton* self, cairo_t* cr, gint width, gint height);
};

typedef enum  {
	XNP_TITLE_BAR_BUTTON_TYPE_EMPTY,
	XNP_TITLE_BAR_BUTTON_TYPE_CLOSE
} XnpTitleBarButtonType;

struct _XnpTitleBarButton {
	XnpIconButton parent_instance;
	XnpTitleBarButtonPrivate * priv;
};

struct _XnpTitleBarButtonClass {
	XnpIconButtonClass parent_class;
};

struct _XnpTitleBarButtonPrivate {
	XnpTitleBarButtonType _icon_type;
};


static gpointer xnp_icon_button_parent_class = NULL;
static gpointer xnp_title_bar_button_parent_class = NULL;

GType xnp_icon_button_get_type (void);
enum  {
	XNP_ICON_BUTTON_DUMMY_PROPERTY
};
void xnp_icon_button_draw_icon (XnpIconButton* self, cairo_t* cr, gint width, gint height);
static void xnp_icon_button_real_draw_icon (XnpIconButton* self, cairo_t* cr, gint width, gint height);
static void xnp_icon_button_real_add (GtkContainer* base, GtkWidget* widget);
static gboolean xnp_icon_button_real_expose_event (GtkWidget* base, GdkEventExpose* event);
static gboolean xnp_icon_button_on_enter_notify_event (XnpIconButton* self, GdkEventCrossing* event);
static gboolean xnp_icon_button_on_leave_notify_event (XnpIconButton* self, GdkEventCrossing* event);
static gboolean xnp_icon_button_on_button_release_event (XnpIconButton* self, GdkEventButton* event);
XnpIconButton* xnp_icon_button_construct (GType object_type);
static gboolean _xnp_icon_button_on_enter_notify_event_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _xnp_icon_button_on_leave_notify_event_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _xnp_icon_button_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static GObject * xnp_icon_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void xnp_icon_button_finalize (GObject* obj);
GType xnp_title_bar_button_type_get_type (void);
GType xnp_title_bar_button_get_type (void);
#define XNP_TITLE_BAR_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButtonPrivate))
enum  {
	XNP_TITLE_BAR_BUTTON_DUMMY_PROPERTY,
	XNP_TITLE_BAR_BUTTON_ICON_TYPE
};
XnpTitleBarButton* xnp_title_bar_button_new (XnpTitleBarButtonType icon_type);
XnpTitleBarButton* xnp_title_bar_button_construct (GType object_type, XnpTitleBarButtonType icon_type);
XnpTitleBarButtonType xnp_title_bar_button_get_icon_type (XnpTitleBarButton* self);
static void xnp_title_bar_button_draw_close_button (XnpTitleBarButton* self, cairo_t* cr, gint width, gint height);
static void xnp_title_bar_button_real_draw_icon (XnpIconButton* base, cairo_t* cr, gint width, gint height);
void xnp_title_bar_button_set_icon_type (XnpTitleBarButton* self, XnpTitleBarButtonType value);
static void xnp_title_bar_button_finalize (GObject* obj);
static void xnp_title_bar_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void xnp_title_bar_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static void xnp_icon_button_real_draw_icon (XnpIconButton* self, cairo_t* cr, gint width, gint height) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `xnp_icon_button_draw_icon'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void xnp_icon_button_draw_icon (XnpIconButton* self, cairo_t* cr, gint width, gint height) {
	XNP_ICON_BUTTON_GET_CLASS (self)->draw_icon (self, cr, width, height);
}


static void xnp_icon_button_real_add (GtkContainer* base, GtkWidget* widget) {
	XnpIconButton * self;
	self = (XnpIconButton*) base;
	g_return_if_fail (widget != NULL);
	g_warning ("icon-button.vala:42: This object doesn't allow packing child widgets.");
}


static gboolean xnp_icon_button_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	XnpIconButton * self;
	gboolean result;
	gint width;
	gint height;
	gint x;
	gint y;
	cairo_t* cr;
	cairo_surface_t* surface;
	cairo_t* cr_;
	self = (XnpIconButton*) base;
	width = ((GtkWidget*) self)->allocation.width - (((gint) gtk_container_get_border_width ((GtkContainer*) self)) * 2);
	height = ((GtkWidget*) self)->allocation.height - (((gint) gtk_container_get_border_width ((GtkContainer*) self)) * 2);
	x = ((((GtkWidget*) self)->allocation.width / 2) - (width / 2)) + ((GtkWidget*) self)->allocation.x;
	y = ((((GtkWidget*) self)->allocation.height / 2) - (height / 2)) + ((GtkWidget*) self)->allocation.y;
	cr = gdk_cairo_create ((GdkDrawable*) ((GtkWidget*) self)->window);
	cairo_rectangle (cr, (double) x, (double) y, (double) width, (double) height);
	cairo_clip (cr);
	surface = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);
	cr_ = cairo_create (surface);
	xnp_icon_button_draw_icon (self, cr_, width, height);
	cairo_set_source_surface (cr, surface, (double) x, (double) y);
	cairo_paint (cr);
	result = FALSE;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (surface);
	_cairo_destroy0 (cr_);
	return result;
}


static gboolean xnp_icon_button_on_enter_notify_event (XnpIconButton* self, GdkEventCrossing* event) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->active = TRUE;
	gdk_window_invalidate_rect (((GtkWidget*) self)->window, NULL, FALSE);
	result = FALSE;
	return result;
}


static gboolean xnp_icon_button_on_leave_notify_event (XnpIconButton* self, GdkEventCrossing* event) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->active = FALSE;
	gdk_window_invalidate_rect (((GtkWidget*) self)->window, NULL, FALSE);
	result = FALSE;
	return result;
}


static gboolean xnp_icon_button_on_button_release_event (XnpIconButton* self, GdkEventButton* event) {
	gboolean result;
	gint cur_x;
	gint cur_y;
	gint width = 0;
	gint height = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).button != 1) {
		result = FALSE;
		return result;
	}
	cur_x = (gint) (*event).x;
	cur_y = (gint) (*event).y;
	gtk_widget_get_size_request ((GtkWidget*) self, &width, &height);
	if (cur_x >= 0) {
		_tmp2_ = cur_x < width;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = cur_y >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = cur_y < height;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit_by_name (self, "clicked");
	}
	result = FALSE;
	return result;
}


XnpIconButton* xnp_icon_button_construct (GType object_type) {
	XnpIconButton * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


static gboolean _xnp_icon_button_on_enter_notify_event_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	return xnp_icon_button_on_enter_notify_event (self, event);
}


static gboolean _xnp_icon_button_on_leave_notify_event_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	return xnp_icon_button_on_leave_notify_event (self, event);
}


static gboolean _xnp_icon_button_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	return xnp_icon_button_on_button_release_event (self, event);
}


static GObject * xnp_icon_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XnpIconButton * self;
	parent_class = G_OBJECT_CLASS (xnp_icon_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = XNP_ICON_BUTTON (obj);
	{
		gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
		gtk_event_box_set_above_child ((GtkEventBox*) self, TRUE);
		gtk_widget_set_size_request ((GtkWidget*) self, 22, 22);
		gtk_container_set_border_width ((GtkContainer*) self, (guint) 2);
		g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) _xnp_icon_button_on_enter_notify_event_gtk_widget_enter_notify_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _xnp_icon_button_on_leave_notify_event_gtk_widget_leave_notify_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _xnp_icon_button_on_button_release_event_gtk_widget_button_release_event, self, 0);
	}
	return obj;
}


static void xnp_icon_button_class_init (XnpIconButtonClass * klass) {
	xnp_icon_button_parent_class = g_type_class_peek_parent (klass);
	XNP_ICON_BUTTON_CLASS (klass)->draw_icon = xnp_icon_button_real_draw_icon;
	GTK_CONTAINER_CLASS (klass)->add = xnp_icon_button_real_add;
	GTK_WIDGET_CLASS (klass)->expose_event = xnp_icon_button_real_expose_event;
	G_OBJECT_CLASS (klass)->constructor = xnp_icon_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_icon_button_finalize;
	g_signal_new ("clicked", XNP_TYPE_ICON_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void xnp_icon_button_instance_init (XnpIconButton * self) {
	self->active = FALSE;
}


static void xnp_icon_button_finalize (GObject* obj) {
	XnpIconButton * self;
	self = XNP_ICON_BUTTON (obj);
	G_OBJECT_CLASS (xnp_icon_button_parent_class)->finalize (obj);
}


GType xnp_icon_button_get_type (void) {
	static GType xnp_icon_button_type_id = 0;
	if (xnp_icon_button_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (XnpIconButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_icon_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpIconButton), 0, (GInstanceInitFunc) xnp_icon_button_instance_init, NULL };
		xnp_icon_button_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "XnpIconButton", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return xnp_icon_button_type_id;
}



GType xnp_title_bar_button_type_get_type (void) {
	static GType xnp_title_bar_button_type_type_id = 0;
	if (G_UNLIKELY (xnp_title_bar_button_type_type_id == 0)) {
		static const GEnumValue values[] = {{XNP_TITLE_BAR_BUTTON_TYPE_EMPTY, "XNP_TITLE_BAR_BUTTON_TYPE_EMPTY", "empty"}, {XNP_TITLE_BAR_BUTTON_TYPE_CLOSE, "XNP_TITLE_BAR_BUTTON_TYPE_CLOSE", "close"}, {0, NULL, NULL}};
		xnp_title_bar_button_type_type_id = g_enum_register_static ("XnpTitleBarButtonType", values);
	}
	return xnp_title_bar_button_type_type_id;
}


XnpTitleBarButton* xnp_title_bar_button_construct (GType object_type, XnpTitleBarButtonType icon_type) {
	XnpTitleBarButton * self;
	self = (XnpTitleBarButton*) g_object_new (object_type, "icon-type", icon_type, NULL);
	return self;
}


XnpTitleBarButton* xnp_title_bar_button_new (XnpTitleBarButtonType icon_type) {
	return xnp_title_bar_button_construct (XNP_TYPE_TITLE_BAR_BUTTON, icon_type);
}


static void xnp_title_bar_button_real_draw_icon (XnpIconButton* base, cairo_t* cr, gint width, gint height) {
	XnpTitleBarButton * self;
	self = (XnpTitleBarButton*) base;
	g_return_if_fail (cr != NULL);
	switch (self->priv->_icon_type) {
		case XNP_TITLE_BAR_BUTTON_TYPE_CLOSE:
		{
			xnp_title_bar_button_draw_close_button (self, cr, width, height);
			break;
		}
		default:
		{
			break;
		}
	}
}


static void xnp_title_bar_button_draw_close_button (XnpTitleBarButton* self, cairo_t* cr, gint width, gint height) {
	gint border;
	gint x1;
	gint x2;
	gint y1;
	gint y2;
	gboolean _tmp0_ = FALSE;
	double _tmp1_ = 0.0;
	GdkColor _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	border = 4;
	x1 = border;
	x2 = width - border;
	y1 = border;
	y2 = height - border;
	if (x2 <= x1) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = y2 <= y1;
	}
	if (_tmp0_) {
		return;
	}
	cairo_set_line_cap (cr, CAIRO_LINE_CAP_ROUND);
	if (((XnpIconButton*) self)->active) {
		_tmp1_ = 0.4;
	} else {
		_tmp1_ = 0.2;
	}
	cairo_set_source_rgba (cr, (double) 1, (double) 1, (double) 1, _tmp1_);
	cairo_set_line_width (cr, (double) 4);
	cairo_move_to (cr, (double) x1, (double) y1);
	cairo_line_to (cr, (double) x2, (double) y2);
	cairo_move_to (cr, (double) x2, (double) y1);
	cairo_line_to (cr, (double) x1, (double) y2);
	cairo_stroke (cr);
	if (((XnpIconButton*) self)->active) {
		_tmp2_ = gtk_widget_get_style ((GtkWidget*) self)->base[GTK_STATE_NORMAL];
	} else {
		_tmp2_ = gtk_widget_get_style ((GtkWidget*) self)->fg[GTK_STATE_INSENSITIVE];
	}
	gdk_cairo_set_source_color (cr, &_tmp2_);
	cairo_set_line_width (cr, 2.66);
	cairo_move_to (cr, (double) x1, (double) y1);
	cairo_line_to (cr, (double) x2, (double) y2);
	cairo_move_to (cr, (double) x2, (double) y1);
	cairo_line_to (cr, (double) x1, (double) y2);
	cairo_stroke (cr);
}


XnpTitleBarButtonType xnp_title_bar_button_get_icon_type (XnpTitleBarButton* self) {
	XnpTitleBarButtonType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_icon_type;
	return result;
}


void xnp_title_bar_button_set_icon_type (XnpTitleBarButton* self, XnpTitleBarButtonType value) {
	g_return_if_fail (self != NULL);
	self->priv->_icon_type = value;
	g_object_notify ((GObject *) self, "icon-type");
}


static void xnp_title_bar_button_class_init (XnpTitleBarButtonClass * klass) {
	xnp_title_bar_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XnpTitleBarButtonPrivate));
	XNP_ICON_BUTTON_CLASS (klass)->draw_icon = xnp_title_bar_button_real_draw_icon;
	G_OBJECT_CLASS (klass)->get_property = xnp_title_bar_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = xnp_title_bar_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = xnp_title_bar_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_TITLE_BAR_BUTTON_ICON_TYPE, g_param_spec_enum ("icon-type", "icon-type", "icon-type", XNP_TYPE_TITLE_BAR_BUTTON_TYPE, XNP_TITLE_BAR_BUTTON_TYPE_EMPTY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void xnp_title_bar_button_instance_init (XnpTitleBarButton * self) {
	self->priv = XNP_TITLE_BAR_BUTTON_GET_PRIVATE (self);
	self->priv->_icon_type = XNP_TITLE_BAR_BUTTON_TYPE_EMPTY;
}


static void xnp_title_bar_button_finalize (GObject* obj) {
	XnpTitleBarButton * self;
	self = XNP_TITLE_BAR_BUTTON (obj);
	G_OBJECT_CLASS (xnp_title_bar_button_parent_class)->finalize (obj);
}


GType xnp_title_bar_button_get_type (void) {
	static GType xnp_title_bar_button_type_id = 0;
	if (xnp_title_bar_button_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (XnpTitleBarButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_title_bar_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpTitleBarButton), 0, (GInstanceInitFunc) xnp_title_bar_button_instance_init, NULL };
		xnp_title_bar_button_type_id = g_type_register_static (XNP_TYPE_ICON_BUTTON, "XnpTitleBarButton", &g_define_type_info, 0);
	}
	return xnp_title_bar_button_type_id;
}


static void xnp_title_bar_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	XnpTitleBarButton * self;
	self = XNP_TITLE_BAR_BUTTON (object);
	switch (property_id) {
		case XNP_TITLE_BAR_BUTTON_ICON_TYPE:
		g_value_set_enum (value, xnp_title_bar_button_get_icon_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void xnp_title_bar_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	XnpTitleBarButton * self;
	self = XNP_TITLE_BAR_BUTTON (object);
	switch (property_id) {
		case XNP_TITLE_BAR_BUTTON_ICON_TYPE:
		xnp_title_bar_button_set_icon_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




