/*  
 *  xcall - Packet radio program for GTK+
 *  Copyright (C) 2001 Joop Stakenborg <pa4tu@amsat.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* main.c: start of the gtk loop */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include "interface.h"
#include "support.h"
#include "packet.h"
#include "utils.h"
#include "init.h"
#include "history.h"
#include "types.h"

GtkWidget *window1;
extern preferencestype preferences;

int main (int argc, char *argv[]) {
  gchar *lang, *rcpath;
  gint x, y, width, heigth;

  bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain(PACKAGE);
  lang = gtk_set_locale(); /* don't free lang! */

  gtk_init(&argc, &argv);

  add_pixmap_directory(PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory(PACKAGE_SOURCE_DIR "/pixmaps");

  dircheck();
  loadpreferences();
  loadhistory();

  rcpath = g_strdup_printf("%s/.%s/%src", g_get_home_dir(), PACKAGE, PACKAGE);
  gtk_rc_parse(rcpath);
  g_free(rcpath);

  window1 = create_window1();
  set_title(window1, PACKAGE);

  /* realize the wiindow before showing it, so we can set size and position */
  gtk_widget_realize(window1);

  /* get current window size */
  gdk_window_get_size(window1->window, &width, &heigth);
  gdk_window_get_root_origin(window1->window, &x, &y);

  /* position the main window */
  if (preferences.size && !preferences.origin) 
    gdk_window_move_resize(window1->window, x, y, preferences.width, preferences.height);
  else if (preferences.origin && preferences.size) 
    gdk_window_move_resize(window1->window, preferences.x, preferences.y, preferences.width, preferences.height);
  else if (!preferences.size && preferences.origin) 
    gdk_window_move_resize(window1->window, preferences.x, preferences.y, width, heigth);

  gtk_widget_show(window1);

  gtk_main();

  return 0;
}
