/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Loader;
import com.icl.saxon.Mode;
import com.icl.saxon.RuleManager;
import com.icl.saxon.handlers.NodeHandler;
import com.icl.saxon.style.XSLTemplate;
import org.xml.sax.SAXException;

public class SAXONHandler
extends XSLTemplate {
    private NodeHandler handler;

    public void prepareAttributes() throws SAXException {
        String string = this.getAttributeValue("handler");
        if (string == null) {
            this.reportAbsence("handler");
        } else {
            this.handler = SAXONHandler.makeHandler(string);
        }
        super.prepareAttributes();
    }

    protected void checkAllowedAttributes() throws SAXException {
        String[] stringArray = new String[]{"name", "mode", "match", "priority", "handler"};
        this.allowAttributes(stringArray);
    }

    public void validate() throws SAXException {
        this.checkTopLevel();
    }

    public void preprocess() throws SAXException {
        RuleManager ruleManager = this.getPrincipalStyleSheet().getRuleManager();
        Mode mode = ruleManager.getMode(this.modeName);
        if (this.match != null) {
            if (this.prioritySpecified) {
                ruleManager.setHandler(this.match, this.handler, mode, this.getPrecedence(), this.priority);
            } else {
                ruleManager.setHandler(this.match, this.handler, mode, this.getPrecedence());
            }
        }
    }

    public void process(Context context) throws SAXException {
    }

    public void expand(Context context) throws SAXException {
        this.handler.start(context.getCurrentNode(), context);
    }

    protected static NodeHandler makeHandler(String string) throws SAXException {
        try {
            return (NodeHandler)Loader.getInstance(string);
        }
        catch (ClassCastException classCastException) {
            throw new SAXException("Failed to load node handler " + string + ": it does not implement the NodeHandler interface");
        }
    }
}

