/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import java.util.Vector;
import org.xml.sax.SAXException;

public class StringLength
extends Function {
    public String getName() {
        return "string-length";
    }

    public int getDataType() {
        return 2;
    }

    public int getIntrinsicDependencies() {
        int n = this.arguments.size();
        return n == 0 ? 8 : 0;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        String string;
        int n = this.checkArgumentCount(0, 1);
        if (vector.size() == 0) {
            string = context.getContextNode().getValue();
        } else {
            Value value = (Value)vector.elementAt(0);
            string = value.asString();
        }
        return new NumericValue(StringValue.getLength(string));
    }

    public Expression simplify() throws SAXException {
        int n = this.checkArgumentCount(0, 1);
        if (n == 1) {
            return this.simplifyPureFunction();
        }
        return super.simplify();
    }
}

