/*
 *   Copyright (C) 2003,2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "NoisyNCO.h"

#include <cmath>
using namespace std;

#include <wx/log.h>
#include <wx/debug.h>

CNoisyNCO::CNoisyNCO(int rate, double stdDev, double volume) :
m_rate(rate),
m_stdDev(stdDev),
m_volume(volume),
m_dds(0.0),
m_gaussian()
{
	wxASSERT(m_rate > 0);
	wxASSERT(m_volume >= -1.0 && volume <= 1.0);
}

CNoisyNCO::~CNoisyNCO()
{
}

void CNoisyNCO::generate(double frequency, double* output, int length)
{
	wxASSERT(output != NULL);
	wxASSERT(length > 0);

	double ddsInc = (::fabs(frequency) * 2.0 * M_PI) / double(m_rate);

	for (int i = 0; i < length; i++) {
		output[i] = ::sin(m_dds + m_gaussian.rand(0.0, m_stdDev)) * m_volume;

		m_dds += ddsInc;
	}
}

void CNoisyNCO::generate(double frequency, complex<double>* output, int length)
{
	wxASSERT(output != NULL);
	wxASSERT(length > 0);

	double ddsInc = (::fabs(frequency) * 2.0 * M_PI) / double(m_rate);

	for (int i = 0; i < length; i++) {
		double theta = m_gaussian.rand(0.0, m_stdDev);

		double cosVal = ::cos(m_dds + theta) * m_volume;
		double sinVal = ::sin(m_dds + theta) * m_volume;

		m_dds += ddsInc;

		if (frequency < 0.0)
			output[i] = complex<double>(sinVal, cosVal);
		else
			output[i] = complex<double>(cosVal, sinVal);
	}
}
