/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT6MDisplay_H
#define	JT6MDisplay_H

#include <wx/wx.h>
#include <wx/listctrl.h>

#include "common/LevelGraph.h"

#include "JT6MLevels.h"
#include "JT6MMessage.h"
#include "JT6MLevelGraph.h"

class CJT6MDisplay : public wxPanel {
    public:
	CJT6MDisplay(wxWindow* parent, int id = -1);
	virtual ~CJT6MDisplay();

	virtual void onMessageSelected(const wxListEvent& event);
	virtual void onMessageClick(const wxListEvent& event);

	virtual void onClearMessages(const wxCommandEvent& event);

	virtual void showMessage(CJT6MMessage* message);
	virtual void showLevels(CJT6MLevels* levels) const;
	virtual void showAudio(double audio) const;

    private:
	CJT6MLevelGraph*  m_level;
	CLevelGraph*      m_audio;
	wxListCtrl*       m_messageListCtrl;
	wxMenu*           m_messageMenu;
	int               m_listCount;
	int               m_selected;
	CJT6MMessageList* m_messageList;

	DECLARE_EVENT_TABLE()

	wxMenu* createMessageMenu();
};

#endif
