/* dnd.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: dnd.cc,v 1.5 2001/11/03 17:10:00 ralf Exp $ */

#include "dnd.h"
#include "lister.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

DNDMsg::DNDMsg(Worker *tworker)
{
  this->worker=tworker;

  sl=el=NULL;
  slm=elm=NULL;
  
}

DNDMsg::DNDMsg(Worker *tworker,AGDNDSTART s,AGDNDEND e)
{
  this->worker=tworker;

  sl=el=NULL;
  slm=elm=NULL;
  
  setStart(&s);
  setEnd(&e);
}

FileEntry *DNDMsg::getFE()
{
  NormalMode *nm;
  if(slm!=NULL) {
    if(slm->isType("NormalMode")==true) {
      nm=(NormalMode*)slm;
      return nm->getFE4DNDSTART(&start);
    }
  }
  return NULL;
}

const char *DNDMsg::getDestDir()
{
  if(elm!=NULL) {
    if(elm->isType("NormalMode")==true) {
      return ((NormalMode*)elm)->getActualDir();
    }
  }
  return NULL;
}

Lister *DNDMsg::getDestLister()
{
  return el;
}

ListerMode *DNDMsg::getDestMode()
{
  return elm;
}

Lister *DNDMsg::getSourceLister()
{
  return sl;
}

ListerMode *DNDMsg::getSourceMode()
{
  return slm;
}

void DNDMsg::setStart(AGDNDSTART*s)
{
  Lister *l1,*l2;
  ListerMode *lm1=NULL,*lm2=NULL;
  GUIElement *gel;

  start=*s;

  sl=NULL;
  slm=NULL;
  
  l1=worker->getLister(0);
  lm1=l1->getActiveMode();
  l2=worker->getLister(1);
  lm2=l2->getActiveMode();

/*  if((lm1!=NULL)&&(lm2!=NULL)) {
    gel=start.element;
    if(lm1->isyours(gel)==true) {
      slm=lm1;
      sl=l1;
    } else if(lm2->isyours(gel)==true) {
      slm=lm2;
      sl=l2;
    }
  }*/
  gel=start.element;
  if(lm1!=NULL) {
    if(lm1->isyours(gel)==true) {
      slm=lm1;
      sl=l1;
    }
  }
  if((sl==NULL)&&(lm2!=NULL)) {
    if(lm2->isyours(gel)==true) {
      slm=lm2;
      sl=l2;
    }
  }
}

void DNDMsg::setEnd(AGDNDEND*e)
{
  Lister *l1,*l2;
  ListerMode *lm1=NULL,*lm2=NULL;
  GUIElement *gel;

  end=*e;

  el=NULL;
  elm=NULL;
  
  l1=worker->getLister(0);
  lm1=l1->getActiveMode();
  l2=worker->getLister(1);
  lm2=l2->getActiveMode();

/*  if((lm1!=NULL)&&(lm2!=NULL)) {
    gel=end.element;
    if(lm1->isyours(gel)==true) {
      elm=lm1;
      el=l1;
    } else if(lm2->isyours(gel)==true) {
      elm=lm2;
      el=l2;
    }
  }*/
  gel=end.element;
  if(gel!=NULL) {
    if(lm1!=NULL) {
      if(lm1->isyours(gel)==true) {
        elm=lm1;
        el=l1;
      }
    }
    if((el==NULL)&&(lm2!=NULL)) {
      if(lm2->isyours(gel)==true) {
        elm=lm2;
        el=l2;
      }
    }
  } else if(end.window!=NULL) {
    if(l1!=NULL)
      if(l1->getAWindow()==end.window) el=l1;
    if(el==NULL)
      if(l2!=NULL)
        if(l2->getAWindow()==end.window) el=l2;
  }
}

const AGDNDSTART *DNDMsg::getStart()
{
  return &start;
}

const AGDNDEND *DNDMsg::getEnd()
{
  return &end;
}

