# log_parser.pl
# Functions for parsing this module's logs

do './pap-lib.pl';

# parse_webmin_log(user, script, action, type, object, &params)
# Converts logged information from this module into human-readable form
sub parse_webmin_log
{
local ($user, $script, $action, $type, $object, $p) = @_;
if ($action eq 'modify') {
	return &text('log_modify', "<tt>".&html_escape($object)."</tt>");
	}
elsif ($action eq 'create') {
	return &text('log_create', "<tt>".&html_escape($object)."</tt>");
	}
elsif ($action eq 'delete') {
	return &text('log_delete', "<tt>".&html_escape($object)."</tt>");
	}
elsif ($action eq 'sync') {
	return $text{'log_sync'};
	}
else {
	return undef;
	}
}

