/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef REPORTDIALOG_H
#define REPORTDIALOG_H

#include <QDialog>
#include <QList>

#include "models/htmlreportgenerator.h"

class QRadioButton;
class QTextDocument;

class PreviewPrinter;

/**
* Dialog for printing or exporting a report.
*/
class ReportDialog : public QDialog
{
    Q_OBJECT
public:
    /**
    * Mode of the report.
    */
    enum ReportMode
    {
        /** Printed HTML report. */
        Print,
        /** Report saved as a CVS file. */
        ExportCsv,
        /** Report saved as a HTML file. */
        ExportHtml,
        /** Report exported to PDF format. */
        ExportPdf
    };

public:
    /**
    * Constructor.
    *
    * @param source Type of source for the report.
    * @param mode Mode and format of the report.
    * @param parent The parent widget.
    */
    ReportDialog( HtmlReportGenerator::Source source, ReportMode mode, QWidget* parent );

    /**
    * Destructor.
    */
    ~ReportDialog();

public:
    /**
    * Set the issue used as the source for the report.
    */
    void setIssue( int issueId );

    /**
    * Set the folder and issues used as the source for the report.
    */
    void setFolder( int folderId, const QList<int>& issues, const QString& filterName );

public: // overrides
    void accept();

private slots:
    void showPreview();

private:
    bool print();
    bool exportCsv();
    bool exportHtml();
    bool exportPdf();

    QString generateCsvReport();
    QString generateHtmlReport();

    QString getReportFileName( const QString& name, const QString& filter );

private:
    HtmlReportGenerator::Source m_source;
    ReportMode m_mode;

    int m_folderId;
    QList<int> m_issues;
    QString m_filterName;

    QRadioButton* m_tableButton;
    QRadioButton* m_fullTableButton;
    QRadioButton* m_summaryButton;
    QRadioButton* m_fullReportButton;

    PreviewPrinter* m_printer;
};

#endif
