/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "popeditpanel.h"

#include <QLayout>
#include <QLabel>
#include <QButtonGroup>
#include <QPushButton>
#include <QList>

#include "popeditbox.h"

using namespace WebIssues;

PopEditPanel::PopEditPanel( QWidget* parent ) : QWidget( parent )
{
    m_layout = new QGridLayout( this );
    m_layout->setAlignment( Qt::AlignTop );

    m_group = new QButtonGroup( NULL );

    connect( m_group, SIGNAL( buttonClicked( int ) ), this, SIGNAL( buttonClicked( int ) ) );
}

PopEditPanel::~PopEditPanel()
{
    delete m_group;
}

void PopEditPanel::clear()
{
    QObjectList widgets = children();
    for ( int i = 0; i < widgets.count(); i++ ) {
        if ( widgets.at( i )->inherits( "QWidget" ) )
            delete widgets.at( i );
    }

    m_editMap.clear();
}

void PopEditPanel::addAttribute( int id, const QString& name )
{
    int row = m_layout->rowCount();

    QLabel* label = new QLabel( name, this );
    m_layout->addWidget( label, row, 0 );

    PopEditBox* box = new PopEditBox( QString(), this );
    m_layout->addWidget( box, row, 1 );

    label->setBuddy( box );

    m_group->addButton( box->button(), id );

    connect( box, SIGNAL( linkClicked( const QString& ) ), this, SIGNAL( linkClicked( const QString& ) ) );
    connect( box, SIGNAL( linkContextMenu( const QString&, const QPoint& ) ),
        this, SIGNAL( linkContextMenu( const QString&, const QPoint& ) ) );

    if ( isVisible() ) {
        label->show();
        box->show();
    }

    m_editMap.insert( id, box );
}

void PopEditPanel::clearValues()
{
    QList<PopEditBox*> boxes = m_editMap.values();
    for ( int i = 0; i < boxes.count(); i++ )
        boxes.at( i )->clear();
}

void PopEditPanel::setValue( int id, const QString& value )
{
    m_editMap.value( id )->setText( value );
}
