/* @(#)  Function which copies only the History part of image2 on image1.
 * @(#)  Used by some functions (eg. im_histplot etc.).
 * @(#)
 * @(#) int 
 * @(#) im_cp_Hist( image1, image2 )
 * @(#) IMAGE *image1, *image2;
 * @(#)
 * @(#) Returns 0 on success or -1 on fail.
 * @(#)
 *
 * Copyright: Nicos Dessipris
 * Written on: 09/02/1990
 * Modified on : 28/10/1992, J. Cupitt
 * 	- frees old history correctly
 *	- simpler!
 * 18/4/97 JC
 *	- ANSIfied
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/
#include <vips/intl.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <vips/vips.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

int 
im_cp_Hist( IMAGE *out, IMAGE *in )
{
	IM_FREE( out->Hist );
	if( in->Hist )
		if( !(out->Hist = im_strdup( NULL, in->Hist )) ) 
			return( -1 );

	return( 0 );
}
