/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <TLin2Port.h>

#include <Strings.h>
#include <TwoPorts.h>

#include "../images/tlin.xpm"

QPixmap* TLin2Port::pixmap_ = 0;

//-----------------------------------------------------------------
TLin2Port::TLin2Port( const QPoint& center )
  : Component( center )
{
}

//-----------------------------------------------------------------
TLin2Port::~TLin2Port()
{
}

//-----------------------------------------------------------------
const QString& TLin2Port::getCatagory() const
{
  return Strings::TransmissionLineCatagory;
}

//-----------------------------------------------------------------
const QString& TLin2Port::getName() const
{
  return Strings::TLin2PortName;
}

//-----------------------------------------------------------------
const QPixmap& TLin2Port::getPixmap() const
{
  if (!pixmap_)
    {
      pixmap_ = new QPixmap( tlin_xpm );
    }
  return *pixmap_;
}

//-----------------------------------------------------------------
void TLin2Port::initComponent()
{
  boundingRect_ = QRect(-24, -16, 48, 32);
  addNode(-24,0, FALSE, FALSE, TRUE );
  addNode(24,0, FALSE, FALSE, TRUE );
  addAttribute( Strings::AttrImpedance, "Z" );
  addAttribute( Strings::AttrElectricalLng, "E" );
  addAttribute( Strings::AttrElectricalLngFreq, "F" );
}

//-----------------------------------------------------------------
void TLin2Port::drawSymbol(QPainter* p)
{
  p->drawEllipse(-18,-6,8,12);
  p->drawArc(10,-6,8,12,1440,-2880);
  p->drawLine(-14,-6,14,-6);
  p->moveTo(-16,16);
  p->lineTo(-16,6);
  p->lineTo(16,6);
  p->lineTo(16,16);
  p->drawLine(-18,14,-14,14);
  p->drawLine(-20,12,-12,12);
  p->drawLine(-22,10,-10,10);
  p->drawLine(14,14,18,14);
  p->drawLine(12,12,20,12);
  p->drawLine(10,10,22,10);
  p->drawLine(-24,0,-14,0);
  p->drawLine(18,0,24,0);
}

//-----------------------------------------------------------------
bool TLin2Port::initSweep()
{
  bool changed = FALSE;
  TReal z = z_;
  TReal e = e_;
  TReal f = f_;
  z_ = getAttributeValue( "Z" );
  e_ = getAttributeValue( "E" );
  f_ = getAttributeValue( "F" ) * getDimensionValue( Strings::FrequencyDim );
  if ( (z!=z_) || (e!=e_) || (f!=f_) )
    {
      changed = TRUE;
    }
  return changed;
}

//-----------------------------------------------------------------
void TLin2Port::addToAdmittanceMatrix( TReal freq, Matrix* yn )
{
  Matrix y;
  TwoPorts::getTLIN( freq, z_, e_, f_, y);
  uint nodes [4];
  nodes[0] = node(0)->getNodeNumber();
  nodes[1] = 0;
  nodes[2] = node(1)->getNodeNumber();
  nodes[3] = 0;
  yn->insertTwoPort(y, nodes);
}
