/*
 * Copyright (c) 1994 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Network Research
 *	Group at Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#) $Header: /cs/research/mice/starship/src/local/CVS_repository/vic/dct.h,v 1.1.1.1 1998/02/18 18:03:23 ucacsva Exp $ (LBL)
 */

/*
 * Ck = cos(k pi / 16)
 * Sk = sin(k pi / 16)
 */
#define C1 0.98078528
#define C2 0.92387953
#define C3 0.83146961
#define C4 0.70710678
#define C5 0.55557023
#define C6 0.38268343
#define C7 0.19509032
#define S1 C7
#define S3 C5
#define S6 C2
#define C_1 C1
#define S_1 (-S1)
#define C_3 C3
#define S_3 (-S3)

void fdct(const u_char* in, int stride, short* out, const float* qt);
void bv_rdct1(int dc, short* blk, int ac0, u_char* out, int stride);
void bv_rdct2(int dc, short* blk, int ac0,
	      u_char* in, u_char* out, int stride);
void bv_rdct3(int dc, short* blk, int ac0, int ac1,
	      u_char* in, u_char* out, int stride);

#ifdef INT_64
void rdct(short* coef, INT_64 mask, u_char* out, int stride, const int* qt);
void rdct(short* coef, INT_64 mask, u_char* out, int stride, const u_char* in);
#else
void rdct(short* coef, u_int m0, u_int m1, u_char* out, 
	  int stride, const int* qt);
void rdct(short* coef, u_int m0, u_int m1, u_char* out,
	  int stride, const u_char* in);
#endif

void dcfill(int dc, u_char* out, int stride);
void dcsum(int dc, u_char* in, u_char* out, int stride);
void dcsum2(int dc, u_char* in, u_char* out, int stride);
void dct_decimate(const short* in0, const short* in1, short* out);

/*XXX*/
void rdct_fold_q(const int* in, int* qt);
void fdct_fold_q(const int* in, float* qt);

extern const u_char ROWZAG[];
extern const u_char COLZAG[];

/*XXX*/
extern void j_fwd_dct (short* data);
