# -*- coding: utf-8 -*-
'''
Vdirsyncer synchronizes calendars and contacts.
'''

from __future__ import print_function

PROJECT_HOME = 'https://github.com/pimutils/vdirsyncer'
BUGTRACKER_HOME = PROJECT_HOME + '/issues'
DOCS_HOME = 'https://vdirsyncer.pimutils.org/en/stable'

try:
    from .version import version as __version__  # noqa
except ImportError:  # pragma: no cover
    raise ImportError(
        'Failed to find (autogenerated) version.py. '
        'This might be because you are installing from GitHub\'s tarballs, '
        'use the PyPI ones.'
    )


def _check_python_version():  # pragma: no cover
    import sys
    if sys.version_info[0] < 3:
        print('vdirsyncer requires Python 3.')
        sys.exit(1)


_check_python_version()
del _check_python_version


def _detect_faulty_requests():  # pragma: no cover
    text = (
        'Error during import: {e}\n\n'
        'If you have installed vdirsyncer from a distro package, please file '
        'a bug against that package, not vdirsyncer.\n\n'
        'Consult {d}/problems.html#requests-related-importerrors'
        '-based-distributions on how to work around this.'
    )

    try:
        from requests_toolbelt.auth.guess import GuessAuth  # noqa
    except ImportError as e:
        import sys
        print(text.format(e=str(e), d=DOCS_HOME), file=sys.stderr)
        sys.exit(1)


_detect_faulty_requests()
del _detect_faulty_requests
