/*-
 * Copyright (c) 2007 Linpro AS
 * All rights reserved.
 *
 * Author: Dag-Erling Smørgrav <des@linpro.no>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: instance.c 1581 2007-06-26 11:52:25Z des $
 */

#include <errno.h>
#include <stdio.h>
#include <unistd.h>

#include "varnishapi.h"

int
varnish_instance(const char *n_arg,
    char *name, size_t namelen,
    char *dir, size_t dirlen)
{
	size_t len;

	if (n_arg == NULL) {
		if (gethostname(name, namelen) != 0)
			return (-1);
	} else {
		len = snprintf(name, namelen, "%s", n_arg);
		if (len >= namelen) {
			errno = ENAMETOOLONG;
			return (-1);
		}
	}

	if (*name == '/')
		len = snprintf(dir, dirlen, "%s", name);
	else
		len = snprintf(dir, dirlen, "%s/%s", VARNISH_STATE_DIR, name);

	if (len >= dirlen) {
		errno = ENAMETOOLONG;
		return (-1);
	}
	return (0);
}
