/* valatypeparametertype.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valatypeparametertype.h>
#include <vala/valacodenode.h>




enum  {
	VALA_TYPEPARAMETER_TYPE_DUMMY_PROPERTY
};
static ValaDataType* vala_typeparameter_type_real_copy (ValaDataType* base);
static char* vala_typeparameter_type_real_get_cname (ValaDataType* base);
static char* vala_typeparameter_type_real_get_type_id (ValaDataType* base);
static gpointer vala_typeparameter_type_parent_class = NULL;



ValaTypeParameterType* vala_typeparameter_type_new (ValaTypeParameter* type_parameter) {
	ValaTypeParameterType * self;
	g_return_val_if_fail (VALA_IS_TYPEPARAMETER (type_parameter), NULL);
	self = g_object_newv (VALA_TYPE_TYPEPARAMETER_TYPE, 0, NULL);
	vala_data_type_set_type_parameter (VALA_DATA_TYPE (self), type_parameter);
	return self;
}


static ValaDataType* vala_typeparameter_type_real_copy (ValaDataType* base) {
	ValaTypeParameterType * self;
	ValaTypeParameterType* result;
	self = VALA_TYPEPARAMETER_TYPE (base);
	result = vala_typeparameter_type_new (vala_data_type_get_type_parameter (VALA_DATA_TYPE (self)));
	vala_code_node_set_source_reference (VALA_CODE_NODE (result), vala_code_node_get_source_reference (VALA_CODE_NODE (self)));
	vala_data_type_set_value_owned (VALA_DATA_TYPE (result), vala_data_type_get_value_owned (VALA_DATA_TYPE (self)));
	vala_data_type_set_nullable (VALA_DATA_TYPE (result), vala_data_type_get_nullable (VALA_DATA_TYPE (self)));
	vala_data_type_set_floating_reference (VALA_DATA_TYPE (result), vala_data_type_get_floating_reference (VALA_DATA_TYPE (self)));
	return VALA_DATA_TYPE (result);
}


static char* vala_typeparameter_type_real_get_cname (ValaDataType* base) {
	ValaTypeParameterType * self;
	self = VALA_TYPEPARAMETER_TYPE (base);
	if (vala_data_type_get_value_owned (VALA_DATA_TYPE (self))) {
		return g_strdup ("gpointer");
	} else {
		return g_strdup ("gconstpointer");
	}
}


static char* vala_typeparameter_type_real_get_type_id (ValaDataType* base) {
	ValaTypeParameterType * self;
	self = VALA_TYPEPARAMETER_TYPE (base);
	return g_strdup ("G_TYPE_POINTER");
}


static void vala_typeparameter_type_class_init (ValaTypeParameterTypeClass * klass) {
	vala_typeparameter_type_parent_class = g_type_class_peek_parent (klass);
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_typeparameter_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_typeparameter_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_type_id = vala_typeparameter_type_real_get_type_id;
}


static void vala_typeparameter_type_instance_init (ValaTypeParameterType * self) {
}


GType vala_typeparameter_type_get_type (void) {
	static GType vala_typeparameter_type_type_id = 0;
	if (G_UNLIKELY (vala_typeparameter_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeParameterTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeparameter_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeParameterType), 0, (GInstanceInitFunc) vala_typeparameter_type_instance_init };
		vala_typeparameter_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaTypeParameterType", &g_define_type_info, 0);
	}
	return vala_typeparameter_type_type_id;
}




