/* valaobjecttypesymbol.vala
 *
 * Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#include <vala/valaobjecttypesymbol.h>




enum  {
	VALA_OBJECT_TYPE_SYMBOL_DUMMY_PROPERTY
};
static gpointer vala_object_type_symbol_parent_class = NULL;



GeeList* vala_object_type_symbol_get_methods (ValaObjectTypeSymbol* self) {
	return VALA_OBJECT_TYPE_SYMBOL_GET_CLASS (self)->get_methods (self);
}


GeeList* vala_object_type_symbol_get_signals (ValaObjectTypeSymbol* self) {
	return VALA_OBJECT_TYPE_SYMBOL_GET_CLASS (self)->get_signals (self);
}


GeeList* vala_object_type_symbol_get_properties (ValaObjectTypeSymbol* self) {
	return VALA_OBJECT_TYPE_SYMBOL_GET_CLASS (self)->get_properties (self);
}


static void vala_object_type_symbol_class_init (ValaObjectTypeSymbolClass * klass) {
	vala_object_type_symbol_parent_class = g_type_class_peek_parent (klass);
}


static void vala_object_type_symbol_instance_init (ValaObjectTypeSymbol * self) {
}


GType vala_object_type_symbol_get_type (void) {
	static GType vala_object_type_symbol_type_id = 0;
	if (G_UNLIKELY (vala_object_type_symbol_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectTypeSymbolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_type_symbol_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectTypeSymbol), 0, (GInstanceInitFunc) vala_object_type_symbol_instance_init };
		vala_object_type_symbol_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaObjectTypeSymbol", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_object_type_symbol_type_id;
}




