/* valadynamicsignal.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valadynamicsignal.h>
#include <vala/valadatatype.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valasymbol.h>
#include <vala/valacodegenerator.h>




struct _ValaDynamicSignalPrivate {
	ValaDataType* _dynamic_type;
	ValaExpression* _handler;
};

#define VALA_DYNAMIC_SIGNAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignalPrivate))
enum  {
	VALA_DYNAMIC_SIGNAL_DUMMY_PROPERTY,
	VALA_DYNAMIC_SIGNAL_DYNAMIC_TYPE,
	VALA_DYNAMIC_SIGNAL_HANDLER
};
static ValaCodeBinding* vala_dynamic_signal_real_create_code_binding (ValaCodeNode* base, ValaCodeGenerator* codegen);
static gpointer vala_dynamic_signal_parent_class = NULL;
static void vala_dynamic_signal_dispose (GObject * obj);



ValaDynamicSignal* vala_dynamic_signal_new (ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference) {
	ValaDynamicSignal * self;
	g_return_val_if_fail (VALA_IS_DATA_TYPE (dynamic_type), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (return_type), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_DYNAMIC_SIGNAL, 0, NULL);
	vala_dynamic_signal_set_dynamic_type (self, dynamic_type);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	vala_signal_set_return_type (VALA_SIGNAL (self), return_type);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


static ValaCodeBinding* vala_dynamic_signal_real_create_code_binding (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaDynamicSignal * self;
	self = VALA_DYNAMIC_SIGNAL (base);
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (codegen), NULL);
	return vala_code_generator_create_dynamic_signal_binding (codegen, self);
}


ValaDataType* vala_dynamic_signal_get_dynamic_type (ValaDynamicSignal* self) {
	g_return_val_if_fail (VALA_IS_DYNAMIC_SIGNAL (self), NULL);
	return self->priv->_dynamic_type;
}


void vala_dynamic_signal_set_dynamic_type (ValaDynamicSignal* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (VALA_IS_DYNAMIC_SIGNAL (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_dynamic_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_dynamic_type == NULL ? NULL : (self->priv->_dynamic_type = (g_object_unref (self->priv->_dynamic_type), NULL))), _tmp2);
}


ValaExpression* vala_dynamic_signal_get_handler (ValaDynamicSignal* self) {
	g_return_val_if_fail (VALA_IS_DYNAMIC_SIGNAL (self), NULL);
	return self->priv->_handler;
}


void vala_dynamic_signal_set_handler (ValaDynamicSignal* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_DYNAMIC_SIGNAL (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_handler = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_handler == NULL ? NULL : (self->priv->_handler = (g_object_unref (self->priv->_handler), NULL))), _tmp2);
}


static void vala_dynamic_signal_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaDynamicSignal * self;
	self = VALA_DYNAMIC_SIGNAL (object);
	switch (property_id) {
		case VALA_DYNAMIC_SIGNAL_DYNAMIC_TYPE:
		g_value_set_object (value, vala_dynamic_signal_get_dynamic_type (self));
		break;
		case VALA_DYNAMIC_SIGNAL_HANDLER:
		g_value_set_object (value, vala_dynamic_signal_get_handler (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_dynamic_signal_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaDynamicSignal * self;
	self = VALA_DYNAMIC_SIGNAL (object);
	switch (property_id) {
		case VALA_DYNAMIC_SIGNAL_DYNAMIC_TYPE:
		vala_dynamic_signal_set_dynamic_type (self, g_value_get_object (value));
		break;
		case VALA_DYNAMIC_SIGNAL_HANDLER:
		vala_dynamic_signal_set_handler (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_dynamic_signal_class_init (ValaDynamicSignalClass * klass) {
	vala_dynamic_signal_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaDynamicSignalPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_dynamic_signal_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_dynamic_signal_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_dynamic_signal_dispose;
	VALA_CODE_NODE_CLASS (klass)->create_code_binding = vala_dynamic_signal_real_create_code_binding;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_DYNAMIC_SIGNAL_DYNAMIC_TYPE, g_param_spec_object ("dynamic-type", "dynamic-type", "dynamic-type", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_DYNAMIC_SIGNAL_HANDLER, g_param_spec_object ("handler", "handler", "handler", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_dynamic_signal_instance_init (ValaDynamicSignal * self) {
	self->priv = VALA_DYNAMIC_SIGNAL_GET_PRIVATE (self);
}


static void vala_dynamic_signal_dispose (GObject * obj) {
	ValaDynamicSignal * self;
	self = VALA_DYNAMIC_SIGNAL (obj);
	(self->priv->_dynamic_type == NULL ? NULL : (self->priv->_dynamic_type = (g_object_unref (self->priv->_dynamic_type), NULL)));
	(self->priv->_handler == NULL ? NULL : (self->priv->_handler = (g_object_unref (self->priv->_handler), NULL)));
	G_OBJECT_CLASS (vala_dynamic_signal_parent_class)->dispose (obj);
}


GType vala_dynamic_signal_get_type (void) {
	static GType vala_dynamic_signal_type_id = 0;
	if (G_UNLIKELY (vala_dynamic_signal_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDynamicSignalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dynamic_signal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDynamicSignal), 0, (GInstanceInitFunc) vala_dynamic_signal_instance_init };
		vala_dynamic_signal_type_id = g_type_register_static (VALA_TYPE_SIGNAL, "ValaDynamicSignal", &g_define_type_info, 0);
	}
	return vala_dynamic_signal_type_id;
}




