/* valaccodeenum.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEENUM_H__
#define __CCODE_VALACCODEENUM_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodeenumvalue.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_ENUM (vala_ccode_enum_get_type ())
#define VALA_CCODE_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ENUM, ValaCCodeEnum))
#define VALA_CCODE_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ENUM, ValaCCodeEnumClass))
#define VALA_IS_CCODE_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ENUM))
#define VALA_IS_CCODE_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ENUM))
#define VALA_CCODE_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ENUM, ValaCCodeEnumClass))

typedef struct _ValaCCodeEnum ValaCCodeEnum;
typedef struct _ValaCCodeEnumClass ValaCCodeEnumClass;
typedef struct _ValaCCodeEnumPrivate ValaCCodeEnumPrivate;

/**
 * Represents an enum in the C code.
 */
struct _ValaCCodeEnum {
	ValaCCodeNode parent_instance;
	ValaCCodeEnumPrivate * priv;
};

struct _ValaCCodeEnumClass {
	ValaCCodeNodeClass parent_class;
};


ValaCCodeEnum* vala_ccode_enum_new (const char* name);
void vala_ccode_enum_add_value (ValaCCodeEnum* self, ValaCCodeEnumValue* value);
const char* vala_ccode_enum_get_name (ValaCCodeEnum* self);
void vala_ccode_enum_set_name (ValaCCodeEnum* self, const char* value);
GType vala_ccode_enum_get_type (void);


G_END_DECLS

#endif
