/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef VISU_GTK_H
#define VISU_GTK_H

#include <glib.h>
#include <gtk/gtk.h>
#include "coreTools/toolFileFormat.h"
#include "visu_data.h"
#include "visu_rendering.h"

/**
 * VisuGtkWidgetFunc:
 *
 * This prototype is used whenever a method is required to create a GtkWidget.
 *
 * Returns: (transfer full): a newly created GtkWidget.
 */
typedef GtkWidget* (*VisuGtkWidgetFunc)(void);

/**
 * VisuGtkInitWidgetFunc:
 * @panel: a location for a #GtkWindow ;
 * @renderWindow: a location for a #GtkWindow ;
 * @renderArea: a location for a #GtkWidget.
 *
 * This prototype is used whenever a method is required to initialise
 * the GTK interface of V_Sim. @panel must be set to point on the
 * window of the command panel, @renderWindow must point to the window
 * containing the rendering area (can be the same than @panel) and
 * @renderArea contains the widget that does the OpenGL rendering.
 */
typedef void (*VisuGtkInitWidgetFunc)(GtkWindow **panel, GtkWindow **renderWindow,
				      GtkWidget **renderArea);

/**
 * visuGtkRaise_warning:
 * @action: a string ;
 * @message: another string ;
 * @window: the parent window to raise the warning on.
 *
 * Raise a warning window with the action in bold and the message written
 * underneath.
 */
void visuGtkRaise_warning(gchar *action, gchar *message, GtkWindow *window);
/**
 * visuGtkRaise_warningLong:
 * @action: a string ;
 * @message: another string ;
 * @window: the parent window to raise the warning on.
 *
 * Same as visuGtkRaise_warning() except that the message is displayed
 * in a text buffer, ideal for a log.
 */
void visuGtkRaise_warningLong(gchar *action, gchar *message, GtkWindow *window);

/**
 * VisuGtkSetFilesFunc:
 * @data: a #VisuData to store the informations ;
 * @parent: the parent window of the dialog.
 * 
 * Methods that conform to this prototype is used to set filename(s)
 * to be loaded when the 'load' button is pushed. They can use a
 * #GtkFileChooser to prompt the user for file names.
 *
 * Returns: FALSE if no filename as been set, TRUE if the calling method should
 *          call gtkMainLoadAndRender_file() with a g_idle_add method.
 */
typedef gboolean (*VisuGtkSetFilesFunc)(VisuData *data, GtkWindow *parent);

/**
 * visuGtkSet_renderingSpecificMethods:
 * @method: a #RenderingMethod object;
 * @methodLoad: a #VisuUiMainSetFilesFunc method (can be NULL).
 *
 * This function is used by a client to add gtk methods to a rendering method.
 * The @methodLoad argument is called to when the 'load' button is pushed.
 */
void visuGtkSet_renderingSpecificMethods(VisuRendering *method,
					 VisuGtkSetFilesFunc methodLoad);
/**
 * visuGtkGet_renderingSpecificOpen:
 * @method: a #RenderingMethod object.
 *
 * This method is used to retrieve the #VisuUiMainSetFilesFunc associate with
 * the specified @method.
 *
 * Returns: a load method if one has been specified for @method
 *          or gtkMainClassSet_fileFromDefaultFileChooser().
 */
VisuGtkSetFilesFunc visuGtkGet_renderingSpecificOpen(VisuRendering *method);

/**
 * VisuGtkPreview:
 * @check: the widget used to allow or not preview ;
 * @image: the #GtkImage with the preview ;
 * @table: a #GtkTable with file informations ;
 * @vbox: the #GtkVBox with all the stuff for previewing.
 *
 * A container for the relevant widgets of the preview area.
 */
typedef struct _VisuGtkPreview
{
  GtkWidget *check;
  GtkWidget *image;
  GtkWidget *table;
  GtkWidget *vbox;
} VisuGtkPreview;

/**
 * visuGtkPreview_add:
 * @preview: a location on #VisuGtkPreview (uninitialised) ;
 * @chooser: the filechooser the preview must be attached to.
 *
 * Create the widgets to have a preview attached to @filechooser. But
 * the signal raised by @filechooser when previewing is needed is not
 * attached and this must be done by the user with custom routine.
 *
 * Returns: @preview itself.
 */
VisuGtkPreview* visuGtkPreview_add(VisuGtkPreview *preview, GtkFileChooser *chooser);
/**
 * visuGtkPreview_update:
 * @preview: a location on #VisuGtkPreview (initialised) ;
 * @filenames: an array of filenames.
 *
 * This routine update the content of the given @preview by making a
 * rendering in a pixmap of the given filenames. The number of given
 * filenames must match the number required by the current rendering
 * method. Only the nodes, the box and the background (plus fog) is
 * actually previewed.
 */
void visuGtkPreview_update(VisuGtkPreview *preview, const char *filenames[]);


/**
 * visuGtkGet_selectedDirectory:
 * @parent: if NULL, the command panel window is used ;
 * @multiple: if TRUE, multiple directories can be selected ;
 * @dir: if not NULL, give the opening directory.
 *
 * General procedure to get the location of one or more directories.
 * In the multiple case, all selected directories shares a common ancestor
 * since the selection is done through the same selector that for single
 * directory but with multiple selection activated. If @dir is NULL
 * the last opened (and stored) directory is used (see
 * visuGtkGet_lastOpenDirectory() and visuGtkSet_lastOpenDirectory()).
 *
 * Returns: a newly allocated array of paths, NULL terminated. Use g_strfreev()
 *          to free it after use. If no directory is selected, then NULL is
 *          returned.
 */
gchar** visuGtkGet_selectedDirectory(GtkWindow *parent, gboolean multiple,
				     const gchar *dir);

/**
 * visuGtkGet_fileFromDefaultFileChooser:
 * @data: an allocated #VisuData to store the file names ;
 * @parent: the parent window of the dialog.
 *
 * This method is a default method to launch a file chooser that select
 * a single file, with the filters of the current RenderingMethod. It creates a
 * modal dialog, and wait for its reponse. If OK is clicked, the selected
 * filename is stored. If Cancel is clicked, nothing is done. The
 * dialog is destroyed after use.
 *
 * Returns: FALSE if no file has been set, TRUE if the calling method should
 *          call gtkMainLoadAndRender_file() with a g_idle_add() method.
 */
gboolean visuGtkGet_fileFromDefaultFileChooser(VisuData *data, GtkWindow *parent);

/**
 * visuGtkMain:
 * @panelFunc: function to be called to create the different windows.
 *
 * It initializses the GTK part of V_Sim. During this initialisation,
 * the @panelFunc is called. It should create all the windows needed
 * by V_Sim, like the command panel and the rendering area. The return
 * widget is the widget returned itself by @panelFunc. It must be the
 * main widget: it is the command panel if used, the window containing
 * the rendering area if no command panel or the rendering area itself
 * if no container window.
 *
 * Returns: the main widget for V_Sim, returned itself by @panelFunc.
 */
void visuGtkMain(VisuGtkInitWidgetFunc panelFunc);
/**
 * visuGtkRun_commandLine:
 * @data: a pointer to the command panel (see #VisuUiMain).
 *
 * Call the get routines from the command line module and deal with
 * them. This method is not aware of the panels and is intended to be
 * called only when the command panel is not used. In the opposite
 * case, use visu_ui_main_runCommandLine() instead.
 *
 * Returns: FALSE always.
 */
gboolean visuGtkRun_commandLine(gpointer data);

/**
 * visuGtkWait:
 *
 * It runs the Gtk event loop, flushing it before returning.
 */
void visuGtkWait(void);

/**
 * FileFilterCustom:
 * @gtkFilter: the #GtkFileFilter associate to @visuFilter.
 * @visuFilter: a #ToolFileFormat object.
 *
 * Structure used to associate the V_Sim way to store file filters
 * with the Gtk way.
 */
typedef struct FileFilterCustom_struct
{
  GtkFileFilter *gtkFilter;
  ToolFileFormat* visuFilter;
} FileFilterCustom;

/**
 * visuGtkCreate_fileChooserFilter:
 * @list: a GList of #ToolFileFormat ;
 * @fileChooser: a file chooser to associate filters with.
 *
 * Create a list of GtkFileFilter created from the given list of file formats
 * and attach it to the given @fileChooser.
 *
 * Returns: a list of #FileFilterCustom. This list should be freed after use.
 */
GList* visuGtkCreate_fileChooserFilter(GList *list, GtkWidget *fileChooser);

/**
 * VisuGtkDirType:
 * @VISU_DIR_FILE: default kind of directory ;
 * @VISU_DIR_SURFACE: directory for surfaces ;
 * @VISU_DIR_DATAFILE: directory for data files ;
 * @VISU_DIR_CONF: directory for configuration files ;
 * @VISU_DIR_BROWSER: directory used in the browser.
 * @N_VISU_DIR: private.
 *
 * V_Sim remembers the last open directory when presenting a new file
 * selector. This enum is used to specify different kind of
 * directories. Like that saving a configuration file in a given
 * directory will not affect the prefered directory for browsing a
 * list of files.
 */
typedef enum
  {
    VISU_DIR_FILE,
    VISU_DIR_SURFACE,
    VISU_DIR_DATAFILE,
    VISU_DIR_CONF,
    VISU_DIR_BROWSER,
    /*< private >*/
    N_VISU_DIR
  } VisuGtkDirType;
/**
 * visuGtkGet_lastOpenDirectory:
 *
 * V_Sim stores the last open directory to set the file chooser to
 * this one the next time it will come. Use
 * visuGtkSet_lastOpenDirectory() to store it after a GTK_RESPONSE_OK
 * has been returned by a file chooser and then initialise each new
 * with this routine.
 *
 * Returns: a string owned by V_Sim.
 */
gchar* visuGtkGet_lastOpenDirectory(void);
/**
 * visuGtkSet_lastOpenDirectory:
 * @directory: a full path to a directory ;
 * @type: the kind of directory to set the remember flag on.
 *
 * V_Sim stores the last open directory to set the file chooser to
 * this one the next time it will come. Use this routine each time a
 * file chooser returns GTK_RESPONSE_OK. The given string will be
 * copied and can be freed after use.
 */
void visuGtkSet_lastOpenDirectory(const char* directory, VisuGtkDirType type);

/**
 * visuGtkCreate_pixbuf:
 * @filename: a file name (must be a base name).
 *
 * Replace the create_pixbuf() routine from Glade. It looks only in
 * the default pixmap directory of V_Sim to find the given file.
 *
 * Returns: a newly created GdkPixbuf on success.
 */
GdkPixbuf* visuGtkCreate_pixbuf(const gchar *filename);
/**
 * visuGtkCreate_main:
 * @panel: a location for a #GtkWindow, will be NULL at return time ;
 * @renderWindow: a location for a #GtkWindow ;
 * @renderArea: a location for a #GtkWidget.
 *
 * A convenient routine that creates a #VisuRenderingWindow alone. To
 * create also a command panel, visu_uiMainClass_createMain() should be
 * used instead.
 */
void visuGtkCreate_main(GtkWindow **panel, GtkWindow **renderWindow,
			GtkWidget **renderArea);
/**
 * visuGtkGet_panel:
 *
 * A convenient function to get the command panel window.
 *
 * Returns: a #GtkWindow.
 */
GtkWindow* visuGtkGet_panel(void);
/**
 * visuGtkGet_render:
 *
 * A convenient function to get the rendering area window.
 *
 * Returns: a #GtkWindow.
 */
GtkWindow* visuGtkGet_render(void);
/**
 * visuGtkGet_renderArea:
 *
 * A convenient function to get the rendering area widget.
 *
 * Returns: a #GtkWidget.
 */
GtkWidget* visuGtkGet_renderArea(void);

#endif
