/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <unistd.h> /* For the access markers R_OK, W_OK ... */

#include "gtk_save.h"

#include "visu_gtk.h"
#include "gtk_main.h"
#include "visu_configFile.h"
#include "visu_object.h"
#include "visu_tools.h"
#include "visu_basic.h"
#include "gtk_renderingWindowWidget.h"
#include "visu_commandLine.h"

/**
 * SECTION: gtk_save
 * @short_description: The load/save dialog for resources and parameters.
 */

static guint saveResourcesContextId, saveParametersContextId;
static gchar *lastParsedDir;
static GtkWidget *checkXMLResources, *checkXMLParameters, *checkXMLCommandLine;

/* Local Callbacks. */
static void onLoadResButtonClicked(GtkButton *button, gpointer data);
static void onSaveResButtonClicked(GtkButton *button, gpointer data);
static void onSelectionResourcesChange(GtkFileChooser *fileChooser, gpointer *data);
static void onLoadResourcesSelected(GtkFileChooser *fileChooser, gpointer *data);
static void onTextEntryChange(GtkEditable *entry, gpointer data);

static void onSaveParButtonClicked(GtkButton *button, gpointer data);

/* Local methods. */
static void showAlertMessage(GtkWidget *saveDialog, gchar* message, gboolean warning, int type);
static void saveAction(int type, GtkWidget *saveDialog, GtkEntry *entry);

/* The completion tree model. */
enum
  {
    GTK_SAVE_FILE_NAME,
    GTK_SAVE_NB_COLUMNS
  };

void gtkSaveInit()
{
  GtkWidget *saveDialog;
  GtkWidget *wd, *label;
  GtkEntryCompletion *completion;
  gchar *directory, *file;
  GList *resList;
  GtkListStore *listOfFiles;
  const gchar *currentResPath;
  int i, j;

  saveDialog = create_saveDialog();
  gtk_widget_set_name(saveDialog, "message");

  /* Set style. */
  wd = lookup_widget(saveDialog, "labelSaveDialog");
  gtk_widget_set_name(wd, "message_title");

  wd = lookup_widget(saveDialog, "notebookSave");
  gtk_widget_set_name(wd, "message_notebook");

  wd = lookup_widget(saveDialog, "labelResources");
  gtk_widget_set_name(wd, "label_head");
  wd = lookup_widget(saveDialog, "labelParameters");
  gtk_widget_set_name(wd, "label_head");

  wd = lookup_widget(saveDialog, "imageWarningResources");
  gtk_widget_hide(wd);
  wd = lookup_widget(saveDialog, "imageWarningParameters");
  gtk_widget_hide(wd);

  wd = lookup_widget(saveDialog, "statusbarResources");
  gtk_widget_set_name(wd, "message_statusbar");
  wd = lookup_widget(saveDialog, "statusbarParameters");
  gtk_widget_set_name(wd, "message_statusbar");

  wd = lookup_widget(saveDialog, "labelHelp");
  gtk_widget_set_name(wd, "label_info");
  wd = lookup_widget(saveDialog, "labelHelpTips");
  gtk_widget_set_name(wd, "label_info");

  /* Set default values. */
  wd = lookup_widget(saveDialog, "checkLimitOnVisuData");
  if (visu_rendering_window_getVisuData(visu_uiMainClass_getDefaultRendering()))
    gtk_widget_set_sensitive(wd, TRUE);
  else
    gtk_widget_set_sensitive(wd, FALSE);
  gtk_widget_set_name(wd, "message_radio");
  wd = lookup_widget(saveDialog, "notebookResources");
  gtk_notebook_set_current_page(GTK_NOTEBOOK(wd), 1);
  gtk_widget_set_name(wd, "message_notebook");


  /* Local variables. */
  listOfFiles = gtk_list_store_new(GTK_SAVE_NB_COLUMNS,
				   G_TYPE_STRING);
  gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(listOfFiles),
				       GTK_SAVE_FILE_NAME, GTK_SORT_ASCENDING);
  lastParsedDir = (gchar*)0;

  /* Set initial values. */
  wd = lookup_widget(saveDialog, "filechooserwidgetResources");
  directory = visuGtkGet_lastOpenDirectory();
  if (directory)
    gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(wd), directory);
  g_signal_connect(G_OBJECT(wd), "selection-changed",
		   G_CALLBACK(onSelectionResourcesChange),
		   (gpointer)lookup_widget(saveDialog, "buttonLoadResources"));
  g_signal_connect(G_OBJECT(wd), "file-activated",
		   G_CALLBACK(onLoadResourcesSelected), (gpointer)saveDialog);

  wd = lookup_widget(saveDialog, "statusbarResources");
  saveResourcesContextId = gtk_statusbar_get_context_id(GTK_STATUSBAR(wd), "Resources");

  wd = lookup_widget(saveDialog, "comboboxentryParameters");
  gtk_widget_set_name(wd, "message_entry");
  resList = visu_configFile_getPathList(VISU_CONFIGFILE_PARAMETER);
  for (file = visu_configFile_getNextValidPath(VISU_CONFIGFILE_PARAMETER,
					      W_OK, &resList, 1);
       file;
       file = visu_configFile_getNextValidPath(VISU_CONFIGFILE_PARAMETER,
					      W_OK, &resList, 1))
    gtk_combo_box_text_append(GTK_COMBO_BOX_TEXT(wd), (const gchar*)0, file);
  completion = gtk_entry_completion_new();
  gtk_entry_completion_set_model(completion, GTK_TREE_MODEL(listOfFiles));
  gtk_entry_completion_set_text_column(completion, GTK_SAVE_FILE_NAME);
#if GTK_MAJOR_VERSION > 2 || GTK_MINOR_VERSION > 5
  gtk_entry_completion_set_inline_completion(completion, TRUE);
#endif
  gtk_entry_set_completion(GTK_ENTRY(gtk_bin_get_child(GTK_BIN(wd))), completion);
  g_signal_connect(G_OBJECT(gtk_bin_get_child(GTK_BIN(wd))), "changed",
		   G_CALLBACK(onTextEntryChange), (gpointer)0);
  gtk_combo_box_set_active(GTK_COMBO_BOX(wd), 0);


  wd = lookup_widget(saveDialog, "comboboxentryResources");
  gtk_widget_set_name(wd, "message_entry");
  currentResPath = visu_configFile_getPathToResources();
  j = i = 0;
  resList = visu_configFile_getPathList(VISU_CONFIGFILE_RESOURCE);
  for (file = visu_configFile_getNextValidPath(VISU_CONFIGFILE_RESOURCE,
					      W_OK, &resList, 1);
       file;
       file = visu_configFile_getNextValidPath(VISU_CONFIGFILE_RESOURCE,
					      W_OK, &resList, 1))
    {
      if (!strcmp(file, currentResPath))
	j = i;
      gtk_combo_box_text_append(GTK_COMBO_BOX_TEXT(wd), (const gchar*)0, file);
      i += 1;
    }
  completion = gtk_entry_completion_new();
  gtk_entry_completion_set_model(completion, GTK_TREE_MODEL(listOfFiles));
  gtk_entry_completion_set_text_column(completion, GTK_SAVE_FILE_NAME);
#if GTK_MAJOR_VERSION > 2 || GTK_MINOR_VERSION > 5
  gtk_entry_completion_set_inline_completion(completion, TRUE);
#endif
  gtk_entry_set_completion(GTK_ENTRY(gtk_bin_get_child(GTK_BIN(wd))), completion);
  g_signal_connect(G_OBJECT(gtk_bin_get_child(GTK_BIN(wd))), "changed",
		   G_CALLBACK(onTextEntryChange), (gpointer)0);
  gtk_combo_box_set_active(GTK_COMBO_BOX(wd), j);

  wd = lookup_widget(saveDialog, "labelTipsResources");
  gtk_label_set_line_wrap(GTK_LABEL(wd), FALSE);
  gtk_label_set_markup(GTK_LABEL(wd), _("A description of all resource markups is"
					" available on:"
					"\n   <span font_desc=\"monospace\"><u>"
					VISU_WEB_SITE"/sample.html#resources"
					"</u></span>."));

  /* Set callbacks. */
  wd = lookup_widget(saveDialog, "buttonLoadResources");
  g_signal_connect(G_OBJECT(wd), "clicked",
		   G_CALLBACK(onLoadResButtonClicked), (gpointer)saveDialog);
  wd = lookup_widget(saveDialog, "buttonSaveResources");
  g_signal_connect(G_OBJECT(wd), "clicked",
		   G_CALLBACK(onSaveResButtonClicked), (gpointer)saveDialog);
  wd = lookup_widget(saveDialog, "buttonSaveParameters");
  g_signal_connect(G_OBJECT(wd), "clicked",
		   G_CALLBACK(onSaveParButtonClicked), (gpointer)saveDialog);

#if DEBUG == 1
  wd = lookup_widget(saveDialog, "vbox16");
  checkXMLResources =
    gtk_check_button_new_with_mnemonic(_("Export all resource descriptions"
					 " to an _XML file"));
  gtk_box_pack_start(GTK_BOX(wd), checkXMLResources, FALSE, FALSE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(checkXMLResources), 5);
  gtk_widget_set_name(checkXMLResources, "message_radio");
  gtk_widget_show(checkXMLResources);

  wd = lookup_widget(saveDialog, "vbox18");
  checkXMLParameters =
    gtk_check_button_new_with_mnemonic(_("Export all parameter descriptions"
					 " to an _XML file"));
  gtk_box_pack_start(GTK_BOX(wd), checkXMLParameters, FALSE, FALSE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(checkXMLParameters), 5);
  gtk_widget_set_name(checkXMLParameters, "message_radio");
  gtk_widget_show(checkXMLParameters);

  checkXMLCommandLine =
    gtk_check_button_new_with_mnemonic(_("Export all command line _options"
					 " to an XML file"));
  gtk_box_pack_start(GTK_BOX(wd), checkXMLCommandLine, FALSE, FALSE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(checkXMLCommandLine), 5);
  gtk_widget_set_name(checkXMLCommandLine, "message_radio");
  gtk_widget_show(checkXMLCommandLine);
#else
  checkXMLResources = (GtkWidget*)0;
  checkXMLParameters = (GtkWidget*)0;
  checkXMLCommandLine = (GtkWidget*)0;
#endif

  wd = lookup_widget(saveDialog, "vbox18");
  label = gtk_label_new("");
  gtk_label_set_line_wrap(GTK_LABEL(label), FALSE);
  gtk_label_set_markup(GTK_LABEL(label), _("A description of all parameter markups is"
					   " available on:\n"
					   "   <span font_desc=\"monospace\"><u>"
					   VISU_WEB_SITE"/sample.html#parameters"
					   "</u></span>."));
  gtk_misc_set_alignment(GTK_MISC(label), 0., 0.5);
  gtk_box_pack_end(GTK_BOX(wd), label, FALSE, FALSE, 10);
  gtk_widget_show(label);

  /* Run the dialog. */
  gtk_dialog_run(GTK_DIALOG(saveDialog));
  g_object_unref(listOfFiles);
  if (lastParsedDir)
    g_free(lastParsedDir);
  gtk_widget_destroy(saveDialog);
}

static void onLoadResourcesSelected(GtkFileChooser *fileChooser _U_, gpointer *data)
{
  onLoadResButtonClicked((GtkButton*)0, data);
}

static void onSelectionResourcesChange(GtkFileChooser *fileChooser, gpointer *data)
{
  gchar *filename;

  g_return_if_fail(GTK_BUTTON(data));
  
  filename = gtk_file_chooser_get_filename(fileChooser);
  if (!filename)
    {
      gtk_widget_set_sensitive(GTK_WIDGET(data), FALSE);
      return;
    }

  DBG_fprintf(stderr, "Gtk Save : selected a new potential"
	      " resources file : '%s'.\n", filename);
  gtk_widget_set_sensitive(GTK_WIDGET(data),
			   !g_file_test(filename, G_FILE_TEST_IS_DIR));
  g_free(filename);
}

static void onLoadResButtonClicked(GtkButton *button _U_, gpointer data)
{
  GtkWidget *file_selector;
  gchar *filename, *basename;
  gchar *directory;
  int res;
  GString *message;
  GError *error;
  VisuData *dataObj;

  g_return_if_fail(GTK_DIALOG(data));

  file_selector = lookup_widget(GTK_WIDGET(data), "filechooserwidgetResources");
  g_return_if_fail(file_selector);

  filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(file_selector));
  directory = gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER(file_selector));
  visuGtkSet_lastOpenDirectory(directory, VISU_DIR_CONF);
  g_free(directory);

  dataObj = visu_rendering_window_getVisuData(visu_uiMainClass_getDefaultRendering());
  error = (GError*)0;
  res = visu_configFile_load(VISU_CONFIGFILE_RESOURCE, filename, dataObj, &error);
  if (error)
    {
      visuGtkRaise_warningLong(_("Loading a file"), error->message,
			       GTK_WINDOW(data));
      g_error_free(error);
    }

  basename = g_path_get_basename(filename);
  g_free (filename);
  message = g_string_new("");
  if (res)
    g_string_append_printf(message, _("File '%s' succesfully loaded."), basename);
  else
    g_string_append_printf(message, _("File '%s' not or partially loaded."),
			   basename);
  showAlertMessage(GTK_WIDGET(data), message->str, !res, VISU_CONFIGFILE_RESOURCE);
  g_string_free(message, TRUE);
  g_free(basename);

  if (res && dataObj)
    {
      /* We rebuild all list. */
      visuExtensions_rebuildAllLists(dataObj);
      VISU_ADD_REDRAW;
    }
}

static void onSaveResButtonClicked(GtkButton *button _U_, gpointer data)
{
  GtkWidget *entry;

  g_return_if_fail(GTK_IS_DIALOG(data));

  entry = gtk_bin_get_child
    (GTK_BIN(lookup_widget(GTK_WIDGET(data), "comboboxentryResources")));
  saveAction(VISU_CONFIGFILE_RESOURCE, GTK_WIDGET(data), GTK_ENTRY(entry));
  gtk_widget_grab_default(lookup_widget(GTK_WIDGET(data), "closeButtonSave"));
}

static void onSaveParButtonClicked(GtkButton *button _U_, gpointer data)
{
  GtkWidget *entry;

  g_return_if_fail(GTK_IS_DIALOG(data));

  entry = gtk_bin_get_child
    (GTK_BIN(lookup_widget(GTK_WIDGET(data), "comboboxentryParameters")));
  saveAction(VISU_CONFIGFILE_PARAMETER, GTK_WIDGET(data), GTK_ENTRY(entry));
  gtk_widget_grab_default(lookup_widget(GTK_WIDGET(data), "closeButtonSave"));
}

static void saveAction(int type, GtkWidget *saveDialog, GtkEntry *entry)
{
  GtkWidget *wd;
  gchar *file, *tmpFile, *basename, *fileUTF8;
  GString *message;
  gboolean resOk;
  gsize ecrit, lu;
  int lines;
  VisuData *dataObj;
  GError *error;
  GtkTreeIter iter;
  GtkListStore *listOfFiles;
  GtkEntryCompletion *completion;

  g_return_if_fail(type == VISU_CONFIGFILE_RESOURCE ||
		   type == VISU_CONFIGFILE_PARAMETER);
  g_return_if_fail(saveDialog && entry);

  file = g_filename_from_utf8(gtk_entry_get_text(entry), -1, &lu, &ecrit, NULL);
  
  if (g_file_test(file, G_FILE_TEST_IS_DIR))
    {
      tmpFile=
	g_build_filename(file, visu_configFile_getDefaultFilename(type), NULL);
      g_free(file);
      file = tmpFile;
    }
  
  if (type == VISU_CONFIGFILE_RESOURCE)
    {
      wd = lookup_widget(saveDialog, "checkLimitOnVisuData");
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wd)))
	dataObj = visu_rendering_window_getVisuData(visu_uiMainClass_getDefaultRendering());
      else
	dataObj = (VisuData*)0;
    }
  else
    dataObj = (VisuData*)0;

  error = (GError*)0;
  lines = 0;
  if (type == VISU_CONFIGFILE_RESOURCE && checkXMLResources &&
      gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkXMLResources)))
    resOk = visu_configFile_exportToXML(file, VISU_CONFIGFILE_RESOURCE, &error);
  else if (type == VISU_CONFIGFILE_PARAMETER && checkXMLParameters &&
	   gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkXMLParameters)))
    resOk = visu_configFile_exportToXML(file, VISU_CONFIGFILE_PARAMETER, &error);
  else if (type == VISU_CONFIGFILE_PARAMETER && checkXMLCommandLine &&
	   gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkXMLCommandLine)))
    resOk = commandLineExport(file, &error);
  else
    resOk = visu_configFile_save(type, file, &lines, dataObj, &error);
  if (!resOk)
    {
      visuGtkRaise_warningLong(_("Saving a file"), error->message,
			       GTK_WINDOW(saveDialog));
      g_error_free(error);
    }
  
  basename = g_path_get_basename(file);
  message = g_string_new("");
  if (resOk)
    g_string_append_printf(message, _("File '%s' succesfully written (%d lines)."),
			   basename, lines);
  else
    g_string_append_printf(message, _("File '%s' not written."), basename);
  showAlertMessage(saveDialog, message->str, !resOk, type);
  g_string_free(message, TRUE);
  g_free(basename);

  /* If file is written, we add it to the completion list. */
  if (resOk)
    {
      completion = gtk_entry_get_completion(GTK_ENTRY(entry));
      g_return_if_fail(completion);

      listOfFiles = GTK_LIST_STORE(gtk_entry_completion_get_model(completion));
      g_return_if_fail(listOfFiles);

      fileUTF8 = g_filename_from_utf8(file, -1, NULL, NULL, NULL);
      if(fileUTF8)
	{
	  gtk_list_store_append(listOfFiles, &iter);
	  gtk_list_store_set(listOfFiles, &iter,
			     GTK_SAVE_FILE_NAME, fileUTF8,
			     -1);
	  g_free(fileUTF8);
	}
    }

  g_free(file);
}

static void showAlertMessage(GtkWidget *saveDialog, gchar* message, gboolean warning, int type)
{
  GtkWidget *wd;

  g_return_if_fail(type == VISU_CONFIGFILE_RESOURCE ||
		   type == VISU_CONFIGFILE_PARAMETER);
  g_return_if_fail(saveDialog);

  if (type == VISU_CONFIGFILE_RESOURCE)
    wd = lookup_widget(saveDialog, "imageWarningResources");
  else
    wd = lookup_widget(saveDialog, "imageWarningParameters");
  if (warning)
    gtk_widget_show(wd);
  else
    gtk_widget_hide(wd);

  if (type == VISU_CONFIGFILE_RESOURCE)
    {
      wd = lookup_widget(saveDialog, "statusbarResources");
      gtk_statusbar_pop(GTK_STATUSBAR(wd), saveResourcesContextId);
      gtk_statusbar_push(GTK_STATUSBAR(wd), saveResourcesContextId, message);
    }
  else
    {
      wd = lookup_widget(saveDialog, "statusbarParameters");
      gtk_statusbar_pop(GTK_STATUSBAR(wd), saveParametersContextId);
      gtk_statusbar_push(GTK_STATUSBAR(wd), saveParametersContextId, message);
    }
}

static void onTextEntryChange(GtkEditable *entry, gpointer data _U_)
{
  gboolean reParse;
  GtkTreeIter iter;
  GtkListStore *listOfFiles;
  GtkEntryCompletion *completion;
  gchar *dirEntry, *dirBrowsed;
  GDir *gdir;
  const gchar *fileFromDir, *fileEntry;
  gsize ecrit, lu;
  gchar *fileUTF8, *saveFile, *saveFileUTF8;

  fileEntry = gtk_entry_get_text(GTK_ENTRY(entry));
  if (!fileEntry || !fileEntry[0])
    return;

  DBG_fprintf(stderr, "Gtk Save : browse directory to populate the completion.\n");
  completion = gtk_entry_get_completion(GTK_ENTRY(entry));
  g_return_if_fail(completion);

  listOfFiles = GTK_LIST_STORE(gtk_entry_completion_get_model(completion));
  g_return_if_fail(listOfFiles);

  reParse = FALSE;
  if (!lastParsedDir)
    reParse = TRUE;
  else
    {
      dirEntry = g_path_get_dirname(fileEntry);
      DBG_fprintf(stderr, "Gtk Save : current and last directories...\n %s\n %s\n",
		  dirEntry, lastParsedDir);
      if (strcmp(dirEntry, lastParsedDir))
	reParse = TRUE;
      g_free(dirEntry);
    }

  DBG_fprintf(stderr, "Gtk Save : reparse is needed : %d.\n", reParse);

  if (!reParse)
    {
      gtk_entry_completion_complete(completion);
      return;
    }

  gtk_list_store_clear(listOfFiles);
  dirEntry = g_path_get_dirname(fileEntry);
  g_free(lastParsedDir);
  lastParsedDir = dirEntry;
  dirBrowsed = g_filename_from_utf8(dirEntry, -1, &lu, &ecrit, NULL);
  gdir = g_dir_open(dirBrowsed, 0, NULL);
  if (!gdir)
    {
      g_free(dirBrowsed);
      return;
    }
  fileFromDir = g_dir_read_name(gdir);
  while (fileFromDir)
    {
/*       DBG_fprintf(stderr, "Gtk Save : adding '%s' to completion list.\n", fileFromDir); */
      fileUTF8 = g_filename_from_utf8(fileFromDir, -1, NULL, NULL, NULL);
      if(fileUTF8)
	{
	  saveFile = g_build_filename(dirBrowsed, fileFromDir, NULL);
	  if (g_file_test(saveFile, G_FILE_TEST_IS_DIR))
	    saveFileUTF8 = g_build_filename(dirEntry, fileUTF8, "/", NULL);
	  else
	    saveFileUTF8 = g_build_filename(dirEntry, fileUTF8, NULL);
	  gtk_list_store_append(listOfFiles, &iter);
	  gtk_list_store_set(listOfFiles, &iter,
			     GTK_SAVE_FILE_NAME, saveFileUTF8,
			     -1);
	  g_free(fileUTF8);
	  g_free(saveFile);
	}
      fileFromDir = g_dir_read_name(gdir);
    }
  g_free(dirBrowsed);
  DBG_fprintf(stderr, "Gtk Save : summiting new list of completion.\n");
  gtk_entry_completion_complete(completion);
  DBG_fprintf(stderr, "Gtk Save : summition OK.\n");
}
