/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD, Damien
	CALISTE, Olivier D'Astier, laboratoire L_Sim, (2001-2005)
  
	Adresses ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.
	D'ASTIER, dastier AT iie P cnam P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD and Damien
	CALISTE and Olivier D'Astier, laboratoire L_Sim, (2001-2005)

	E-mail addresses :
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.
	D'ASTIER, dastier AT iie P cnam P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef PANELSURFACES_H
#define PANELSURFACES_H

#include <gtk/gtk.h>
#include <visu_data.h>
#include <coreTools/toolOptions.h>
#include <extraFunctions/plane.h>
#include <extraGtkFunctions/gtk_toolPanelWidget.h>

/**
 * panelIsosurfacesInit:
 *
 * Should be used in the list declared in externalModules.h to be loaded by
 * V_Sim on start-up. This routine will create the #ToolPanel where the iso-surfaces
 * stuff can be done, such as creating a surface, loading a scalar field,
 * changing the properties...
 *
 * Returns: a newly created #ToolPanel object.
 */
ToolPanel* panelIsosurfacesInit();

/**
 * panelIsosurfacesSet_used:
 * @dataObj: the current #VisuData (can be NULL) ;
 * @used: a boolean.
 *
 * Change the status of the isosurface extension, drawn or not.
 *
 * Returns: TRUE if the OpenGLAskForReDraw signal should be emitted.
 */
gboolean panelIsosurfacesSet_used(VisuData *dataObj, gboolean used);

/**
 * panelIsosurfacesLoad_file:
 * @file_name: the file you want to try to load
 * @fit_to_box: whether these isosurfaces should be resized in order 
 * to fit to the current VisuBox ;
 * @data: the #VisuData to fit the box to (can be NULL if @fit_to_box
 *        is false ;
 * @table: a set of different #Option (can be NULL).
 * @box: a location to store the 6 values defining the loaded box (can
 * be NULL).
 * 
 * Tries to load the given @file_name  and if it succeeds, adds loaded surfaces 
 * to the isosurfaces panel. In all cases, all previously loaded surfaces are 
 * removed from the panel (and from memory).
 * 
 * Return value: TRUE in case of success.
 **/
gboolean panelIsosurfacesLoad_file(const char* file_name, gboolean fit_to_box,
				   VisuData *data, OptionTable *table, double **box);
gboolean panelIsosurfacesParse_XMLFile(const gchar *filename, GError **error);

/**
 * panelIsosurfacesShow_all:
 * @show: TRUE to show all surfaces, FALSE to hide them.
 * 
 * Shows or hides all surfaces and check their "draw" status in the panel accordingly.
 *
 * Returns: TRUE if surface list should be rebuild and redraw.
 **/
gboolean panelIsosurfacesShow_all(gboolean show);

/**
 * panelIsosurfacesEdit_surfaceProperties:
 * @iter: the currently selected row iter (or NULL).
 *
 * Opens a new window allowing to edit surface properties.
 **/
void panelIsosurfacesEdit_surfaceProperties(GtkTreeIter *iter);

/**
 * panelIsosurfacesAdd_withValue:
 * @filename: the name of the scalar field from which to add a surface ;
 * @value: the iso value ;
 * @name: the name used to identify the new surface (can be NULL).
 *
 * Create and add a surface created from the given scalar field. This
 * field must already be loaded. If @name is not given, the surface will
 * be called "Isosurface id" where id is an increasing counter.
 */
void panelIsosurfacesAdd_withValue(gchar *filename, float value, gchar *name);

/**
 * PanelIsosurfacesColumnId:
 * @COLUMN_FIELD_LABEL: a string, the description of the scalar field.
 * @COLUMN_FIELD_POINTER: the pointer to the #ScalarField object.
 * @NB_COLUMN_FIELD: the number of columns.
 *
 * Thesse are the description of the columns stored in the #GtkListStore
 * of this panel. See panelIsosurfacesGet_listStore() to access this liststore.
 */
typedef enum
  {
    COLUMN_FIELD_LABEL,
    COLUMN_FIELD_POINTER,
    NB_COLUMN_FIELD
  } PanelIsosurfacesColumnId;

/**
 * panelIsosurfacesGet_listStore:
 * 
 * This method gives read access to the #GtkListStore used to store
 * the scalar field files.
 *
 * Returns: the #GtkListStore used by this panel to store its scalar fields.
 *          It should be considered read-only.
 */
GtkListStore* panelIsosurfacesGet_listStore();

/**
 * panelIsosurfacesHide:
 * @planes: an array of planes to be applied (NULL terminated).
 *
 * Must be called after the initialisation of the plane subpanel. It applies the
 * masking scheme of planes on current surfaces.
 *
 * Returns: TRUE if the surface should be rebuilt.
 */
gboolean panelIsosurfacesHide(Plane **planes);

/**
 * SURFACE_NAME_STR:
 *
 * The default string used to name surfaces that are not associated to
 * any public surface ressource.
 */
#define SURFACE_NAME_STR    "Choose an id name"
/**
 * SURFACE_NAME_CHOOSE:
 *
 * The string used in the tree view to represent the surfaces that
 * don't share surface resources.
 */
#define SURFACE_NAME_CHOOSE "<span size=\"smaller\"><i>"SURFACE_NAME_STR"</i></span>"

/**
 * panelIsosurfacesGenerate_isoValues:
 * @nbValues: a location of an integer to store the number of generated values ;
 * @values: a pointer on a float array. The target of this pointer must be
 *          NULL and it will be allocated after a call to this method. Use
 *          g_free() after use to free it.
 * @name: a pointer to store a name. The target of this pointer must be
 *        NULL on enter. It is associated only if a name is given.
 * @minVal: the minimum value for the range ;
 * @maxVal: the maximum value for the range.
 * 
 * This method opens a little dialog window that is made to help the
 * user enter a list of values for creation of iso-surfaces. These values
 * are generated between @minVal and @maxVal.
 *
 * Returns: the dialog widget.
 */
GtkWidget* panelIsosurfacesGenerate_isoValues(int *nbValues, float **values,
					      gchar **name, float minVal,
					      float maxVal);

#endif
