/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef PANELDATAFILE_H
#define PANELDATAFILE_H

#include <visu_data.h>
#include <extraGtkFunctions/gtk_toolPanelWidget.h>
#include <coreTools/toolShade.h>

/**
 * panelDataFileInit:
 *
 * Should be used in the list declared in externalModules.h to be loaded by
 * V_Sim on start-up. This routine will create the #ToolPanel where the colouring
 * stuff can be done, such as choosing a colour shade, opening a file,
 * setting boundaries...
 *
 * Returns: a newly created #ToolPanel object.
 */
ToolPanel* panelDataFileInit();

/**
 * panelDataFileLoad_file:
 * @visuData: the #VisuData object to associated the data to ;
 * @file: the file to read ;
 * @new: return TRUE if the loaded data are associated for the
 *       first time to @visuData.
 *
 * Read the given data file and associate the values of each column to
 * the node. It does not update the widgets of the panel. This is done
 * to allow to change the values of the colouration before drawing the
 * widgets. See panelDataFileUpdate() to do it.
 *
 * Returns: TRUE if visuData_createAllNodes() should be called after.
 */
gboolean panelDataFileLoad_file(VisuData *visuData, gchar *file, gboolean *new);

/**
 * panelDataFileSet_use:
 * @used: a boolean.
 *
 * Set if the panel is used or not.
 */
void panelDataFileSet_use(gboolean used);
gboolean panelDataFileSet_presetShade(Shade *shade);

/**
 * panelDataFileUpdate:
 * @visuData: the #VisuData object to associated the data to.
 *
 * Update the widgets depending on the colouration associated to the given
 * #VisuData object.
 */
void panelDataFileUpdate(VisuData *visuData);

#endif

