/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_PUBLIC_H
#define VISU_PUBLIC_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "visu_tools.h"
#include "visu_dump.h"
#include "visu_rendering.h"

#include "extraGtkFunctions/gtk_toolPanelWidget.h"


/**
 * GTK_MAIN_TYPE:
 *
 * return the type of #GtkMain.
 */
#define GTK_MAIN_TYPE	     (gtkMain_get_type ())
/**
 * GTK_MAIN:
 * @obj: a #GObject to cast.
 *
 * Cast the given @obj into #GtkMain type.
 */
#define GTK_MAIN(obj)	     (G_TYPE_CHECK_INSTANCE_CAST(obj, GTK_MAIN_TYPE, GtkMain))
/**
 * GTK_MAIN_CLASS:
 * @klass: a #GClassObject to cast.
 *
 * Cast the given @klass into #GtkMainClass.
 */
#define GTK_MAIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST(klass, GTK_MAIN_TYPE, GtkMainClass))
/**
 * IS_GTK_MAIN_TYPE:
 * @obj: a #GObject to test.
 *
 * Test if the given @ogj is of the type of #GtkMain object.
 */
#define IS_GTK_MAIN_TYPE(obj)    (G_TYPE_CHECK_INSTANCE_TYPE(obj, GTK_MAIN_TYPE))
/**
 * IS_GTK_MAIN_CLASS:
 * @klass: a #GClassObject to test.
 *
 * Test if the given @klass is of the type of #GtkMainClass class.
 */
#define IS_GTK_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE(klass, GTK_MAIN_TYPE))
/**
 * GTK_MAIN_GET_CLASS:
 * @obj: a #GObject to get the class of.
 *
 * It returns the class of the given @obj.
 */
#define GTK_MAIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(obj, GTK_MAIN_TYPE, GtkMainClass))

/**
 * GtkMain:
 *
 * A short way to identify #_GtkMain structure.
 */
typedef struct _GtkMain GtkMain;
/**
 * GtkMain_private:
 *
 * Private fields for #ViuData objects.
 */
typedef struct GtkMain_private_struct GtkMain_private;
/**
 * GtkMainClass:
 *
 * A short way to identify #_GtkMainClass structure.
 */
typedef struct _GtkMainClass GtkMainClass;

/**
 * GtkMain:
 * @parent: the parent object, a #GtkWindow here ;
 * @renderingWindow: a pointer on the associated rendering window ;
 * @pairsDialog: a pointer to the corresponding pair dialog, or NULL
 * if not yet built ;
 * @interactiveDialog: idem for the interactive dialog ;
 * @aboutDialog: idem for the about dialog ;
 * @private: a pointer to the private data.
 *
 * This structure describes a #GtkMain object.
 */
struct _GtkMain
{
  GtkWindow parent;

  /* Pointers on permanent windows. */
  GtkWidget *renderingWindow;

  GtkWidget *pairsDialog;

  GtkWidget *interactiveDialog;

  GtkWidget *aboutDialog;

  /* Private data. */
  GtkMain_private *private;
};

/**
 * gtkMain_get_type:
 *
 * This method returns the type of #GtkMain, use GTK_MAIN_TYPE instead.
 *
 * Returns: the type of #GtkMain.
 */
GType gtkMain_get_type(void);

/**
 * currentRenderingWindow:
 *
 * TO BE REMOVED, do not use.
 */
#define currentRenderingWindow RENDERING_WINDOW(gtkMainClassGet_currentPanel()->renderingWindow)

/**
 * gtkMainNew:
 *
 * Create the command panel window and is dependencies, such as the
 * associated rendering window... WARNING: some part are still currently
 * static, so only once instance can be created at a time.
 *
 * Returns: a newly create command panel.
 */
GtkWidget* gtkMainNew();

/**
 * gtkMain_quit:
 *
 * Quit the program. If the preference to have a confirm dialog is set,
 * then it raises the little warning window before quiting (or not).
 */
void gtkMain_quit();


/**
 * gtkMainClassGet_lastOpenDirectory:
 *
 * V_Sim stores the last open directory to set the file chooser to
 * this one the next time it will come. Use
 * gtkMainClassSet_lastOpenDirectory() to store it after a GTK_RESPONSE_OK
 * has been returned by a file chooser and then initialise each new
 * with this routine.
 *
 * Returns: a string owned by V_Sim.
 */
gchar* gtkMainClassGet_lastOpenDirectory();
/**
 * gtkMainClassSet_lastOpenDirectory:
 * @directory: a full path to a directory.
 *
 * V_Sim stores the last open directory to set the file chooser to
 * this one the next time it will come. Use this routine each time a
 * file chooser returns GTK_RESPONSE_OK. The given string will be
 * copied and can be freed after use.
 */
void gtkMainClassSet_lastOpenDirectory(char* directory);








/**
 * gtkMainClassSet_rememberPosition:
 * @val: an boolean.
 *
 * V_Sim can try to remember the position of its main windows, then
 * open them again will result in a positioning on screen equivalent
 * to previous position.
 */
void gtkMainClassSet_rememberPosition(gboolean val);
/**
 * gtkMainClassGet_rememberPosition:
 *
 * V_Sim can store the position of its main windows. Use this routine
 * to get the status of this capability.
 *
 * Returns: TRUE if set.
 */
gboolean gtkMainClassGet_rememberPosition();





/**
 * createGtkWidgetFunc:
 *
 * This prototype is used whenever a method is required to create a GtkWidget.
 *
 * Returns: a newly created GtkWidget.
 */
typedef GtkWidget* (*createGtkWidgetFunc)(void);

/**
 * GtkMainSetFilesFunc:
 * @data: a #VisuData to store the informations ;
 * @parent: the parent window of the dialog.
 * 
 * Methods that conform to this prototype is used to set filename(s)
 * to be loaded when the 'load' button is pushed. They can use a
 * #GtkFileChooser to prompt the user for file names.
 *
 * Returns: FALSE if no filename as been set, TRUE if the calling method should
 *          call gtkMainLoadAndRender_file() with a g_idle_add method.
 */
typedef gboolean (*GtkMainSetFilesFunc)(VisuData *data, GtkWindow *parent);

/**
 * gtkMainClassSet_renderingSpecificMethods:
 * @method: a #RenderingMethod object;
 * @methodLoad: a #GtkMainSetFilesFunc method (can be NULL).
 *
 * This function is used by a client to add gtk methods to a rendering method.
 * The @methodLoad argument is called to when the 'load' button is pushed.
 */
void gtkMainClassSet_renderingSpecificMethods(RenderingMethod *method,
					      GtkMainSetFilesFunc methodLoad);
/**
 * gtkMainClassGet_renderingSpecificOpen:
 * @method: a #RenderingMethod object.
 *
 * This method is used to retrieve the #GtkMainSetFilesFunc associate with
 * the specified @method.
 *
 * Returns: a load method if one has been specified for @method
 *          or gtkMainClassSet_fileFromDefaultFileChooser().
 */
GtkMainSetFilesFunc gtkMainClassGet_renderingSpecificOpen(RenderingMethod *method);

/**
 * gtkMainClassGet_currentPanel:
 *
 * This routine can be used to get the command panel, everywhere from
 * V_Sim.
 *
 * Returns: the command Panel.
 */
GtkMain* gtkMainClassGet_currentPanel();
/**
 * gtkMainClassSet_currentPanel:
 * @main: a command panel.
 *
 * After having created the command panel with gtkMainNew(), use this
 * routine to declare it as the current command panel.
 */
void gtkMainClassSet_currentPanel(GtkMain *main);

#endif
