/* ========================================================================== */
/* === umfpack_free_numeric ================================================= */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

void umfpack_free_numeric
(
    void **Numeric
) ;

void umfpack_l_free_numeric
(
    void **Numeric
) ;

/*
int Syntax:

    #include "umfpack.h"
    void *Numeric ;
    umfpack_free_numeric (&Numeric) ;

long Syntax:

    #include "umfpack.h"
    void *Numeric ;
    umfpack_l_free_numeric (&Numeric) ;

Purpose:

    Deallocates the Numeric object and sets the Numeric handle to NULL.
    This routine is the only valid way of destroying the Numeric object;
    any other action (such as using "free (Numeric) ;" or not freeing Numeric
    at all) will lead to memory leaks.

Arguments:

    void **Numeric ;		Input argument, deallocated and Numeric is
				set to (void *) NULL on output.

	Numeric must point to a valid Numeric object, computed by
	umfpack_numeric.  No action is taken if Numeric is a (void *) NULL
	pointer.

*/

