//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Peter A. Buhr 1994
// 
// uDebug.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Sat Dec 18 13:04:26 1993
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Aug  5 14:44:35 2005
// Update Count     : 107
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uDebug.h>

#include <cstdio>
#include <cstring>
#include <cerrno>
#include <cstdarg>
#include <unistd.h>					// write

#if defined( __solaris__ ) && ! defined( __U_PTHREAD__ )
#include <sys/lwp.h>
#endif // __solaris__ && ! __U_PTHREAD__


// This debug print uses its own buffer or a supplied buffer to build the
// output string to ensure that there are no calls to malloc at the file buffer
// level. Therefore, it is safe to call this routine from inside the memory
// management routines because there will be no recursive calls to allocate
// memory.

static char buffer[512];

// SKULLDUGGERY: The debug spin lock has to be available at the same time as
// the heap routines to allow debugging them. Since the initial value of a spin
// lock are zero and static storage is initialized to zero, this works out.

char uDebugLockStorage[sizeof(uSpinLock)] __attribute__(( aligned (16) )) = {0};
#define uDebugLock ((uSpinLock *)&uDebugLockStorage)


void uDebugAcquire() {
    uDebugLock->acquire();
    sprintf( buffer, "(%ld) ", (long int)
#if defined( __U_PTHREAD__ )
	     uRealPthread::pthread_self()
#elif defined( __solaris__ )
	     _lwp_self()				// always print the UNIX pid
#else
	     getpid()					// always print the UNIX pid
#endif
	);
    for ( ;; ) {
	int code = write( 2, buffer, strlen(buffer) );
      if ( code != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
} // uDebugAcquire


void uDebugRelease() {
    uDebugLock->release();
} // uDebugRelease


extern "C" void uDebugPrt( const char fmt[], ... ) {
    va_list args;

    va_start( args, fmt );
    uDebugLock->acquire();
    sprintf( buffer, "(%ld) ", (long int)
#if defined( __U_PTHREAD__ )
	     uRealPthread::pthread_self()
#elif defined( __solaris__ )
	     _lwp_self()				// always print the UNIX pid
#else
	     getpid()					// always print the UNIX pid
#endif
	);
    vsprintf( buffer + strlen(buffer), fmt, args );	// and after that the message
    for ( ;; ) {
	int code = write( 2, buffer, strlen(buffer) );
      if ( code != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
    uDebugRelease();
    va_end( args );
} // uDebugPrt


// No lock to allow printing after explicitly acquiring the lock.

extern "C" void uDebugPrt2( const char fmt[], ... ) {
    va_list args;

    va_start( args, fmt );
    vsprintf( buffer, fmt, args );
    for ( ;; ) {
	int code = write( 2, buffer, strlen(buffer) );
      if ( code != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
    va_end( args );
} // uDebugPrt2


// No lock to allow printing in potential deadlock situations.

extern "C" void uDebugPrtBuf( char buffer[], const char fmt[], ... ) {
    va_list args;

    va_start( args, fmt );
    sprintf( buffer, "(%ld) ", (long int)
#if defined( __U_PTHREAD__ )
	     uRealPthread::pthread_self()
#elif defined( __solaris__ )
	     _lwp_self()				// always print the UNIX pid
#else
	     getpid()					// always print the UNIX pid
#endif
	);
    vsprintf( buffer + strlen(buffer), fmt, args );	// and after that the message
    for ( ;; ) {
	int code = write( 2, buffer, strlen(buffer) );
      if ( code != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
    va_end( args );
} // uDebugPrt


// Local Variables: //
// compile-command: "gmake install" //
// End: //
