/* from old <asm/system.h> */
#define __cli()		__asm__ __volatile__("cli": : :"memory")
#define __sti()		__asm__ __volatile__("sti": : :"memory")

#include <sys/io.h>
#include <stdio.h>

/*
 * enable/disable IR on IBM ThinkPads with
 * Programmable Option Select (e.g., the 760 and 765)
 */

int main(int argc, char **argv)
{
    int val94, mask;
    int enable;

    if (argc != 2) {
        printf("usage: tpctlir (0|1)\n");
        return 1;
    } else if (strcmp(argv[1], "0") == 0) {
        enable = 0;
    } else if (strcmp(argv[1], "1") == 0) {
        enable = 1;
    } else {
        printf("usage: tpctlir (0|1)\n");
        return 1;
    }

    if ( iopl(3) ) {
        fprintf(stderr, "Permission denied - are you root?\n");
        return 2;
    }

    __cli();

    val94 = inb(0x94);              /* POS mask register */
    outb(0xfE, 0x94);               /* mask bit (0) for IR; changes enabled */
    outb(0xfE, 0x47);               /* pause */

    mask = inb(0x0102);             /* POS enable register */
    mask &= 0xFE;                   /* mask bit (0) for IR enable/disable*/
    mask |= enable;                 /* 1 to enable, 0 to disable */
    outb(mask, 0x102);
    outb(mask, 0x47);               /* pause */

    outb(val94, 0x94);              /* restore POS mask to prevent changing */
    outb(val94, 0x47);              /* pause */

    __sti();

    return 0;
}
