/* alarms.h -- Linux replacement for Toshiba's MaxTime(tm)
 *
 * Copyright (c) 1996-99  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * $Log: alarms.h,v $
 * Revision 1.1  1999/05/25 08:07:42  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef ALARMS_H
#define ALARMS_H

enum {
	NEVER_ALARM   = 0x00,
	TIME_ALARM    = 0x01,
	PERCENT_ALARM = 0x02,
	BOTH_ALARM    = 0x03
};

enum {
	LOW_ALARM      = 0x1000,
	CRITICAL_ALARM = 0x2000
};

typedef struct {
	int hour;
	int minute;
	int percent;
	int trigger;
} BatteryAlarm;


void SetAlarmDefaultsCallback(GtkWidget *widget, gpointer *data);
void SaveAlarmSettingsCallback(GtkWidget *widget, gpointer *data);
void AlarmCancelCallback(GtkWidget *widget, GtkWidget *dialog);
void AlarmDialog(GtkWidget *window);

#endif
