// Copyright (C) 2002 Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
//                and David E. Stewart (david.stewart@anu.edu.au)
//                and Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MX_SYM_EIG_INC
#define MX_SYM_EIG_INC

#include "Vec.h"
#include "Mat.h"
#include "mx_givens.h"
#include "mx_hessenberg.h"

namespace Torch {

/**
	Routines for symmetric eigenvalue problems.

  Based on the "Meschach Library", available at the
  anonymous ftp site thrain.anu.edu.au in the directory
  pub/meschach.
  
  @author David E. Stewart (david.stewart@anu.edu.au)
  @author Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
  @author Ronan Collobert (collober@iro.umontreal.ca)
*/
//@{

/** Finds eigenvalues of symmetric tridiagonal matrices.
    The matrix is represented by a pair of vectors #a# (diag entries)
		and #b# (sub-diag and super-diag entries).
    Eigenvalues in #a# on return, and eigenvectors in #mat_q#, if this one
    is not #NULL#.
*/
void mxTriEig(Vec * a, Vec * b, Mat * mat_q);

/** Computes eigenvalues of a dense symmetric matrix.
	  #mat_a# \emph{must} be symmetric on entry.
    Eigenvalues stored in #out#.
    #mat_q# contains orthogonal matrix of eigenvectors if not #NULL#.
*/
void mxSymEig(Mat * mat_a, Mat * mat_q, Vec * out);

//@}


}

#endif
