// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef NORMALIZE_INC
#define NORMALIZE_INC

#include "general.h"

namespace Torch {

/** Compute means and variances for normalizing a matrix.
    Returns in
    \begin{itemize}
      \item #mean_buff# means table of each columns of #tab#.
      \item #std_buff# the standard deviations table.
    \end{itemize}
      
    Note: the memory allocation is not made by this function.

    #n_ex# is the number of examples in #tab#, and #n_dim# is
    the dimension of each example.

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
void MSTDVNormalize(real **tab, real *mean_buff, real *std_buff, int n_ex, int n_dim);

/** Compute means and variances for normalizing a \emph{sparse} matrix.
    Returns in
    \begin{itemize}
      \item #mean_buff# means table of each columns of #tab#.
      \item #std_buff# the standard deviations table.
    \end{itemize}
      
    Note: the memory allocation is not made by this function.

    #n_ex# is the number of examples in #tab#, and #n_dim# is
    the dimension of each example.

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
void MSTDVSparseNormalize(sreal **tab, real *mean_buff, real *std_buff, int n_ex, int n_dim);


}

#endif
