// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include "log_add.h"
#include "general.h"

namespace Torch {


real log_add(real log_a, real log_b)
{
  if (log_a < log_b) {
    real tmp = log_a;
    log_a = log_b;
    log_b = tmp;
  }

  real minusdif = log_b - log_a;
  if (isnan(minusdif))
    error("minusdif (%f) log_b (%f) or log_a (%f) is nan",minusdif,log_b,log_a);

  if (minusdif < MINUS_LOG_THRESHOLD)
    return log_a;
  else
    return log_a + log1p(exp(minusdif));
}

real log_sub(real log_a, real log_b)
{
  if (log_a < log_b)
    error("log_sub: log_a (%f) should be greater than log_b (%f)", log_a, log_b);

  real minusdif = log_b - log_a;
  if (isnan(minusdif))
    error("minusdif (%f) log_b (%f) or log_a (%f) is nan",minusdif,log_b,log_a);

  if (log_a == log_b)
    return LOG_ZERO;
  else if (minusdif < MINUS_LOG_THRESHOLD)
    return log_a;
  else
    return log_a + log1p(-exp(minusdif));
}


}

