// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef QC_MACHINE_INC
#define QC_MACHINE_INC

#include "Machine.h"

namespace Torch {

/** "Quadratic Constrained Machine".
    It's a machine with #alpha# parameters which
    are the minimum of a constrained quadratic problem.

    The problem:

    minimize $QP(alpha) = alpha' * Q * alpha + beta'*alpha$
    
    with the following constraints:
         \begin{itemize}
           \item $\sum_j alpha_j y_j = 1$
           \item $Cdown_j <= alpha_j <= Cup_j$
         \end{itemize}

    where $y$, $Cdown$, $Cup$ are given by the user
    and $y_j = +- 1$.

    The number of #alpha# variable is determined here by #l#.
    (Therefore, it determines the size of de Cup, Cdown et y...)

    Note: if $alpha_j$ is closed to $Cup_j$ [ou $Cdown_j$] with
          the accuracy "eps bounds", $alpha_j$ is considered
          to be equal to $Cup_j$ [ou $Cdown_j$].

    Options:
    \begin{tabular}{lcll}
      "eps bounds"  &  real  &  bound accuracy: & [1E-4 in float, 1E-12 in double]
    \end{tabular}

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class QCMachine : public Machine
{
  public:

    ///
    real *Cup;

    ///
    real *Cdown;

    ///
    real eps_bornes;

    ///
    int l;

    ///
    real *alpha;

    ///
    real *grad;

    ///
    real *y;

    //-----

    ///
    QCMachine();

    /** Function called by #QCTrainer# after the optimization.
        @see QCTrainer
    */
    virtual void checkSupportVectors() = 0;

    //-----

    virtual ~QCMachine();    
};


}

#endif
